/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.component.DyedItemColor;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_21_R2.inventory.SerializableMeta;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ColorableArmorMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaColorableArmor
extends CraftMetaArmor
implements ColorableArmorMeta {
    private Integer color;

    CraftMetaColorableArmor(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaColorableArmor)) {
            return;
        }
        CraftMetaColorableArmor armorMeta = (CraftMetaColorableArmor)meta;
        this.color = armorMeta.color;
    }

    CraftMetaColorableArmor(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaColorableArmor.getOrEmpty(tag, CraftMetaLeatherArmor.COLOR).ifPresent(dyedItemColor -> {
            if (!dyedItemColor.b()) {
                this.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            }
            this.color = dyedItemColor.a();
        });
    }

    CraftMetaColorableArmor(Map<String, Object> map) {
        super(map);
        CraftMetaLeatherArmor.readColor((LeatherArmorMeta)this, map);
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemTag) {
        super.applyToItem(itemTag);
        if (this.hasColor()) {
            itemTag.put(CraftMetaLeatherArmor.COLOR, new DyedItemColor(this.color, !this.hasItemFlag(ItemFlag.HIDE_DYE)));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isLeatherArmorEmpty();
    }

    boolean isLeatherArmorEmpty() {
        return !this.hasColor();
    }

    @Override
    public CraftMetaColorableArmor clone() {
        CraftMetaColorableArmor clone = (CraftMetaColorableArmor)super.clone();
        clone.color = this.color;
        return clone;
    }

    public Color getColor() {
        return this.color == null ? CraftItemFactory.DEFAULT_LEATHER_COLOR : Color.fromRGB((int)(this.color & 0xFFFFFF));
    }

    public void setColor(Color color) {
        this.color = color == null ? null : Integer.valueOf(color.asRGB());
    }

    boolean hasColor() {
        return this.color != null;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        CraftMetaLeatherArmor.serialize((LeatherArmorMeta)this, builder);
        return builder;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaColorableArmor) {
            CraftMetaColorableArmor that = (CraftMetaColorableArmor)meta;
            return this.hasColor() ? that.hasColor() && this.color.equals(that.color) : !that.hasColor();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaColorableArmor || this.isLeatherArmorEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasColor()) {
            hash ^= this.color.hashCode();
        }
        return original != hash ? CraftMetaColorableArmor.class.hashCode() ^ hash : hash;
    }

    public boolean isDyed() {
        return this.hasColor();
    }
}

