/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.inventory.trim;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftTrimMaterial
implements org.bukkit.inventory.meta.trim.TrimMaterial,
Handleable<TrimMaterial> {
    private final NamespacedKey key;
    private final TrimMaterial handle;

    public static org.bukkit.inventory.meta.trim.TrimMaterial minecraftToBukkit(TrimMaterial minecraft) {
        return (org.bukkit.inventory.meta.trim.TrimMaterial)CraftRegistry.minecraftToBukkit(minecraft, Registries.aZ, Registry.TRIM_MATERIAL);
    }

    public static org.bukkit.inventory.meta.trim.TrimMaterial minecraftHolderToBukkit(Holder<TrimMaterial> minecraft) {
        return CraftTrimMaterial.minecraftToBukkit(minecraft.a());
    }

    public static TrimMaterial bukkitToMinecraft(org.bukkit.inventory.meta.trim.TrimMaterial bukkit) {
        return (TrimMaterial)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<TrimMaterial> bukkitToMinecraftHolder(org.bukkit.inventory.meta.trim.TrimMaterial bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aZ);
        Holder<TrimMaterial> holder = registry.e(CraftTrimMaterial.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own trim material without properly registering it.");
    }

    public CraftTrimMaterial(NamespacedKey key, TrimMaterial handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public TrimMaterial getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return Objects.requireNonNull(Registry.TRIM_MATERIAL.getKey((Keyed)this), () -> String.valueOf(this) + " doesn't have a key");
    }

    @NotNull
    public String getTranslationKey() {
        if (!(this.handle.e().b() instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        return ((TranslatableContents)this.handle.e().b()).b();
    }

    public Component description() {
        return PaperAdventure.asAdventure(this.handle.e());
    }
}

