/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.inventory.trim;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public class CraftTrimPattern
implements TrimPattern,
Handleable<net.minecraft.world.item.equipment.trim.TrimPattern> {
    private final NamespacedKey key;
    private final net.minecraft.world.item.equipment.trim.TrimPattern handle;

    public static TrimPattern minecraftToBukkit(net.minecraft.world.item.equipment.trim.TrimPattern minecraft) {
        return (TrimPattern)CraftRegistry.minecraftToBukkit(minecraft, Registries.ba, Registry.TRIM_PATTERN);
    }

    public static TrimPattern minecraftHolderToBukkit(Holder<net.minecraft.world.item.equipment.trim.TrimPattern> minecraft) {
        return CraftTrimPattern.minecraftToBukkit(minecraft.a());
    }

    public static net.minecraft.world.item.equipment.trim.TrimPattern bukkitToMinecraft(TrimPattern bukkit) {
        return (net.minecraft.world.item.equipment.trim.TrimPattern)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<net.minecraft.world.item.equipment.trim.TrimPattern> bukkitToMinecraftHolder(TrimPattern bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.ba);
        Holder<net.minecraft.world.item.equipment.trim.TrimPattern> holder = registry.e(CraftTrimPattern.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own trim pattern without properly registering it.");
    }

    public CraftTrimPattern(NamespacedKey key, net.minecraft.world.item.equipment.trim.TrimPattern handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public net.minecraft.world.item.equipment.trim.TrimPattern getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return Objects.requireNonNull(Registry.TRIM_PATTERN.getKey((Keyed)this), () -> String.valueOf(this) + " doesn't have a key");
    }

    @NotNull
    public String getTranslationKey() {
        if (!(this.handle.c().b() instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        return ((TranslatableContents)this.handle.c().b()).b();
    }

    public Component description() {
        return PaperAdventure.asAdventure(this.handle.c());
    }
}

