/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.legacy.reroute;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.craftbukkit.v1_21_R2.legacy.reroute.RerouteMethodData;
import org.bukkit.craftbukkit.v1_21_R2.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R2.util.ClassTraverser;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.Type;

public class Reroute {
    @VisibleForTesting
    final Map<String, RerouteDataHolder> rerouteDataMap;

    Reroute(Map<String, RerouteDataHolder> rerouteDataMap) {
        this.rerouteDataMap = rerouteDataMap;
    }

    public boolean apply(ApiVersion pluginVersion, String owner, String name, String desc, boolean staticCall, Consumer<RerouteMethodData> consumer) {
        Class<?> ownerClass;
        RerouteDataHolder rerouteData = this.rerouteDataMap.get(desc + name);
        if (rerouteData == null) {
            return false;
        }
        Type ownerType = Type.getObjectType((String)owner);
        RerouteMethodData data = rerouteData.get(ownerType);
        if (staticCall && data == null) {
            return false;
        }
        if (data != null) {
            if (data.requiredPluginVersion() != null && !data.requiredPluginVersion().test(pluginVersion)) {
                return false;
            }
            consumer.accept(data);
            return true;
        }
        try {
            ownerClass = Class.forName(ownerType.getClassName(), false, Reroute.class.getClassLoader());
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        ClassTraverser it = new ClassTraverser(ownerClass);
        while (it.hasNext()) {
            Object clazz = it.next();
            data = rerouteData.get(Type.getType((Class)clazz));
            if (data == null) continue;
            if (data.requiredPluginVersion() != null && !data.requiredPluginVersion().test(pluginVersion)) {
                return false;
            }
            consumer.accept(data);
            return true;
        }
        return false;
    }

    static class RerouteDataHolder {
        @VisibleForTesting
        final Map<String, RerouteMethodData> rerouteMethodDataMap = new HashMap<String, RerouteMethodData>();

        RerouteDataHolder() {
        }

        public RerouteMethodData get(Class<?> clazz) {
            return this.rerouteMethodDataMap.get(Type.getInternalName(clazz));
        }

        private RerouteMethodData get(Type owner) {
            return this.rerouteMethodDataMap.get(owner.getInternalName());
        }

        void add(RerouteMethodData value) {
            RerouteMethodData rerouteMethodData = this.get(value.sourceOwner());
            if (rerouteMethodData != null) {
                throw new IllegalStateException("Reroute method data already exists: " + String.valueOf(rerouteMethodData));
            }
            this.rerouteMethodDataMap.put(value.sourceOwner().getInternalName(), value);
        }
    }
}

