/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.util;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.attribute.UnmodifiableAttributeMap;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEventManager;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R2.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R2.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R2.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R2.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R2.util.Commodore;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftNamespacedKey;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final CraftMagicNumbers INSTANCE = new CraftMagicNumbers();
    public static final boolean DISABLE_OLD_API_SUPPORT = Boolean.getBoolean("paper.disableOldApiSupport");
    private final Commodore commodore = new Commodore();
    private static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    private static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    private static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();
    private Biome customBiome;

    private CraftMagicNumbers() {
    }

    public ComponentFlattener componentFlattener() {
        return PaperAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return GsonComponentSerializer.colorDownsamplingGson();
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return GsonComponentSerializer.gson();
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return PaperAdventure.PLAIN;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return PlainTextComponentSerializer.plainText();
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return LegacyComponentSerializer.legacySection();
    }

    public Component resolveWithContext(Component component, CommandSender context, Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        return PaperAdventure.resolveWithContext(component, context, scoreboardSubject, bypassPermissions);
    }

    public static IBlockData getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static IBlockData getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(IBlockData data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.b())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static MinecraftKey key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public static byte toLegacyData(IBlockData data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic<NBTTagString> name = new Dynamic<NBTTagString>(DynamicOpsNBT.a, NBTTagString.a("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = DataConverterRegistry.a().update(DataConverterTypes.D, name, version, this.getDataVersion())))) {
            converted = DataConverterRegistry.a().update(DataConverterTypes.C, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    public String getMappingsVersion() {
        return "61a218cda78417b6039da56e08194083";
    }

    public int getDataVersion() {
        return SharedConstants.b().d().c();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.b(new ArgumentParserItemStack(CommandDispatcher.a(MinecraftServer.getDefaultRegistryAccess())).a(new StringReader(arguments)).b());
        }
        catch (CommandSyntaxException ex) {
            LogUtils.getClassLogger().error("Exception modifying ItemStack", new Throwable(ex));
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().a(SavedFile.j).toFile(), "bukkit");
    }

    public org.bukkit.advancement.Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement((NamespacedKey)key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        MinecraftKey minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = JsonParser.parseString((String)advancement);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().a(JsonOps.INSTANCE);
        Advancement nms = (Advancement)Advancement.a.parse(ops, (Object)jsonelement).getOrThrow(JsonParseException::new);
        if (nms != null) {
            org.bukkit.advancement.Advancement bukkit;
            AdvancementNode root;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            mapBuilder.putAll(MinecraftServer.getServer().aD().b);
            AdvancementHolder holder = new AdvancementHolder(minecraftkey, nms);
            mapBuilder.put((Object)minecraftkey, (Object)holder);
            MinecraftServer.getServer().aD().b = mapBuilder.build();
            AdvancementTree tree = MinecraftServer.getServer().aD().a();
            tree.a(List.of(holder));
            AdvancementNode node = tree.a(minecraftkey);
            if (node != null && (root = node.d()).b().b().c().isPresent()) {
                TreeNodePosition.a(root);
            }
            if ((bukkit = Bukkit.getAdvancement((NamespacedKey)key)) != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + String.valueOf(key), ex);
                }
                MinecraftServer.getServer().ag().t().forEach(player -> {
                    player.S().a(MinecraftServer.getServer().aD());
                    player.S().b((EntityPlayer)player);
                });
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(pdf.getAPIVersion());
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
        }
        if (toCheck.isOlderThan(minimumVersion)) {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
        if (!DISABLE_OLD_API_SUPPORT && toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            CraftLegacy.init();
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        if (DISABLE_OLD_API_SUPPORT) {
            return ReflectionRemapper.processClass(clazz);
        }
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), ((CraftServer)Bukkit.getServer()).activeCompatibilities);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ItemType item = material.asItemType();
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)(String.valueOf(material) + " is not an item and does not have default attributes"));
        return item.getDefaultAttributeModifiers(slot);
    }

    public CreativeCategory getCreativeCategory(Material material) {
        return material.getCreativeCategory();
    }

    public String getBlockTranslationKey(Material material) {
        return material.getBlockTranslationKey();
    }

    public String getItemTranslationKey(Material material) {
        return material.getItemTranslationKey();
    }

    public String getTranslationKey(EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        return EntityTypes.a(entityType.getName()).map(EntityTypes::g).orElseThrow();
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.h().l();
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        if (apiVersion == null) {
            return false;
        }
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(apiVersion);
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        return !toCheck.isNewerThan(ApiVersion.CURRENT) && !toCheck.isOlderThan(minimumVersion);
    }

    public String getTranslationKey(Attribute attribute) {
        return attribute.getTranslationKey();
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey namespacedKey) {
        PotionRegistry potionRegistry = (PotionRegistry)CraftRegistry.getMinecraftRegistry(Registries.ad).b(CraftNamespacedKey.toMinecraft(namespacedKey)).orElseThrow();
        return new CraftPotionType(namespacedKey, potionRegistry);
    }

    public DamageEffect getDamageEffect(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        return CraftDamageEffect.getById(key);
    }

    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public String get(Class<?> aClass, String s2) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s2);
        }
        return s2;
    }

    public <B extends Keyed> B get(Registry<B> registry, NamespacedKey namespacedKey) {
        return CraftRegistry.get(registry, namespacedKey, ApiVersion.CURRENT);
    }

    public Biome getCustomBiome() {
        if (this.customBiome == null) {
            this.customBiome = new CraftBiome(NamespacedKey.minecraft((String)"custom"), null);
        }
        return this.customBiome;
    }

    public VersionFetcher getVersionFetcher() {
        return new PaperVersionFetcher();
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((item.getType() != Material.AIR ? 1 : 0) != 0, (Object)"air cannot be serialized");
        return this.serializeNbtToBytes((NBTTagCompound)(item instanceof CraftItemStack ? ((CraftItemStack)item).handle : CraftItemStack.asNMSCopy(item)).a(MinecraftServer.getServer().ba()));
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.h("DataVersion");
        compound = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, compound, dataVersion, this.getDataVersion());
        return CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.a((HolderLookup.a)MinecraftServer.getServer().ba(), (NBTBase)compound).orElseThrow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject serializeItemAsJson(ItemStack itemStack) {
        JsonObject item;
        Preconditions.checkNotNull((Object)itemStack, (Object)"Cannot serialize empty ItemStack");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot serialize empty ItemStack");
        IRegistryCustom.Dimension reg = MinecraftServer.getServer().ba();
        RegistryOps ops = reg.a(JsonOps.INSTANCE);
        CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(true);
        try {
            item = ((JsonElement)net.minecraft.world.item.ItemStack.a.encodeStart(ops, (Object)CraftItemStack.unwrap(itemStack)).getOrThrow()).getAsJsonObject();
        }
        finally {
            CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(false);
        }
        item.addProperty("DataVersion", (Number)this.getDataVersion());
        return item;
    }

    public ItemStack deserializeItemFromJson(JsonObject data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        int dataVersion = data.get("DataVersion").getAsInt();
        int currentVersion = INSTANCE.getDataVersion();
        data = MCDataConverter.convertJson(MCTypeRegistry.ITEM_STACK, data, false, dataVersion, currentVersion);
        RegistryOps ops = MinecraftServer.getServer().ba().a(JsonOps.INSTANCE);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.a.parse(ops, (Object)data).getOrThrow(IllegalArgumentException::new));
    }

    public byte[] serializeEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"only CraftEntities can be serialized");
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().serializeEntity(compound);
        return this.serializeNbtToBytes(compound);
    }

    public Entity deserializeEntity(byte[] data, World world, boolean preserveUUID) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.h("DataVersion");
        compound = MCDataConverter.convertTag(MCTypeRegistry.ENTITY, compound, dataVersion, this.getDataVersion());
        if (!preserveUUID) {
            compound.r("UUID");
        }
        return EntityTypes.a(compound, (net.minecraft.world.level.World)((CraftWorld)world).getHandle(), EntitySpawnReason.r).orElseThrow(() -> new IllegalArgumentException("An ID was not found for the data. Did you downgrade?")).getBukkitEntity();
    }

    private byte[] serializeNbtToBytes(NBTTagCompound compound) {
        compound.a("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a(compound, outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private NBTTagCompound deserializeNbtFromBytes(byte[] data) {
        NBTTagCompound compound;
        try {
            compound = NBTCompressedStreamTools.a(new ByteArrayInputStream(data), NBTReadLimiter.a());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.h("DataVersion");
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public int nextEntityId() {
        return net.minecraft.world.entity.Entity.nextEntityId();
    }

    public String getMainLevelName() {
        return ((DedicatedServer)MinecraftServer.getServer()).a().l;
    }

    public int getProtocolVersion() {
        return SharedConstants.b().e();
    }

    public boolean isValidRepairItemStack(ItemStack itemToBeRepaired, ItemStack repairMaterial) {
        if (!itemToBeRepaired.getType().isItem() || !repairMaterial.getType().isItem()) {
            return false;
        }
        return CraftItemStack.unwrap(itemToBeRepaired).b(CraftItemStack.unwrap(repairMaterial));
    }

    public boolean hasDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        return AttributeDefaults.b(BuiltInRegistries.f.a(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
    }

    public Attributable getDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        Preconditions.checkArgument((boolean)this.hasDefaultEntityAttributes(bukkitEntityKey), (Object)(String.valueOf(bukkitEntityKey) + " doesn't have default attributes"));
        AttributeProvider supplier = AttributeDefaults.a(BuiltInRegistries.f.a(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
        return new UnmodifiableAttributeMap(supplier);
    }

    public NamespacedKey getBiomeKey(RegionAccessor accessor, int x2, int y2, int z2) {
        return accessor.getBiome(x2, y2, z2).getKey();
    }

    public void setBiomeKey(RegionAccessor accessor, int x2, int y2, int z2, NamespacedKey biomeKey) {
        accessor.setBiome(x2, y2, z2, (Biome)Registry.BIOME.getOrThrow(biomeKey));
    }

    public String getStatisticCriteriaKey(Statistic statistic) {
        if (statistic.getType() != Statistic.Type.UNTYPED) {
            return "minecraft.custom:minecraft." + statistic.getKey().getKey();
        }
        return CraftStatistic.getNMSStatistic(statistic).d();
    }

    public List<Component> computeTooltipLines(ItemStack itemStack, TooltipContext tooltipContext, Player player) {
        TooltipFlag.a flag;
        Preconditions.checkArgument((tooltipContext != null ? 1 : 0) != 0, (Object)"tooltipContext cannot be null");
        TooltipFlag.a a2 = flag = tooltipContext.isAdvanced() ? TooltipFlag.b : TooltipFlag.a;
        if (tooltipContext.isCreative()) {
            flag = flag.c();
        }
        List<IChatBaseComponent> lines = CraftItemStack.asNMSCopy(itemStack).a(Item.b.a(player == null ? MinecraftServer.getServer().ba() : ((CraftPlayer)player).getHandle().dW().K_()), (EntityHuman)(player == null ? null : ((CraftPlayer)player).getHandle()), flag);
        return lines.stream().map(PaperAdventure::asAdventure).toList();
    }

    public Color getSpawnEggLayerColor(EntityType entityType, int layer) {
        EntityTypes<?> nmsType = CraftEntityType.bukkitToMinecraft(entityType);
        ItemMonsterEgg eggItem = ItemMonsterEgg.a(nmsType);
        return eggItem == null ? null : Color.fromRGB((int)eggItem.a(layer));
    }

    public LifecycleEventManager<Plugin> createPluginLifecycleEventManager(JavaPlugin plugin, BooleanSupplier registrationCheck) {
        return new PaperLifecycleEventManager<JavaPlugin>(plugin, registrationCheck);
    }

    public ItemStack createEmptyStack() {
        return CraftItemStack.asCraftMirror(null);
    }

    static {
        for (Block block2 : BuiltInRegistries.e) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)BuiltInRegistries.e.b(block2).a().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : BuiltInRegistries.g) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)BuiltInRegistries.g.b(item2).a().toUpperCase(Locale.ROOT)));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            MinecraftKey key = CraftMagicNumbers.key(material);
            BuiltInRegistries.g.b(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            BuiltInRegistries.e.b(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
        }
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

