/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.util;

import net.minecraft.world.entity.EnumCreatureType;
import org.bukkit.entity.SpawnCategory;

public class CraftSpawnCategory {
    public static boolean isValidForLimits(SpawnCategory spawnCategory) {
        return spawnCategory != null && spawnCategory != SpawnCategory.MISC;
    }

    public static String getConfigNameSpawnLimit(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "spawn-limits.monsters";
            case SpawnCategory.ANIMAL -> "spawn-limits.animals";
            case SpawnCategory.WATER_ANIMAL -> "spawn-limits.water-animals";
            case SpawnCategory.WATER_AMBIENT -> "spawn-limits.water-ambient";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "spawn-limits.water-underground-creature";
            case SpawnCategory.AMBIENT -> "spawn-limits.ambient";
            case SpawnCategory.AXOLOTL -> "spawn-limits.axolotls";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for spawn-limits");
        };
    }

    public static String getConfigNameTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> "ticks-per.monster-spawns";
            case SpawnCategory.ANIMAL -> "ticks-per.animal-spawns";
            case SpawnCategory.WATER_ANIMAL -> "ticks-per.water-spawns";
            case SpawnCategory.WATER_AMBIENT -> "ticks-per.water-ambient-spawns";
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> "ticks-per.water-underground-creature-spawns";
            case SpawnCategory.AMBIENT -> "ticks-per.ambient-spawns";
            case SpawnCategory.AXOLOTL -> "ticks-per.axolotl-spawns";
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static long getDefaultTicksPerSpawn(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER, SpawnCategory.WATER_ANIMAL, SpawnCategory.WATER_AMBIENT, SpawnCategory.WATER_UNDERGROUND_CREATURE, SpawnCategory.AMBIENT, SpawnCategory.AXOLOTL -> 1L;
            case SpawnCategory.ANIMAL -> 400L;
            default -> throw new UnsupportedOperationException("Unknown Config value " + String.valueOf(spawnCategory) + " for ticks-per");
        };
    }

    public static SpawnCategory toBukkit(EnumCreatureType enumCreatureType) {
        return switch (enumCreatureType) {
            case EnumCreatureType.a -> SpawnCategory.MONSTER;
            case EnumCreatureType.b -> SpawnCategory.ANIMAL;
            case EnumCreatureType.c -> SpawnCategory.AMBIENT;
            case EnumCreatureType.d -> SpawnCategory.AXOLOTL;
            case EnumCreatureType.f -> SpawnCategory.WATER_ANIMAL;
            case EnumCreatureType.g -> SpawnCategory.WATER_AMBIENT;
            case EnumCreatureType.e -> SpawnCategory.WATER_UNDERGROUND_CREATURE;
            case EnumCreatureType.h -> SpawnCategory.MISC;
            default -> throw new UnsupportedOperationException("Unknown EnumCreatureType " + String.valueOf(enumCreatureType) + " for SpawnCategory");
        };
    }

    public static EnumCreatureType toNMS(SpawnCategory spawnCategory) {
        return switch (spawnCategory) {
            case SpawnCategory.MONSTER -> EnumCreatureType.a;
            case SpawnCategory.ANIMAL -> EnumCreatureType.b;
            case SpawnCategory.AMBIENT -> EnumCreatureType.c;
            case SpawnCategory.AXOLOTL -> EnumCreatureType.d;
            case SpawnCategory.WATER_ANIMAL -> EnumCreatureType.f;
            case SpawnCategory.WATER_AMBIENT -> EnumCreatureType.g;
            case SpawnCategory.WATER_UNDERGROUND_CREATURE -> EnumCreatureType.e;
            case SpawnCategory.MISC -> EnumCreatureType.h;
            default -> throw new UnsupportedOperationException("Unknown SpawnCategory " + String.valueOf(spawnCategory) + " for EnumCreatureType");
        };
    }
}

