/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.world;

import io.papermc.paper.world.structure.ConfiguredStructure;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuresLocateEvent
extends WorldEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Location origin;
    private Result result;
    private List<ConfiguredStructure> configuredStructures;
    private int radius;
    private boolean findUnexplored;
    private boolean cancelled;

    public StructuresLocateEvent(@NotNull World world, @NotNull Location origin, @NotNull List<ConfiguredStructure> configuredStructures, int radius, boolean findUnexplored) {
        super(world);
        this.origin = origin;
        this.configuredStructures = configuredStructures;
        this.radius = radius;
        this.findUnexplored = findUnexplored;
    }

    @NotNull
    public Location getOrigin() {
        return this.origin;
    }

    @Nullable
    public Result getResult() {
        return this.result;
    }

    public void setResult(@Nullable Result result) {
        this.result = result;
    }

    @NotNull
    public List<ConfiguredStructure> getConfiguredStructures() {
        return this.configuredStructures;
    }

    public void setConfiguredStructures(@NotNull List<ConfiguredStructure> configuredStructures) {
        this.configuredStructures = new ArrayList<ConfiguredStructure>(configuredStructures);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public boolean shouldFindUnexplored() {
        return this.findUnexplored;
    }

    public void setFindUnexplored(boolean findUnexplored) {
        this.findUnexplored = findUnexplored;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public record Result(@NotNull Location position, @NotNull ConfiguredStructure configuredStructure) {
    }
}

