/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.network.NetworkClient;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.conversations.Conversable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Player
extends HumanEntity,
Conversable,
OfflinePlayer,
PluginMessageRecipient,
Identified,
NetworkClient {
    @NotNull
    default public Identity identity() {
        return Identity.identity((UUID)this.getUniqueId());
    }

    @NotNull
    public Component displayName();

    public void displayName(@Nullable Component var1);

    @Deprecated
    @NotNull
    public String getDisplayName();

    @Deprecated
    public void setDisplayName(@Nullable String var1);

    public void playerListName(@Nullable Component var1);

    @NotNull
    public Component playerListName();

    @Nullable
    public Component playerListHeader();

    @Nullable
    public Component playerListFooter();

    @Deprecated
    @NotNull
    public String getPlayerListName();

    @Deprecated
    public void setPlayerListName(@Nullable String var1);

    @Deprecated
    @Nullable
    public String getPlayerListHeader();

    @Deprecated
    @Nullable
    public String getPlayerListFooter();

    @Deprecated
    public void setPlayerListHeader(@Nullable String var1);

    @Deprecated
    public void setPlayerListFooter(@Nullable String var1);

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable String var1, @Nullable String var2);

    public void setCompassTarget(@NotNull Location var1);

    @NotNull
    public Location getCompassTarget();

    @Override
    @Nullable
    public InetSocketAddress getAddress();

    @Override
    public void sendRawMessage(@NotNull String var1);

    @Deprecated
    public void kickPlayer(@Nullable String var1);

    public void kick();

    public void kick(@Nullable Component var1);

    public void kick(@Nullable Component var1, @NotNull PlayerKickEvent.Cause var2);

    public void chat(@NotNull String var1);

    public boolean performCommand(@NotNull String var1);

    @Override
    @Deprecated
    public boolean isOnGround();

    public boolean isSneaking();

    public void setSneaking(boolean var1);

    public boolean isSprinting();

    public void setSprinting(boolean var1);

    public void saveData();

    public void loadData();

    public void setSleepingIgnored(boolean var1);

    public boolean isSleepingIgnored();

    @Override
    @Nullable
    public Location getBedSpawnLocation();

    public void setBedSpawnLocation(@Nullable Location var1);

    public void setBedSpawnLocation(@Nullable Location var1, boolean var2);

    @Deprecated
    public void playNote(@NotNull Location var1, byte var2, byte var3);

    public void playNote(@NotNull Location var1, @NotNull Instrument var2, @NotNull Note var3);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull String var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, float var3, float var4);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void stopSound(@NotNull Sound var1);

    public void stopSound(@NotNull String var1);

    public void stopSound(@NotNull Sound var1, @Nullable SoundCategory var2);

    public void stopSound(@NotNull String var1, @Nullable SoundCategory var2);

    public void stopAllSounds();

    @Deprecated
    public void playEffect(@NotNull Location var1, @NotNull Effect var2, int var3);

    public <T> void playEffect(@NotNull Location var1, @NotNull Effect var2, @Nullable T var3);

    public boolean breakBlock(@NotNull Block var1);

    @Deprecated
    public void sendBlockChange(@NotNull Location var1, @NotNull Material var2, byte var3);

    public void sendBlockChange(@NotNull Location var1, @NotNull BlockData var2);

    public void sendBlockDamage(@NotNull Location var1, float var2);

    default public void sendMultiBlockChange(@NotNull Map<Location, BlockData> blockChanges) {
        this.sendMultiBlockChange(blockChanges, false);
    }

    public void sendMultiBlockChange(@NotNull Map<Location, BlockData> var1, boolean var2);

    public void sendEquipmentChange(@NotNull LivingEntity var1, @NotNull EquipmentSlot var2, @NotNull ItemStack var3);

    default public void sendSignChange(@NotNull Location loc, @Nullable List<Component> lines) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    default public void sendSignChange(@NotNull Location loc, @Nullable List<Component> lines, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    default public void sendSignChange(@NotNull Location loc, @Nullable List<Component> lines, boolean hasGlowingText) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, DyeColor.BLACK, hasGlowingText);
    }

    public void sendSignChange(@NotNull Location var1, @Nullable List<Component> var2, @NotNull DyeColor var3, boolean var4) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2, @NotNull DyeColor var3) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2, @NotNull DyeColor var3, boolean var4) throws IllegalArgumentException;

    public void sendMap(@NotNull MapView var1);

    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason) {
        return this.banPlayerFull(reason, null, null);
    }

    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable String source) {
        return this.banPlayerFull(reason, null, source);
    }

    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayerFull(reason, expires, null);
    }

    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        this.banPlayer(reason, expires, source);
        return this.banPlayerIP(reason, expires, source, true);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, boolean kickPlayer) {
        return this.banPlayerIP(reason, null, null, kickPlayer);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable String source, boolean kickPlayer) {
        return this.banPlayerIP(reason, null, source, kickPlayer);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, boolean kickPlayer) {
        return this.banPlayerIP(reason, expires, null, kickPlayer);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason) {
        return this.banPlayerIP(reason, null, null);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable String source) {
        return this.banPlayerIP(reason, null, source);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayerIP(reason, expires, null);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.banPlayerIP(reason, expires, source, true);
    }

    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickPlayer) {
        BanEntry banEntry = Bukkit.getServer().getBanList(BanList.Type.IP).addBan(this.getAddress().getAddress().getHostAddress(), reason, expires, source);
        if (kickPlayer && this.isOnline()) {
            this.getPlayer().kickPlayer(reason);
        }
        return banEntry;
    }

    @Deprecated
    public void sendActionBar(@NotNull String var1);

    @Deprecated
    public void sendActionBar(char var1, @NotNull String var2);

    @Deprecated
    public void sendActionBar(BaseComponent ... var1);

    @Override
    @Deprecated
    default public void sendMessage(@NotNull BaseComponent component) {
        this.spigot().sendMessage(component);
    }

    @Override
    @Deprecated
    default public void sendMessage(BaseComponent ... components) {
        this.spigot().sendMessage(components);
    }

    @Deprecated
    default public void sendMessage(ChatMessageType position, BaseComponent ... components) {
        this.spigot().sendMessage(position, components);
    }

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent[] var1, @Nullable BaseComponent[] var2);

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent var1, @Nullable BaseComponent var2);

    @Deprecated
    public void setTitleTimes(int var1, int var2, int var3);

    @Deprecated
    public void setSubtitle(BaseComponent[] var1);

    @Deprecated
    public void setSubtitle(BaseComponent var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] var1, @Nullable BaseComponent[] var2, int var3, int var4, int var5);

    @Deprecated
    public void showTitle(@Nullable BaseComponent var1, @Nullable BaseComponent var2, int var3, int var4, int var5);

    @Deprecated
    public void sendTitle(@NotNull Title var1);

    @Deprecated
    public void updateTitle(@NotNull Title var1);

    @Deprecated
    public void hideTitle();

    public void updateInventory();

    @Nullable
    public GameMode getPreviousGameMode();

    public void setPlayerTime(long var1, boolean var3);

    public long getPlayerTime();

    public long getPlayerTimeOffset();

    public boolean isPlayerTimeRelative();

    public void resetPlayerTime();

    public void setPlayerWeather(@NotNull WeatherType var1);

    @Nullable
    public WeatherType getPlayerWeather();

    public void resetPlayerWeather();

    default public void giveExp(int amount) {
        this.giveExp(amount, false);
    }

    public void giveExp(int var1, boolean var2);

    public int applyMending(int var1);

    public void giveExpLevels(int var1);

    public float getExp();

    public void setExp(float var1);

    public int getLevel();

    public void setLevel(int var1);

    public int getTotalExperience();

    public void setTotalExperience(int var1);

    public void sendExperienceChange(float var1);

    public void sendExperienceChange(float var1, int var2);

    public boolean getAllowFlight();

    public void setAllowFlight(boolean var1);

    @Deprecated
    public void hidePlayer(@NotNull Player var1);

    public void hidePlayer(@NotNull Plugin var1, @NotNull Player var2);

    @Deprecated
    public void showPlayer(@NotNull Player var1);

    public void showPlayer(@NotNull Plugin var1, @NotNull Player var2);

    public boolean canSee(@NotNull Player var1);

    @ApiStatus.Experimental
    public void hideEntity(@NotNull Plugin var1, @NotNull Entity var2);

    @ApiStatus.Experimental
    public void showEntity(@NotNull Plugin var1, @NotNull Entity var2);

    @ApiStatus.Experimental
    public boolean canSee(@NotNull Entity var1);

    public boolean isFlying();

    public void setFlying(boolean var1);

    public void setFlySpeed(float var1) throws IllegalArgumentException;

    public void setWalkSpeed(float var1) throws IllegalArgumentException;

    public float getFlySpeed();

    public float getWalkSpeed();

    @Deprecated
    public void setTexturePack(@NotNull String var1);

    @Deprecated
    public void setResourcePack(@NotNull String var1);

    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2);

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, @Nullable String var3);

    default public void setResourcePack(@NotNull String url, byte @Nullable [] hash, @Nullable Component prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, boolean var3);

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, @Nullable String var3, boolean var4);

    public void setResourcePack(@NotNull String var1, byte @Nullable [] var2, @Nullable Component var3, boolean var4);

    @NotNull
    public Scoreboard getScoreboard();

    public void setScoreboard(@NotNull Scoreboard var1) throws IllegalArgumentException, IllegalStateException;

    @Nullable
    public WorldBorder getWorldBorder();

    public void setWorldBorder(@Nullable WorldBorder var1);

    public boolean isHealthScaled();

    public void setHealthScaled(boolean var1);

    public void setHealthScale(double var1) throws IllegalArgumentException;

    public double getHealthScale();

    public void sendHealthUpdate(double var1, int var3, float var4);

    public void sendHealthUpdate();

    @Nullable
    public Entity getSpectatorTarget();

    public void setSpectatorTarget(@Nullable Entity var1);

    @Deprecated
    public void sendTitle(@Nullable String var1, @Nullable String var2);

    @Deprecated
    public void sendTitle(@Nullable String var1, @Nullable String var2, int var3, int var4, int var5);

    public void resetTitle();

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, @Nullable T var4);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, @Nullable T var9);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, @Nullable T var10);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, @Nullable T var15);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10, @Nullable T var12);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, @Nullable T var17);

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement var1);

    public int getClientViewDistance();

    @NotNull
    public Locale locale();

    public int getPing();

    @Deprecated
    @NotNull
    public String getLocale();

    public boolean getAffectsSpawning();

    public void setAffectsSpawning(boolean var1);

    public int getViewDistance();

    public void setViewDistance(int var1);

    public int getSimulationDistance();

    public void setSimulationDistance(int var1);

    @Deprecated
    public int getNoTickViewDistance();

    @Deprecated
    public void setNoTickViewDistance(int var1);

    public int getSendViewDistance();

    public void setSendViewDistance(int var1);

    public void updateCommands();

    public void openBook(@NotNull ItemStack var1);

    @Override
    public void openSign(@NotNull Sign var1);

    public void showDemoScreen();

    public boolean isAllowingServerListings();

    @Override
    @NotNull
    default public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)this.getType().getKey(), (UUID)this.getUniqueId(), (Component)this.displayName()))));
    }

    public void setResourcePack(@NotNull String var1, @NotNull String var2);

    public void setResourcePack(@NotNull String var1, @NotNull String var2, boolean var3);

    public void setResourcePack(@NotNull String var1, @NotNull String var2, boolean var3, @Nullable Component var4);

    @Nullable
    public PlayerResourcePackStatusEvent.Status getResourcePackStatus();

    @Deprecated
    @Nullable
    public String getResourcePackHash();

    public boolean hasResourcePack();

    @Override
    @NotNull
    public PlayerProfile getPlayerProfile();

    public void setPlayerProfile(@NotNull PlayerProfile var1);

    public float getCooldownPeriod();

    public float getCooledAttackStrength(float var1);

    public void resetCooldown();

    @NotNull
    public <T> T getClientOption(@NotNull ClientOption<T> var1);

    @Nullable
    public Firework boostElytra(@NotNull ItemStack var1);

    public void sendOpLevel(byte var1);

    @Nullable
    public String getClientBrandName();

    @Override
    @NotNull
    public Spigot spigot();

    public static class Spigot
    extends Entity.Spigot {
        @NotNull
        public InetSocketAddress getRawAddress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public boolean getCollidesWithEntities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void setCollidesWithEntities(boolean collides) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void respawn() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public Set<Player> getHiddenPlayers() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        @Deprecated
        public void sendMessage(@NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        @Deprecated
        public void sendMessage(BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @Nullable UUID sender, @NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @Nullable UUID sender, BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getPing() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

