/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedstoneWireTurbo {
    private final RedStoneWireBlock wire;
    private List<UpdateNode> updateQueue0 = Lists.newArrayList();
    private List<UpdateNode> updateQueue1 = Lists.newArrayList();
    private List<UpdateNode> updateQueue2 = Lists.newArrayList();
    private static final boolean[] update_redstone = new boolean[]{true, true, false, false, true, true, false, true, true, false, false, false, true, true, false, false, false, true, true, false, true, true, false, false};
    private static final int North = 0;
    private static final int East = 1;
    private static final int South = 2;
    private static final int West = 3;
    private static final int[] forward_is_north = new int[]{2, 3, 16, 19, 0, 4, 1, 5, 7, 8, 17, 20, 12, 13, 18, 21, 6, 9, 22, 14, 11, 10, 23, 15};
    private static final int[] forward_is_east = new int[]{2, 3, 16, 19, 4, 1, 5, 0, 17, 20, 12, 13, 18, 21, 7, 8, 22, 14, 11, 15, 23, 9, 6, 10};
    private static final int[] forward_is_south = new int[]{2, 3, 16, 19, 1, 5, 0, 4, 12, 13, 18, 21, 7, 8, 17, 20, 11, 15, 23, 10, 6, 14, 22, 9};
    private static final int[] forward_is_west = new int[]{2, 3, 16, 19, 5, 0, 4, 1, 18, 21, 7, 8, 17, 20, 12, 13, 23, 10, 6, 9, 22, 15, 11, 14};
    private static final int[][] reordering = new int[][]{forward_is_north, forward_is_east, forward_is_south, forward_is_west};
    private final Map<BlockPos, UpdateNode> nodeCache = Maps.newHashMap();
    private static final boolean old_current_change = false;
    private int currentWalkLayer = 0;
    private static final int[] rs_neighbors = new int[]{4, 5, 6, 7};
    private static final int[] rs_neighbors_up = new int[]{9, 11, 13, 15};
    private static final int[] rs_neighbors_dn = new int[]{8, 10, 12, 14};
    private static final Direction[] UPDATE_SHAPE_ORDER = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};

    public RedstoneWireTurbo(RedStoneWireBlock wire) {
        this.wire = wire;
    }

    public static BlockPos[] computeAllNeighbors(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        BlockPos[] n = new BlockPos[]{new BlockPos(x - 1, y, z), new BlockPos(x + 1, y, z), new BlockPos(x, y - 1, z), new BlockPos(x, y + 1, z), new BlockPos(x, y, z - 1), new BlockPos(x, y, z + 1), new BlockPos(x - 2, y, z), new BlockPos(x - 1, y - 1, z), new BlockPos(x - 1, y + 1, z), new BlockPos(x - 1, y, z - 1), new BlockPos(x - 1, y, z + 1), new BlockPos(x + 2, y, z), new BlockPos(x + 1, y - 1, z), new BlockPos(x + 1, y + 1, z), new BlockPos(x + 1, y, z - 1), new BlockPos(x + 1, y, z + 1), new BlockPos(x, y - 2, z), new BlockPos(x, y - 1, z - 1), new BlockPos(x, y - 1, z + 1), new BlockPos(x, y + 2, z), new BlockPos(x, y + 1, z - 1), new BlockPos(x, y + 1, z + 1), new BlockPos(x, y, z - 2), new BlockPos(x, y, z + 2)};
        return n;
    }

    private static void orientNeighbors(UpdateNode[] src, UpdateNode[] dst, int heading) {
        int[] re = reordering[heading];
        for (int i = 0; i < 24; ++i) {
            dst[i] = src[re[i]];
        }
    }

    private void identifyNode(Level worldIn, UpdateNode upd1) {
        BlockState oldState;
        BlockPos pos = upd1.self;
        upd1.currentState = oldState = worldIn.getBlockState(pos);
        net.minecraft.world.level.block.Block block = oldState.getBlock();
        if (block != this.wire) {
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        if (!this.wire.canSurvive(null, worldIn, pos)) {
            net.minecraft.world.level.block.Block.popResource(worldIn, pos, new ItemStack(Items.REDSTONE));
            worldIn.removeBlock(pos, false);
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        upd1.type = UpdateNode.Type.REDSTONE;
    }

    private static int computeHeading(int rx, int rz) {
        int code = rx + 1 + 3 * (rz + 1);
        switch (code) {
            case 0: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 0 : 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 0 : 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return ThreadLocalRandom.current().nextInt(0, 4);
            }
            case 5: {
                return 1;
            }
            case 6: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 2 : 3;
            }
            case 7: {
                return 2;
            }
            case 8: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 2 : 1;
            }
        }
        return ThreadLocalRandom.current().nextInt(0, 4);
    }

    private void updateNode(Level worldIn, UpdateNode upd1, int layer) {
        BlockPos pos = upd1.self;
        upd1.visited = true;
        BlockState oldState = upd1.currentState;
        BlockState newState = this.calculateCurrentChanges(worldIn, upd1);
        if (newState != oldState) {
            upd1.currentState = newState;
            this.propagateChanges(worldIn, upd1, layer);
        }
    }

    private void findNeighbors(Level worldIn, UpdateNode upd1) {
        int heading;
        BlockPos pos = upd1.self;
        BlockPos[] neighbors = RedstoneWireTurbo.computeAllNeighbors(pos);
        UpdateNode[] neighbor_nodes = new UpdateNode[24];
        upd1.neighbor_nodes = new UpdateNode[24];
        for (int i = 0; i < 24; ++i) {
            BlockPos pos2 = neighbors[i];
            UpdateNode upd2 = this.nodeCache.get(pos2);
            if (upd2 == null) {
                upd2 = new UpdateNode();
                upd2.self = pos2;
                upd2.parent = pos;
                this.nodeCache.put(pos2, upd2);
                this.identifyNode(worldIn, upd2);
            }
            if (!update_redstone[i] && upd2.type == UpdateNode.Type.REDSTONE) continue;
            neighbor_nodes[i] = upd2;
        }
        boolean fromWest = neighbor_nodes[0].visited || neighbor_nodes[7].visited || neighbor_nodes[8].visited;
        boolean fromEast = neighbor_nodes[1].visited || neighbor_nodes[12].visited || neighbor_nodes[13].visited;
        boolean fromNorth = neighbor_nodes[4].visited || neighbor_nodes[17].visited || neighbor_nodes[20].visited;
        boolean fromSouth = neighbor_nodes[5].visited || neighbor_nodes[18].visited || neighbor_nodes[21].visited;
        int cx = 0;
        int cz = 0;
        if (fromWest) {
            ++cx;
        }
        if (fromEast) {
            --cx;
        }
        if (fromNorth) {
            ++cz;
        }
        if (fromSouth) {
            --cz;
        }
        if (cx == 0 && cz == 0) {
            heading = RedstoneWireTurbo.computeHeading(upd1.xbias, upd1.zbias);
            for (int i = 0; i < 24; ++i) {
                UpdateNode nn = neighbor_nodes[i];
                if (nn == null) continue;
                nn.xbias = upd1.xbias;
                nn.zbias = upd1.zbias;
            }
        } else {
            if (cx != 0 && cz != 0) {
                if (upd1.xbias != 0) {
                    cz = 0;
                }
                if (upd1.zbias != 0) {
                    cx = 0;
                }
            }
            heading = RedstoneWireTurbo.computeHeading(cx, cz);
            for (int i = 0; i < 24; ++i) {
                UpdateNode nn = neighbor_nodes[i];
                if (nn == null) continue;
                nn.xbias = cx;
                nn.zbias = cz;
            }
        }
        RedstoneWireTurbo.orientNeighbors(neighbor_nodes, upd1.neighbor_nodes, heading);
    }

    private void propagateChanges(Level worldIn, UpdateNode upd1, int layer) {
        if (upd1.neighbor_nodes == null) {
            this.findNeighbors(worldIn, upd1);
        }
        BlockPos pos = upd1.self;
        int layer1 = layer + 1;
        for (int i = 0; i < 24; ++i) {
            UpdateNode upd2 = upd1.neighbor_nodes[i];
            if (upd2 == null || layer1 <= upd2.layer) continue;
            upd2.layer = layer1;
            this.updateQueue1.add(upd2);
            upd2.parent = pos;
        }
        int layer2 = layer + 2;
        for (int i = 0; i < 4; ++i) {
            UpdateNode upd2 = upd1.neighbor_nodes[i];
            if (upd2 == null || layer2 <= upd2.layer) continue;
            upd2.layer = layer2;
            this.updateQueue2.add(upd2);
            upd2.parent = pos;
        }
    }

    private void shiftQueue() {
        List<UpdateNode> t = this.updateQueue0;
        t.clear();
        this.updateQueue0 = this.updateQueue1;
        this.updateQueue1 = this.updateQueue2;
        this.updateQueue2 = t;
    }

    private void breadthFirstWalk(Level worldIn) {
        this.shiftQueue();
        this.currentWalkLayer = 1;
        while (this.updateQueue0.size() > 0 || this.updateQueue1.size() > 0) {
            List<UpdateNode> thisLayer = this.updateQueue0;
            for (UpdateNode upd : thisLayer) {
                if (upd.type == UpdateNode.Type.REDSTONE) {
                    this.updateNode(worldIn, upd, this.currentWalkLayer);
                    continue;
                }
                worldIn.getBlockState(upd.self).handleNeighborChanged(worldIn, upd.self, this.wire, null, false);
            }
            this.shiftQueue();
            ++this.currentWalkLayer;
        }
        this.currentWalkLayer = 0;
    }

    private BlockState scheduleReentrantNeighborChanged(Level worldIn, BlockPos pos, BlockState newState, BlockPos source) {
        UpdateNode upd;
        UpdateNode src;
        if (source != null && (src = this.nodeCache.get(source)) == null) {
            src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.identifyNode(worldIn, src);
            this.nodeCache.put(source, src);
        }
        if ((upd = this.nodeCache.get(pos)) == null) {
            upd = new UpdateNode();
            upd.self = pos;
            upd.parent = pos;
            upd.visited = true;
            this.identifyNode(worldIn, upd);
            this.nodeCache.put(pos, upd);
        }
        upd.currentState = newState;
        if (upd.neighbor_nodes != null) {
            for (int i = 0; i < 24; ++i) {
                UpdateNode upd2 = upd.neighbor_nodes[i];
                if (upd2 == null) continue;
                upd2.type = UpdateNode.Type.UNKNOWN;
                upd2.currentState = null;
                this.identifyNode(worldIn, upd2);
            }
        }
        this.propagateChanges(worldIn, upd, this.currentWalkLayer);
        return newState;
    }

    public BlockState updateSurroundingRedstone(Level worldIn, BlockPos pos, BlockState state, BlockPos source) {
        BlockState newState = this.wire.calculateCurrentChanges(worldIn, pos, state);
        if (newState == state) {
            return state;
        }
        if (this.currentWalkLayer > 0 || this.nodeCache.size() > 0) {
            return this.scheduleReentrantNeighborChanged(worldIn, pos, newState, source);
        }
        if (source != null) {
            UpdateNode src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.nodeCache.put(source, src);
            this.identifyNode(worldIn, src);
        }
        UpdateNode upd = new UpdateNode();
        upd.self = pos;
        upd.parent = source != null ? source : pos;
        upd.currentState = newState;
        upd.type = UpdateNode.Type.REDSTONE;
        upd.visited = true;
        this.nodeCache.put(pos, upd);
        this.propagateChanges(worldIn, upd, 0);
        this.breadthFirstWalk(worldIn);
        this.nodeCache.clear();
        return newState;
    }

    private BlockState calculateCurrentChanges(Level worldIn, UpdateNode upd) {
        BlockPos pos;
        BlockState state = upd.currentState;
        int i = state.getValue(RedStoneWireBlock.POWER);
        int j = 0;
        j = RedstoneWireTurbo.getMaxCurrentStrength(upd, j);
        int l = 0;
        this.wire.shouldSignal = false;
        int k = worldIn.getBestNeighborSignal(upd.self);
        this.wire.shouldSignal = true;
        if (k < 15) {
            if (upd.neighbor_nodes == null) {
                this.findNeighbors(worldIn, upd);
            }
            UpdateNode center_up = upd.neighbor_nodes[1];
            boolean center_up_is_cube = center_up.currentState.isRedstoneConductor(worldIn, center_up.self);
            for (int m = 0; m < 4; ++m) {
                int n = rs_neighbors[m];
                UpdateNode neighbor = upd.neighbor_nodes[n];
                l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor, l);
                boolean neighbor_is_cube = neighbor.currentState.isRedstoneConductor(worldIn, neighbor.self);
                if (!neighbor_is_cube) {
                    UpdateNode neighbor_down = upd.neighbor_nodes[rs_neighbors_dn[m]];
                    l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_down, l);
                    continue;
                }
                if (center_up_is_cube) continue;
                UpdateNode neighbor_up = upd.neighbor_nodes[rs_neighbors_up[m]];
                l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_up, l);
            }
        }
        if (k > (j = l - 1)) {
            j = k;
        }
        if (i != j) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(worldIn, upd.self), i, j);
            worldIn.getCraftServer().getPluginManager().callEvent((Event)event);
            j = event.getNewCurrent();
        }
        if (i != j && this.wire.canSurvive(null, worldIn, pos = new BlockPos(upd.self.getX(), upd.self.getY(), upd.self.getZ())) && worldIn.setBlock(upd.self, state = (BlockState)state.setValue(RedStoneWireBlock.POWER, j), 18)) {
            this.updateNeighborShapes(worldIn, upd.self, state);
        }
        return state;
    }

    public void updateNeighborShapes(Level level, BlockPos pos, BlockState state) {
        state.updateIndirectNeighbourShapes(level, pos, 18);
        for (Direction dir : UPDATE_SHAPE_ORDER) {
            BlockPos neighborPos = pos.relative(dir);
            BlockState neighborState = level.getBlockState(neighborPos);
            BlockState newState = neighborState.updateShape(level, level, neighborPos, dir.getOpposite(), pos, state, level.getRandom());
            net.minecraft.world.level.block.Block.updateOrDestroy(neighborState, newState, level, neighborPos, 2);
        }
    }

    private static int getMaxCurrentStrength(UpdateNode upd, int strength) {
        if (upd.type != UpdateNode.Type.REDSTONE) {
            return strength;
        }
        int i = upd.currentState.getValue(RedStoneWireBlock.POWER);
        return i > strength ? i : strength;
    }

    private static class UpdateNode {
        BlockState currentState;
        UpdateNode[] neighbor_nodes;
        BlockPos self;
        BlockPos parent;
        Type type = Type.UNKNOWN;
        int layer;
        boolean visited;
        int xbias;
        int zbias;

        private UpdateNode() {
        }

        public static enum Type {
            UNKNOWN,
            REDSTONE,
            OTHER;

        }
    }
}

