/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish.sentry;

import gg.pufferfish.pufferfish.PufferfishConfig;
import gg.pufferfish.pufferfish.sentry.PufferfishSentryAppender;
import io.sentry.Sentry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

public class SentryManager {
    private static final Logger logger = LogManager.getLogger(SentryManager.class);
    private static boolean initialized = false;

    private SentryManager() {
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            initialized = true;
            Sentry.init(options -> {
                options.setDsn(PufferfishConfig.sentryDsn);
                options.setMaxBreadcrumbs(100);
            });
            PufferfishSentryAppender appender = new PufferfishSentryAppender();
            appender.start();
            ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addAppender((Appender)appender);
            logger.info("Sentry logging started!");
        }
        catch (Exception e) {
            logger.warn("Failed to initialize sentry!", (Throwable)e);
            initialized = false;
        }
    }
}

