/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.function.Supplier;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;

public final class WrapperAwareSerializer
implements ComponentSerializer<net.kyori.adventure.text.Component, net.kyori.adventure.text.Component, Component> {
    private final Supplier<RegistryOps<Object>> javaOps = Suppliers.memoize(javaOps::get);

    public WrapperAwareSerializer(Supplier<RegistryOps<Object>> javaOps) {
    }

    public net.kyori.adventure.text.Component deserialize(Component input) {
        if (input instanceof AdventureComponent) {
            return ((AdventureComponent)input).adventure;
        }
        RegistryOps<Object> ops = this.javaOps.get();
        Object obj = ComponentSerialization.CODEC.encodeStart(ops, (Object)input).getOrThrow(s -> new RuntimeException("Failed to encode Minecraft Component: " + String.valueOf(input) + "; " + s));
        Pair converted = (Pair)AdventureCodecs.COMPONENT_CODEC.decode(ops, obj).getOrThrow(s -> new RuntimeException("Failed to decode to adventure Component: " + String.valueOf(obj) + "; " + s));
        return (net.kyori.adventure.text.Component)converted.getFirst();
    }

    public Component serialize(net.kyori.adventure.text.Component component) {
        RegistryOps<Object> ops = this.javaOps.get();
        Object obj = AdventureCodecs.COMPONENT_CODEC.encodeStart(ops, (Object)component).getOrThrow(s -> new RuntimeException("Failed to encode adventure Component: " + String.valueOf(component) + "; " + s));
        Pair converted = (Pair)ComponentSerialization.CODEC.decode(ops, obj).getOrThrow(s -> new RuntimeException("Failed to decode to Minecraft Component: " + String.valueOf(obj) + "; " + s));
        return (Component)converted.getFirst();
    }
}

