/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure.providers;

import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConverterRegistry;
import net.kyori.adventure.text.serializer.gson.GsonDataComponentValue;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import org.bukkit.craftbukkit.CraftRegistry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class DataComponentValueConverterProviderImpl
implements DataComponentValueConverterRegistry.Provider {
    static final Key ID = Key.key((String)"adventure", (String)"platform/paper");

    public Key id() {
        return ID;
    }

    private static <T> RegistryOps<T> createOps(DynamicOps<T> delegate) {
        return CraftRegistry.getMinecraftRegistry().createSerializationContext(delegate);
    }

    public Iterable<DataComponentValueConverterRegistry.Conversion<?, ?>> conversions() {
        return List.of(DataComponentValueConverterRegistry.Conversion.convert(PaperAdventure.DataComponentValueImpl.class, GsonDataComponentValue.class, (key, dataComponentValue) -> GsonDataComponentValue.gsonDataComponentValue((JsonElement)((JsonElement)dataComponentValue.codec().encodeStart(DataComponentValueConverterProviderImpl.createOps(JsonOps.INSTANCE), dataComponentValue.value()).getOrThrow()))), DataComponentValueConverterRegistry.Conversion.convert(GsonDataComponentValue.class, PaperAdventure.DataComponentValueImpl.class, (key, dataComponentValue) -> {
            @Nullable DataComponentType<?> type = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(PaperAdventure.asVanilla(key));
            if (type == null) {
                throw new IllegalArgumentException("Unknown data component type: " + String.valueOf(key));
            }
            return new PaperAdventure.DataComponentValueImpl<Object>(type.codecOrThrow(), type.codecOrThrow().parse(DataComponentValueConverterProviderImpl.createOps(JsonOps.INSTANCE), (Object)dataComponentValue.element()).getOrThrow(IllegalArgumentException::new));
        }), DataComponentValueConverterRegistry.Conversion.convert(PaperAdventure.DataComponentValueImpl.class, DataComponentValue.TagSerializable.class, (key, dataComponentValue) -> BinaryTagHolder.encode((Object)((Tag)dataComponentValue.codec().encodeStart(DataComponentValueConverterProviderImpl.createOps(NbtOps.INSTANCE), dataComponentValue.value()).getOrThrow()), PaperAdventure.NBT_CODEC)), DataComponentValueConverterRegistry.Conversion.convert(DataComponentValue.TagSerializable.class, PaperAdventure.DataComponentValueImpl.class, (key, tagSerializable) -> {
            @Nullable DataComponentType<?> type = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(PaperAdventure.asVanilla(key));
            if (type == null) {
                throw new IllegalArgumentException("Unknown data component type: " + String.valueOf(key));
            }
            try {
                return new PaperAdventure.DataComponentValueImpl<Object>(type.codecOrThrow(), type.codecOrThrow().parse(DataComponentValueConverterProviderImpl.createOps(NbtOps.INSTANCE), (Object)((Tag)tagSerializable.asBinaryTag().get(PaperAdventure.NBT_CODEC))).getOrThrow(IllegalArgumentException::new));
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }
}

