/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class CommandUtil {
    private CommandUtil() {
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] args, String ... matches) {
        return CommandUtil.getListMatchingLast(sender, args, Arrays.asList(matches));
    }

    public static boolean matches(String s, String s1) {
        return s1.regionMatches(true, 0, s, 0, s.length());
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] strings, Collection<?> collection) {
        String last = strings[strings.length - 1];
        ArrayList results = Lists.newArrayList();
        if (!collection.isEmpty()) {
            for (String s1 : Iterables.transform(collection, (Function)Functions.toStringFunction())) {
                if (!CommandUtil.matches(last, s1) || !sender.hasPermission("bukkit.command.paper." + s1) && !sender.hasPermission("bukkit.command.paper")) continue;
                results.add(s1);
            }
            if (results.isEmpty()) {
                for (Object object : collection) {
                    if (!(object instanceof ResourceLocation) || !CommandUtil.matches(last, ((ResourceLocation)object).getPath())) continue;
                    results.add(String.valueOf(object));
                }
            }
        }
        return results;
    }
}

