/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.constraint;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.meta.Constraint;
import org.spongepowered.configurate.serialize.SerializationException;

public final class Constraints {
    private Constraints() {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Min {
        public int value();

        public static final class Factory
        implements Constraint.Factory<Min, Number> {
            public Constraint<Number> make(Min data, Type type) {
                return value -> {
                    if (value != null && value.intValue() < data.value()) {
                        throw new SerializationException(String.valueOf(value) + " is less than the min " + data.value());
                    }
                };
            }
        }
    }

    public static final class Positive
    implements Constraint<Number> {
        public void validate(@Nullable Number value) throws SerializationException {
            if (value != null && value.doubleValue() <= 0.0) {
                throw new SerializationException(String.valueOf(value) + " should be positive");
            }
        }
    }
}

