/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.mojang.serialization.Lifecycle;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.event.WritableRegistry;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.jspecify.annotations.Nullable;

public class WritableCraftRegistry<M, T extends Keyed, B extends PaperRegistryBuilder<M, T>>
extends CraftRegistry<T, M> {
    private static final RegistrationInfo FROM_PLUGIN = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private final RegistryEntry.BuilderHolder<M, T, B> entry;
    private final MappedRegistry<M> registry;
    private final PaperRegistryBuilder.Factory<M, T, ? extends B> builderFactory;
    private final BiFunction<? super NamespacedKey, M, T> minecraftToBukkit;

    public WritableCraftRegistry(RegistryEntry.BuilderHolder<M, T, B> entry, Class<?> classToPreload, MappedRegistry<M> registry, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater, PaperRegistryBuilder.Factory<M, T, ? extends B> builderFactory, BiFunction<? super NamespacedKey, M, T> minecraftToBukkit) {
        super(classToPreload, registry, null, serializationUpdater);
        this.entry = entry;
        this.registry = registry;
        this.builderFactory = builderFactory;
        this.minecraftToBukkit = minecraftToBukkit;
    }

    public void register(TypedKey<T> key, Consumer<? super B> value, Conversions conversions) {
        ResourceKey<M> resourceKey = ResourceKey.create(this.registry.key(), PaperAdventure.asVanilla(key.key()));
        this.registry.validateWrite(resourceKey);
        B builder = this.newBuilder(conversions, key);
        value.accept(builder);
        PaperRegistryListenerManager.INSTANCE.registerWithListeners(this.registry, RegistryEntry.Modifiable.asModifiable(this.entry), resourceKey, builder, FROM_PLUGIN, conversions);
    }

    @Override
    public final @Nullable T createBukkit(NamespacedKey namespacedKey, @Nullable M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return this.minecraftToBukkit(namespacedKey, minecraft);
    }

    public WritableRegistry<T, B> createApiWritableRegistry(Conversions conversions) {
        return new ApiWritableRegistry(conversions);
    }

    public T minecraftToBukkit(NamespacedKey namespacedKey, M minecraft) {
        return (T)((Keyed)this.minecraftToBukkit.apply((NamespacedKey)namespacedKey, minecraft));
    }

    protected B newBuilder(Conversions conversions, TypedKey<T> key) {
        return this.builderFactory.create(conversions, key);
    }

    public class ApiWritableRegistry
    implements WritableRegistry<T, B> {
        private final Conversions conversions;

        public ApiWritableRegistry(Conversions conversions) {
            this.conversions = conversions;
        }

        public void register(TypedKey<T> key, Consumer<? super B> value) {
            WritableCraftRegistry.this.register(key, value, this.conversions);
        }
    }
}

