/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.util.ServerWorkerThread;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.TracingExecutor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class Util {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final int DEFAULT_SAFE_FILE_OPERATION_RETRIES = 10;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final TracingExecutor BACKGROUND_EXECUTOR = Util.makeExecutor("Main", -1);
    private static final TracingExecutor IO_POOL = Util.makeIoExecutor("IO-Worker-", false);
    public static final TracingExecutor DIMENSION_DATA_IO_POOL = Util.makeExtraIoExecutor("Dimension-Data-IO-Worker-");
    private static final TracingExecutor DOWNLOAD_POOL = Util.makeIoExecutor("Download-", true);
    public static final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable run) {
            Thread ret = new Thread(run);
            ret.setName("Profile Lookup Executor #" + this.count.getAndIncrement());
            ret.setUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable));
            return ret;
        }
    });
    private static final DateTimeFormatter FILENAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int LINEAR_LOOKUP_THRESHOLD = 8;
    private static final Set<String> ALLOWED_UNTRUSTED_LINK_PROTOCOLS = Set.of("http", "https");
    public static final long NANOS_PER_MILLI = 1000000L;
    public static TimeSource.NanoTimeSource timeSource = System::nanoTime;
    public static final Ticker TICKER = new Ticker(){

        public long read() {
            return timeSource.getAsLong();
        }
    };
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    public static final double COLLISION_EPSILON = 1.0E-7;
    private static Consumer<String> thePauser = message -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String getPropertyName(Property<T> property, Object value) {
        return property.getName((Comparable)value);
    }

    public static String makeDescriptionId(String type, @Nullable ResourceLocation id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.getNamespace() + "." + id.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return Util.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return System.nanoTime();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    public static String getFilenameFormattedDateTime() {
        return FILENAME_DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    private static TracingExecutor makeExecutor(String s, int priorityModifier) {
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        int i = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : (cpus <= 8 ? Math.max(3, cpus - 2) : cpus * 2 / 3);
        i = Math.min(8, i);
        i = Integer.getInteger("Paper.WorkerThreadCount", i);
        Object executorService = i <= 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(i, target -> new ServerWorkerThread(target, s, priorityModifier));
        return new TracingExecutor((ExecutorService)executorService);
    }

    private static int getMaxThreads() {
        String string = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if (string != null) {
            try {
                int i = Integer.parseInt(string);
                if (i >= 1 && i <= 255) {
                    return i;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, string, 255});
            }
            catch (NumberFormatException var2) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, string, 255});
            }
        }
        return 255;
    }

    public static TracingExecutor backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static TracingExecutor ioPool() {
        return IO_POOL;
    }

    public static TracingExecutor nonCriticalIoPool() {
        return DOWNLOAD_POOL;
    }

    public static void shutdownExecutors() {
        BACKGROUND_EXECUTOR.shutdownAndAwait(3L, TimeUnit.SECONDS);
        IO_POOL.shutdownAndAwait(3L, TimeUnit.SECONDS);
    }

    private static TracingExecutor makeIoExecutor(String namePrefix, boolean daemon) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(daemon);
            thread.setUncaughtExceptionHandler(Util::onThreadException);
            return thread;
        }));
    }

    private static TracingExecutor makeExtraIoExecutor(String namePrefix) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(false);
            thread.setUncaughtExceptionHandler(Util::onThreadException);
            return thread;
        }));
    }

    public static void throwAsRuntime(Throwable t) {
        throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    public static void onThreadException(Thread thread, Throwable t) {
        Util.pauseInIde(t);
        if (t instanceof CompletionException) {
            t = t.getCause();
        }
        if (t instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)t;
            Bootstrap.realStdoutPrintln(reportedException.getReport().getFriendlyReport(ReportType.CRASH));
            System.exit(-1);
        }
        LOGGER.error(String.format(Locale.ROOT, "Caught exception in thread %s", thread), t);
    }

    @Nullable
    public static Type<?> fetchChoiceType(DSL.TypeReference typeReference, String id) {
        return !SharedConstants.CHECK_DATA_FIXER_SCHEMA ? null : Util.doFetchChoiceType(typeReference, id);
    }

    @Nullable
    private static Type<?> doFetchChoiceType(DSL.TypeReference typeReference, String id) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion())).getChoiceType(typeReference, id);
            }
            catch (IllegalArgumentException var4) {
                LOGGER.error("No data fixer registered for {}", (Object)id);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw var4;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runNamed(Runnable runnable, String name) {
        block16: {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                Thread thread = Thread.currentThread();
                String string = thread.getName();
                thread.setName(name);
                try (Zone zone = TracyClient.beginZone((String)name, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                    runnable.run();
                    break block16;
                }
                finally {
                    thread.setName(string);
                }
            }
            try (Zone zone2 = TracyClient.beginZone((String)name, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                runnable.run();
            }
        }
    }

    public static <T> String getRegisteredName(Registry<T> registry, T value) {
        ResourceLocation resourceLocation = registry.getKey(value);
        return resourceLocation == null ? "[unregistered]" : resourceLocation.toString();
    }

    public static <T> Predicate<T> allOf() {
        return o -> true;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> a) {
        return a;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> a, Predicate<? super T> b) {
        return o -> a.test(o) && b.test(o);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c) {
        return o -> a.test(o) && b.test(o) && c.test(o);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c, Predicate<? super T> d) {
        return o -> a.test(o) && b.test(o) && c.test(o) && d.test(o);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c, Predicate<? super T> d, Predicate<? super T> e) {
        return o -> a.test(o) && b.test(o) && c.test(o) && d.test(o) && e.test(o);
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<? super T> ... predicates) {
        return o -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(o)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> allOf(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> Util.allOf();
            case 1 -> Util.allOf(predicates.get(0));
            case 2 -> Util.allOf(predicates.get(0), predicates.get(1));
            case 3 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates2 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield Util.allOf(predicates2);
            }
        };
    }

    public static <T> Predicate<T> anyOf() {
        return o -> false;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> a) {
        return a;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> a, Predicate<? super T> b) {
        return o -> a.test(o) || b.test(o);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c) {
        return o -> a.test(o) || b.test(o) || c.test(o);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c, Predicate<? super T> d) {
        return o -> a.test(o) || b.test(o) || c.test(o) || d.test(o);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> a, Predicate<? super T> b, Predicate<? super T> c, Predicate<? super T> d, Predicate<? super T> e) {
        return o -> a.test(o) || b.test(o) || c.test(o) || d.test(o) || e.test(o);
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<? super T> ... predicates) {
        return o -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(o)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> anyOf(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> Util.anyOf();
            case 1 -> Util.anyOf(predicates.get(0));
            case 2 -> Util.anyOf(predicates.get(0), predicates.get(1));
            case 3 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates2 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield Util.anyOf(predicates2);
            }
        };
    }

    public static <T> boolean isSymmetrical(int width, int height, List<T> list) {
        if (width == 1) {
            return true;
        }
        int i = width / 2;
        for (int j = 0; j < height; ++j) {
            for (int k = 0; k < i; ++k) {
                T object2;
                int l = width - 1 - k;
                T object = list.get(k + j * width);
                if (object.equals(object2 = list.get(l + j * width))) continue;
                return false;
            }
        }
        return true;
    }

    public static OS getPlatform() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.WINDOWS;
        }
        if (string.contains("mac")) {
            return OS.OSX;
        }
        if (string.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (string.contains("linux")) {
            return OS.LINUX;
        }
        return string.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static URI parseAndValidateUntrustedUri(String uri) throws URISyntaxException {
        URI uRI = new URI(uri);
        String string = uRI.getScheme();
        if (string == null) {
            throw new URISyntaxException(uri, "Missing protocol in URI: " + uri);
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        if (!ALLOWED_UNTRUSTED_LINK_PROTOCOLS.contains(string2)) {
            throw new URISyntaxException(uri, "Unsupported protocol in URI: " + uri);
        }
        return uRI;
    }

    public static Stream<String> getVmArguments() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(runtimeArg -> runtimeArg.startsWith("-X"));
    }

    public static <T> T lastOf(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T findNextInIterable(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = iterator.next();
        if (object != null) {
            T object3 = object2;
            while (object3 != object) {
                if (!iterator.hasNext()) continue;
                object3 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return object2;
    }

    public static <T> T findPreviousInIterable(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = null;
        while (iterator.hasNext()) {
            T object3 = iterator.next();
            if (object3 == object) {
                if (object2 != null) break;
                object2 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : object);
                break;
            }
            object2 = object3;
        }
        return object2;
    }

    public static <T> T make(Supplier<T> factory) {
        return factory.get();
    }

    public static <T> T make(T object, Consumer<? super T> initializer) {
        initializer.accept(object);
        return object;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> makeEnumMap(Class<K> enumClass, Function<K, V> mapper) {
        EnumMap<Enum, V> enumMap = new EnumMap<Enum, V>(enumClass);
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            enumMap.put(enum_, mapper.apply(enum_));
        }
        return enumMap;
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(void_ -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return Util.fallibleSequence(futures, completableFuture::completeExceptionally).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFastAndCancel(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return Util.fallibleSequence(futures, throwable -> {
            if (completableFuture.completeExceptionally((Throwable)throwable)) {
                for (CompletableFuture completableFuture2 : futures) {
                    completableFuture2.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    private static <V> CompletableFuture<List<V>> fallibleSequence(List<? extends CompletableFuture<? extends V>> futures, Consumer<Throwable> exceptionHandler) {
        ArrayList list = Lists.newArrayListWithCapacity((int)futures.size());
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        futures.forEach(future -> {
            int i = list.size();
            list.add(null);
            completableFutures[i] = future.whenComplete((value, throwable) -> {
                if (throwable != null) {
                    exceptionHandler.accept((Throwable)throwable);
                } else {
                    list.set(i, value);
                }
            });
        });
        return CompletableFuture.allOf(completableFutures).thenApply(void_ -> list);
    }

    public static <T> Optional<T> ifElse(Optional<T> optional, Consumer<T> presentAction, Runnable elseAction) {
        if (optional.isPresent()) {
            presentAction.accept(optional.get());
        } else {
            elseAction.run();
        }
        return optional;
    }

    public static <T> Supplier<T> name(Supplier<T> supplier, Supplier<String> messageSupplier) {
        return supplier;
    }

    public static Runnable name(Runnable runnable, Supplier<String> messageSupplier) {
        return runnable;
    }

    public static void logAndPauseIfInIde(String message) {
        LOGGER.error(message);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(message);
        }
    }

    public static void logAndPauseIfInIde(String message, Throwable throwable) {
        LOGGER.error(message, throwable);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(message);
        }
    }

    public static <T extends Throwable> T pauseInIde(T t) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", t);
            Util.doPause(t.getMessage());
        }
        return t;
    }

    public static void setPause(Consumer<String> missingBreakpointHandler) {
        thePauser = missingBreakpointHandler;
    }

    private static void doPause(String message) {
        boolean bl;
        Instant instant = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl2 = bl = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!bl) {
            thePauser.accept(message);
        }
    }

    public static String describeError(Throwable t) {
        if (t.getCause() != null) {
            return Util.describeError(t.getCause());
        }
        return t.getMessage() != null ? t.getMessage() : t.toString();
    }

    public static <T> T getRandom(T[] array, RandomSource random) {
        return array[random.nextInt(array.length)];
    }

    public static int getRandom(int[] array, RandomSource random) {
        return array[random.nextInt(array.length)];
    }

    public static <T> T getRandom(List<T> list, RandomSource random) {
        return list.get(random.nextInt(list.size()));
    }

    public static <T> Optional<T> getRandomSafe(List<T> list, RandomSource random) {
        return list.isEmpty() ? Optional.empty() : Optional.of(Util.getRandom(list, random));
    }

    private static BooleanSupplier createRenamer(final Path src, final Path dest) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(src, dest, new CopyOption[0]);
                    return true;
                }
                catch (IOException var2) {
                    LOGGER.error("Failed to rename", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "rename " + String.valueOf(src) + " to " + String.valueOf(dest);
            }
        };
    }

    private static BooleanSupplier createDeleter(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(path);
                    return true;
                }
                catch (IOException var2) {
                    LOGGER.warn("Failed to delete", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + String.valueOf(path);
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(path) + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(path) + " is present";
            }
        };
    }

    private static boolean executeInSequence(BooleanSupplier ... tasks) {
        for (BooleanSupplier booleanSupplier : tasks) {
            if (booleanSupplier.getAsBoolean()) continue;
            LOGGER.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean runWithRetries(int retries, String taskName, BooleanSupplier ... tasks) {
        for (int i = 0; i < retries; ++i) {
            if (Util.executeInSequence(tasks)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", new Object[]{taskName, i, retries});
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)taskName);
        return false;
    }

    public static void safeReplaceFile(Path current, Path newPath, Path backup) {
        Util.safeReplaceOrMoveFile(current, newPath, backup, false);
    }

    public static boolean safeReplaceOrMoveFile(Path current, Path newPath, Path backup, boolean noRestoreOnFail) {
        if (Files.exists(current, new LinkOption[0]) && !Util.runWithRetries(10, "create backup " + String.valueOf(backup), Util.createDeleter(backup), Util.createRenamer(current, backup), Util.createFileCreatedCheck(backup))) {
            return false;
        }
        if (!Util.runWithRetries(10, "remove old " + String.valueOf(current), Util.createDeleter(current), Util.createFileDeletedCheck(current))) {
            return false;
        }
        if (!Util.runWithRetries(10, "replace " + String.valueOf(current) + " with " + String.valueOf(newPath), Util.createRenamer(newPath, current), Util.createFileCreatedCheck(current)) && !noRestoreOnFail) {
            Util.runWithRetries(10, "restore " + String.valueOf(current) + " from " + String.valueOf(backup), Util.createRenamer(backup, current), Util.createFileCreatedCheck(current));
            return false;
        }
        return true;
    }

    public static int offsetByCodepoints(String string, int cursor, int delta) {
        int i = string.length();
        if (delta >= 0) {
            for (int j = 0; cursor < i && j < delta; ++j) {
                if (!Character.isHighSurrogate(string.charAt(cursor++)) || cursor >= i || !Character.isLowSurrogate(string.charAt(cursor))) continue;
                ++cursor;
            }
        } else {
            for (int k = delta; cursor > 0 && k < 0; ++k) {
                if (!Character.isLowSurrogate(string.charAt(--cursor)) || cursor <= 0 || !Character.isHighSurrogate(string.charAt(cursor - 1))) continue;
                --cursor;
            }
        }
        return cursor;
    }

    public static Consumer<String> prefix(String prefix, Consumer<String> consumer) {
        return string -> consumer.accept(prefix + string);
    }

    public static DataResult<int[]> fixedSize(IntStream stream, int length) {
        int[] is = stream.limit(length + 1).toArray();
        if (is.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " ints";
            return is.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(is, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)is);
    }

    public static DataResult<long[]> fixedSize(LongStream stream, int length) {
        long[] ls = stream.limit(length + 1).toArray();
        if (ls.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " longs";
            return ls.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(ls, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)ls);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> list, int length) {
        if (list.size() != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " elements";
            return list.size() >= length ? DataResult.error(supplier, list.subList(0, length)) : DataResult.error(supplier);
        }
        return DataResult.success(list);
    }

    public static void startTimerHackThread() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var2) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    public static void copyBetweenDirs(Path src, Path dest, Path toCopy) throws IOException {
        Path path = src.relativize(toCopy);
        Path path2 = dest.resolve(path);
        Files.copy(toCopy, path2, new CopyOption[0]);
    }

    public static String sanitizeName(String string, CharPredicate predicate) {
        return string.toLowerCase(Locale.ROOT).chars().mapToObj(charCode -> predicate.test((char)charCode) ? Character.toString((char)charCode) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> singleKeyCache(Function<K, V> mapper) {
        return new SingleKeyCache<K, V>(mapper);
    }

    public static <T, R> Function<T, R> memoize(final Function<T, R> function) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object) {
                return this.cache.computeIfAbsent(object, function);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(function) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(final BiFunction<T, U, R> biFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object, U object2) {
                return this.cache.computeIfAbsent(Pair.of(object, object2), pair -> biFunction.apply(pair.getFirst(), pair.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(biFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> toShuffledList(Stream<T> stream, RandomSource random) {
        ObjectArrayList objectArrayList = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static IntArrayList toShuffledList(IntStream stream, RandomSource random) {
        int i;
        IntArrayList intArrayList = IntArrayList.wrap((int[])stream.toArray());
        for (int j = i = intArrayList.size(); j > 1; --j) {
            int k = random.nextInt(j);
            intArrayList.set(j - 1, intArrayList.set(k, intArrayList.getInt(j - 1)));
        }
        return intArrayList;
    }

    public static <T> List<T> shuffledCopy(T[] array, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList((Object[])array);
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> List<T> shuffledCopy(ObjectArrayList<T> list, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList(list);
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> void shuffle(List<T> list, RandomSource random) {
        int i;
        for (int j = i = list.size(); j > 1; --j) {
            int k = random.nextInt(j);
            list.set(j - 1, list.set(k, list.get(j - 1)));
        }
    }

    public static <T> CompletableFuture<T> blockUntilDone(Function<Executor, CompletableFuture<T>> resultFactory) {
        return Util.blockUntilDone(resultFactory, CompletableFuture::isDone);
    }

    public static <T> T blockUntilDone(Function<Executor, T> resultFactory, Predicate<T> donePredicate) {
        int i;
        LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        T object = resultFactory.apply(blockingQueue::add);
        while (!donePredicate.test(object)) {
            try {
                Runnable runnable = (Runnable)blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException var5) {
                LOGGER.warn("Interrupted wait");
                break;
            }
        }
        if ((i = blockingQueue.size()) > 0) {
            LOGGER.warn("Tasks left in queue: {}", (Object)i);
        }
        return object;
    }

    public static <T> ToIntFunction<T> createIndexLookup(List<T> values) {
        int i = values.size();
        if (i < 8) {
            return values::indexOf;
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap(i);
        object2IntMap.defaultReturnValue(-1);
        for (int j = 0; j < i; ++j) {
            object2IntMap.put(values.get(j), j);
        }
        return object2IntMap;
    }

    public static <T> ToIntFunction<T> createIndexIdentityLookup(List<T> values) {
        int i = values.size();
        if (i < 8) {
            ReferenceImmutableList referenceList = new ReferenceImmutableList(values);
            return arg_0 -> ((ReferenceList)referenceList).indexOf(arg_0);
        }
        Reference2IntOpenHashMap reference2IntMap = new Reference2IntOpenHashMap(i);
        reference2IntMap.defaultReturnValue(-1);
        for (int j = 0; j < i; ++j) {
            reference2IntMap.put(values.get(j), j);
        }
        return reference2IntMap;
    }

    public static <A, B> Typed<B> writeAndReadTypedOrThrow(Typed<A> typed, Type<B> type, UnaryOperator<Dynamic<?>> modifier) {
        Dynamic dynamic = (Dynamic)((Object)typed.write().getOrThrow());
        return Util.readTypedOrThrow(type, (Dynamic)((Object)modifier.apply(dynamic)), true);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> type, Dynamic<?> value) {
        return Util.readTypedOrThrow(type, value, false);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> type, Dynamic<?> value, boolean allowPartial) {
        DataResult dataResult = type.readTyped(value).map(Pair::getFirst);
        try {
            return allowPartial ? (Typed)dataResult.getPartialOrThrow(IllegalStateException::new) : (Typed)dataResult.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException var7) {
            CrashReport crashReport = CrashReport.forThrowable(var7, "Reading type");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Info");
            crashReportCategory.setDetail("Data", value);
            crashReportCategory.setDetail("Type", type);
            throw new ReportedException(crashReport);
        }
    }

    public static <T> List<T> copyAndAdd(List<T> list, T valueToAppend) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).addAll(list).add(valueToAppend).build();
    }

    public static <T> List<T> copyAndAdd(T valueToPrepend, List<T> list) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).add(valueToPrepend).addAll(list).build();
    }

    public static <K, V> Map<K, V> copyAndPut(Map<K, V> map, K keyToAppend, V valueToAppend) {
        return ImmutableMap.builderWithExpectedSize((int)(map.size() + 1)).putAll(map).put(keyToAppend, valueToAppend).buildKeepingLast();
    }

    public static enum OS {
        LINUX("linux"),
        SOLARIS("solaris"),
        WINDOWS("windows"){

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
            }
        }
        ,
        OSX("mac"){

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"open", uri.toString()};
            }
        }
        ,
        UNKNOWN("unknown");

        private final String telemetryName;

        private OS(String name) {
            this.telemetryName = name;
        }

        public void openUri(URI uri) {
            throw new IllegalStateException("This method is not useful on dedicated servers.");
        }

        public void openFile(File file) {
            this.openUri(file.toURI());
        }

        public void openPath(Path path) {
            this.openUri(path.toUri());
        }

        protected String[] getOpenUriArguments(URI uri) {
            String string = uri.toString();
            if ("file".equals(uri.getScheme())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void openUri(String uri) {
            try {
                this.openUri(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException var3) {
                LOGGER.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }
    }
}

