/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

public record SheepPredicate(Optional<Boolean> sheared, Optional<DyeColor> color) implements EntitySubPredicate
{
    public static final MapCodec<SheepPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("sheared").forGetter(SheepPredicate::sheared), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(SheepPredicate::color)).apply((Applicative)instance, SheepPredicate::new));

    @Override
    public MapCodec<SheepPredicate> codec() {
        return EntitySubPredicates.SHEEP;
    }

    @Override
    @Override
    public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (this.sheared.isPresent() && sheep.isSheared() != this.sheared.get().booleanValue()) {
                return false;
            }
            return !this.color.isPresent() || sheep.getColor() == this.color.get();
        }
        return false;
    }

    public static SheepPredicate hasWool(DyeColor color) {
        return new SheepPredicate(Optional.of(false), Optional.of(color));
    }
}

