/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class WorldCoordinates
implements Coordinates {
    private final WorldCoordinate x;
    private final WorldCoordinate y;
    private final WorldCoordinate z;

    public WorldCoordinates(WorldCoordinate x, WorldCoordinate y, WorldCoordinate z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @Override
    public Vec3 getPosition(CommandSourceStack source) {
        Vec3 vec3 = source.getPosition();
        return new Vec3(this.x.get(vec3.x), this.y.get(vec3.y), this.z.get(vec3.z));
    }

    @Override
    @Override
    public Vec2 getRotation(CommandSourceStack source) {
        Vec2 vec2 = source.getRotation();
        return new Vec2((float)this.x.get(vec2.x), (float)this.y.get(vec2.y));
    }

    @Override
    @Override
    public boolean isXRelative() {
        return this.x.isRelative();
    }

    @Override
    @Override
    public boolean isYRelative() {
        return this.y.isRelative();
    }

    @Override
    @Override
    public boolean isZRelative() {
        return this.z.isRelative();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorldCoordinates)) {
            return false;
        }
        WorldCoordinates worldCoordinates = (WorldCoordinates)object;
        if (!this.x.equals(worldCoordinates.x)) {
            return false;
        }
        if (!this.y.equals(worldCoordinates.y)) {
            return false;
        }
        return this.z.equals(worldCoordinates.z);
    }

    public static WorldCoordinates parseInt(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        WorldCoordinate worldCoordinate = WorldCoordinate.parseInt(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        WorldCoordinate worldCoordinate2 = WorldCoordinate.parseInt(reader);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        WorldCoordinate worldCoordinate3 = WorldCoordinate.parseInt(reader);
        return new WorldCoordinates(worldCoordinate, worldCoordinate2, worldCoordinate3);
    }

    public static WorldCoordinates parseDouble(StringReader reader, boolean centerIntegers) throws CommandSyntaxException {
        int i = reader.getCursor();
        WorldCoordinate worldCoordinate = WorldCoordinate.parseDouble(reader, centerIntegers);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        WorldCoordinate worldCoordinate2 = WorldCoordinate.parseDouble(reader, false);
        if (!reader.canRead() || reader.peek() != ' ') {
            reader.setCursor(i);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        WorldCoordinate worldCoordinate3 = WorldCoordinate.parseDouble(reader, centerIntegers);
        return new WorldCoordinates(worldCoordinate, worldCoordinate2, worldCoordinate3);
    }

    public static WorldCoordinates absolute(double x, double y, double z) {
        return new WorldCoordinates(new WorldCoordinate(false, x), new WorldCoordinate(false, y), new WorldCoordinate(false, z));
    }

    public static WorldCoordinates absolute(Vec2 vec) {
        return new WorldCoordinates(new WorldCoordinate(false, vec.x), new WorldCoordinate(false, vec.y), new WorldCoordinate(true, 0.0));
    }

    @Override
    public int hashCode() {
        int i = this.x.hashCode();
        i = 31 * i + this.y.hashCode();
        i = 31 * i + this.z.hashCode();
        return i;
    }
}

