/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;

public record SelectorPattern(String pattern, EntitySelector resolved) {
    public static final Codec<SelectorPattern> CODEC = Codec.STRING.comapFlatMap(SelectorPattern::parse, SelectorPattern::pattern);

    public static DataResult<SelectorPattern> parse(String selector) {
        try {
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(new StringReader(selector), true);
            return DataResult.success((Object)new SelectorPattern(selector, entitySelectorParser.parse()));
        }
        catch (CommandSyntaxException var2) {
            return DataResult.error(() -> "Invalid selector component");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SelectorPattern) {
            SelectorPattern selectorPattern = (SelectorPattern)object;
            if (this.pattern.equals(selectorPattern.pattern)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return this.pattern;
    }
}

