/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> wrapper) {
        return new EmptyTagLookup<T>(wrapper){

            @Override
            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                return wrapper.get(key);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> registryRef, final Lifecycle lifecycle, HolderOwner<T> owner, final Map<ResourceKey<T>, Holder.Reference<T>> entries) {
        return new EmptyTagRegistryLookup<T>(owner){

            @Override
            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return registryRef;
            }

            @Override
            @Override
            public Lifecycle registryLifecycle() {
                return lifecycle;
            }

            @Override
            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                return Optional.ofNullable((Holder.Reference)entries.get(key));
            }

            @Override
            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return entries.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> registryRef, Lifecycle lifecycle, RegistryBootstrap<T> bootstrapFunction) {
        this.entries.add(new RegistryStub<T>(registryRef, lifecycle, bootstrapFunction));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> registryRef, RegistryBootstrap<T> bootstrapFunction) {
        return this.add(registryRef, Lifecycle.stable(), bootstrapFunction);
    }

    private BuildState createState(RegistryAccess registryManager) {
        BuildState buildState = BuildState.create(registryManager, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(registry -> registry.apply(buildState));
        return buildState;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner entryOwner, RegistryAccess registryManager, Stream<HolderLookup.RegistryLookup<?>> wrappers) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> wrapper) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(wrapper, wrapper), RegistryOps.RegistryInfo.fromRegistryLookup(wrapper));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner owner, HolderLookup.RegistryLookup<T> wrapper) {
                return new Entry(new EmptyTagLookupWrapper(owner.cast(), wrapper), new RegistryOps.RegistryInfo(owner.cast(), wrapper, wrapper.registryLifecycle()));
            }
        }
        final HashMap map = new HashMap();
        registryManager.registries().forEach(registry -> map.put(registry.key(), Entry.createForContextRegistry(registry.value())));
        wrappers.forEach(wrapper -> map.put(wrapper.key(), Entry.createForNewRegistry(entryOwner, wrapper)));
        return new HolderLookup.Provider(){

            @Override
            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return map.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return Optional.ofNullable((Entry)map.get(registryRef));
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return this.getEntry(registryRef).map(Entry::lookup);
            }

            @Override
            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> delegate) {
                return RegistryOps.create(delegate, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                        return this.getEntry(registryRef).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess registryManager) {
        BuildState buildState = this.createState(registryManager);
        Stream<HolderLookup.RegistryLookup<?>> stream = this.entries.stream().map(info -> info.collectRegisteredValues(buildState).buildAsLookup(buildState.owner));
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(buildState.owner, registryManager, stream);
        buildState.reportNotCollectedHolders();
        buildState.reportUnclaimedRegisteredValues();
        buildState.throwOnError();
        return provider;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess registryManager, HolderLookup.Provider base, Cloner.Factory cloneableRegistries, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> initializedRegistries, HolderLookup.Provider patches) {
        UniversalOwner universalOwner = new UniversalOwner();
        MutableObject mutableObject = new MutableObject();
        List list = initializedRegistries.keySet().stream().map(registryRef -> this.createLazyFullPatchedRegistries(universalOwner, cloneableRegistries, (ResourceKey)registryRef, patches, base, (MutableObject<HolderLookup.Provider>)mutableObject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(universalOwner, registryManager, list.stream());
        mutableObject.setValue((Object)provider);
        return provider;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> owner, Cloner.Factory cloneableRegistries, ResourceKey<? extends Registry<? extends T>> registryRef, HolderLookup.Provider patches, HolderLookup.Provider base, MutableObject<HolderLookup.Provider> lazyWrapper) {
        Cloner cloner = cloneableRegistries.cloner(registryRef);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(registryRef.location()));
        }
        HashMap map = new HashMap();
        HolderGetter registryLookup = patches.lookupOrThrow(registryRef);
        registryLookup.listElements().forEach(entry -> {
            ResourceKey resourceKey = entry.key();
            LazyHolder lazyHolder = new LazyHolder(owner, resourceKey);
            lazyHolder.supplier = () -> cloner.clone(entry.value(), patches, (HolderLookup.Provider)lazyWrapper.getValue());
            map.put(resourceKey, lazyHolder);
        });
        HolderGetter registryLookup2 = base.lookupOrThrow(registryRef);
        registryLookup2.listElements().forEach(entry -> {
            ResourceKey resourceKey = entry.key();
            map.computeIfAbsent(resourceKey, key -> {
                LazyHolder lazyHolder = new LazyHolder(owner, resourceKey);
                lazyHolder.supplier = () -> cloner.clone(entry.value(), base, (HolderLookup.Provider)lazyWrapper.getValue());
                return lazyHolder;
            });
        });
        Lifecycle lifecycle = registryLookup.registryLifecycle().add(registryLookup2.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(registryRef, lifecycle, owner, map);
    }

    public PatchedRegistries buildPatch(RegistryAccess baseRegistryManager, HolderLookup.Provider registries, Cloner.Factory cloneableRegistries) {
        BuildState buildState = this.createState(baseRegistryManager);
        HashMap map = new HashMap();
        this.entries.stream().map(info -> info.collectRegisteredValues(buildState)).forEach(registry -> map.put((ResourceKey<Registry<?>>)registry.key, (RegistryContents<?>)registry));
        Set set = baseRegistryManager.listRegistryKeys().collect(Collectors.toUnmodifiableSet());
        registries.listRegistryKeys().filter(key -> !set.contains(key)).forEach(key -> map.putIfAbsent((ResourceKey<Registry<?>>)key, new RegistryContents(key, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> stream = map.values().stream().map(registry -> registry.buildAsLookup(buildState.owner));
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(buildState.owner, baseRegistryManager, stream);
        buildState.reportUnclaimedRegisteredValues();
        buildState.throwOnError();
        HolderLookup.Provider provider2 = this.createLazyFullPatchedRegistries(baseRegistryManager, registries, cloneableRegistries, map, provider);
        return new PatchedRegistries(provider2, provider);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState registries) {
            this.bootstrap.run(registries.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState registries) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = registries.registeredValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.isFor(this.key)) continue;
                ResourceKey<?> resourceKey2 = resourceKey;
                RegisteredValue<?> registeredValue = entry.getValue();
                Holder.Reference<Object> reference = registries.lookup.holders.remove(resourceKey);
                map.put(resourceKey2, new ValueAndHolder(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, map);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    record BuildState(UniversalOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess dynamicRegistryManager, Stream<ResourceKey<? extends Registry<?>>> registryRefs) {
            UniversalOwner universalOwner = new UniversalOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup universalLookup = new UniversalLookup(universalOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            dynamicRegistryManager.registries().forEach(entry -> builder.put((Object)entry.key().location(), RegistrySetBuilder.wrapContextLookup(entry.value())));
            registryRefs.forEach(registryRef -> builder.put((Object)registryRef.location(), (Object)universalLookup));
            return new BuildState(universalOwner, universalLookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                @Override
                public Holder.Reference<T> register(ResourceKey<T> key, T value, Lifecycle lifecycle) {
                    RegisteredValue registeredValue = registeredValues.put(key, new RegisteredValue(value, lifecycle));
                    if (registeredValue != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(key) + ", new=" + String.valueOf(value) + ", old=" + String.valueOf(registeredValue.value)));
                    }
                    return lookup.getOrCreate(key);
                }

                @Override
                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> registryRef) {
                    return registries.getOrDefault(registryRef.location(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((key, value) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(value.value) + " for key " + String.valueOf(key))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> resourceKey : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourceKey)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.errors) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner anyOwner) {
            Map map = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                ValueAndHolder valueAndHolder = (ValueAndHolder)entry.getValue();
                Holder.Reference reference = valueAndHolder.holder().orElseGet(() -> Holder.Reference.createStandAlone(anyOwner.cast(), (ResourceKey)entry.getKey()));
                reference.bindValue(valueAndHolder.value().value());
                return reference;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, anyOwner.cast(), map);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> owner, @Nullable ResourceKey<T> key) {
            super(Holder.Reference.Type.STAND_ALONE, owner, key, null);
        }

        @Override
        @Override
        protected void bindValue(T value) {
            super.bindValue(value);
            this.supplier = null;
        }

        @Override
        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> key) {
            return Optional.of(this.getOrCreate(key));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> key) {
            return this.holders.computeIfAbsent(key, key2 -> Holder.Reference.createStandAlone(this.owner, key2));
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> entryOwner, HolderLookup.RegistryLookup<T> base) {
            super(entryOwner);
            this.parent = base;
        }

        @Override
        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> entryOwner) {
            this.owner = entryOwner;
        }

        @Override
        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> tag) {
            return Optional.of(HolderSet.emptyNamed(this.owner, tag));
        }
    }
}

