/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class Rotations {
    public static final StreamCodec<ByteBuf, Rotations> STREAM_CODEC = new StreamCodec<ByteBuf, Rotations>(){

        @Override
        public Rotations decode(ByteBuf byteBuf) {
            return new Rotations(byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat());
        }

        @Override
        public void encode(ByteBuf byteBuf, Rotations rotations) {
            byteBuf.writeFloat(rotations.x);
            byteBuf.writeFloat(rotations.y);
            byteBuf.writeFloat(rotations.z);
        }
    };
    protected final float x;
    protected final float y;
    protected final float z;

    public Rotations(float pitch, float yaw, float roll) {
        this.x = !Float.isInfinite(pitch) && !Float.isNaN(pitch) ? pitch % 360.0f : 0.0f;
        this.y = !Float.isInfinite(yaw) && !Float.isNaN(yaw) ? yaw % 360.0f : 0.0f;
        this.z = !Float.isInfinite(roll) && !Float.isNaN(roll) ? roll % 360.0f : 0.0f;
    }

    public Rotations(ListTag serialized) {
        this(serialized.getFloat(0), serialized.getFloat(1), serialized.getFloat(2));
    }

    private Rotations(float x, float y, float z, Void dummy_var) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Rotations createWithoutValidityChecks(float x, float y, float z) {
        return new Rotations(x, y, z, null);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add(FloatTag.valueOf(this.x));
        listTag.add(FloatTag.valueOf(this.y));
        listTag.add(FloatTag.valueOf(this.z));
        return listTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Rotations)) return false;
        Rotations rotations = (Rotations)object;
        if (this.x != rotations.x) return false;
        if (this.y != rotations.y) return false;
        if (this.z != rotations.z) return false;
        return true;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getWrappedX() {
        return Mth.wrapDegrees(this.x);
    }

    public float getWrappedY() {
        return Mth.wrapDegrees(this.y);
    }

    public float getWrappedZ() {
        return Mth.wrapDegrees(this.z);
    }
}

