/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentHolder {
    public DataComponentMap getComponents();

    @Nullable
    default public <T> T get(DataComponentType<? extends T> type) {
        return this.getComponents().get(type);
    }

    default public <T> Stream<T> getAllOfType(Class<? extends T> valueClass) {
        return this.getComponents().stream().map(TypedDataComponent::value).filter(value -> valueClass.isAssignableFrom(value.getClass())).map(value -> value);
    }

    default public <T> T getOrDefault(DataComponentType<? extends T> type, T fallback) {
        return this.getComponents().getOrDefault(type, fallback);
    }

    default public boolean has(DataComponentType<?> type) {
        return this.getComponents().has(type);
    }
}

