/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public final class PatchedDataComponentMap
implements DataComponentMap {
    private final DataComponentMap prototype;
    private Reference2ObjectMap<DataComponentType<?>, Optional<?>> patch;
    private boolean copyOnWrite;

    public PatchedDataComponentMap(DataComponentMap baseComponents) {
        this(baseComponents, Reference2ObjectMaps.emptyMap(), true);
    }

    private PatchedDataComponentMap(DataComponentMap baseComponents, Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents, boolean copyOnWrite) {
        this.prototype = baseComponents;
        this.patch = changedComponents;
        this.copyOnWrite = copyOnWrite;
    }

    public static PatchedDataComponentMap fromPatch(DataComponentMap baseComponents, DataComponentPatch changes) {
        if (PatchedDataComponentMap.isPatchSanitized(baseComponents, changes.map)) {
            return new PatchedDataComponentMap(baseComponents, changes.map, true);
        }
        PatchedDataComponentMap patchedDataComponentMap = new PatchedDataComponentMap(baseComponents);
        patchedDataComponentMap.applyPatch(changes);
        return patchedDataComponentMap;
    }

    private static boolean isPatchSanitized(DataComponentMap baseComponents, Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents) {
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changedComponents)) {
            Object object = baseComponents.get((DataComponentType)entry.getKey());
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent() && optional.get().equals(object)) {
                return false;
            }
            if (!optional.isEmpty() || object != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    @Override
    public <T> T get(DataComponentType<? extends T> type) {
        Optional optional = (Optional)this.patch.get(type);
        if (optional != null) {
            return optional.orElse(null);
        }
        return this.prototype.get(type);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> type, @Nullable T value) {
        Optional optional2;
        this.ensureMapOwnership();
        T object = this.prototype.get(type);
        if (Objects.equals(value, object)) {
            Optional optional = (Optional)this.patch.remove(type);
        } else {
            optional2 = (Optional)this.patch.put(type, Optional.ofNullable(value));
        }
        if (optional2 != null) {
            return optional2.orElse(object);
        }
        return object;
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        Optional optional2;
        this.ensureMapOwnership();
        T object = this.prototype.get(type);
        if (object != null) {
            Optional optional = (Optional)this.patch.put(type, Optional.empty());
        } else {
            optional2 = (Optional)this.patch.remove(type);
        }
        if (optional2 != null) {
            return optional2.orElse(null);
        }
        return object;
    }

    public void applyPatch(DataComponentPatch changes) {
        this.ensureMapOwnership();
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changes.map)) {
            this.applyPatch((DataComponentType)entry.getKey(), (Optional)entry.getValue());
        }
    }

    private void applyPatch(DataComponentType<?> type, Optional<?> optional) {
        Object object = this.prototype.get(type);
        if (optional.isPresent()) {
            if (optional.get().equals(object)) {
                this.patch.remove(type);
            } else {
                this.patch.put(type, optional);
            }
        } else if (object != null) {
            this.patch.put(type, Optional.empty());
        } else {
            this.patch.remove(type);
        }
    }

    public void restorePatch(DataComponentPatch changes) {
        this.ensureMapOwnership();
        this.patch.clear();
        this.patch.putAll(changes.map);
    }

    public void clearPatch() {
        this.ensureMapOwnership();
        this.patch.clear();
    }

    public void setAll(DataComponentMap components) {
        for (TypedDataComponent<?> typedDataComponent : components) {
            typedDataComponent.applyTo(this);
        }
    }

    private void ensureMapOwnership() {
        if (this.copyOnWrite) {
            this.patch = new Reference2ObjectArrayMap(this.patch);
            this.copyOnWrite = false;
        }
    }

    @Override
    @Override
    public Set<DataComponentType<?>> keySet() {
        if (this.patch.isEmpty()) {
            return this.prototype.keySet();
        }
        ReferenceArraySet set = new ReferenceArraySet(this.prototype.keySet());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.patch)) {
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                set.add((DataComponentType)entry.getKey());
                continue;
            }
            set.remove(entry.getKey());
        }
        return set;
    }

    @Override
    @Override
    public Iterator<TypedDataComponent<?>> iterator() {
        if (this.patch.isEmpty()) {
            return this.prototype.iterator();
        }
        ArrayList<TypedDataComponent> list = new ArrayList<TypedDataComponent>(this.patch.size() + this.prototype.size());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.patch)) {
            if (!((Optional)entry.getValue()).isPresent()) continue;
            list.add(TypedDataComponent.createUnchecked((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get()));
        }
        for (TypedDataComponent typedDataComponent : this.prototype) {
            if (this.patch.containsKey(typedDataComponent.type())) continue;
            list.add(typedDataComponent);
        }
        return list.iterator();
    }

    @Override
    @Override
    public int size() {
        int i = this.prototype.size();
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.patch)) {
            boolean bl2;
            boolean bl = ((Optional)entry.getValue()).isPresent();
            if (bl == (bl2 = this.prototype.has((DataComponentType)entry.getKey()))) continue;
            i += bl ? 1 : -1;
        }
        return i;
    }

    public DataComponentPatch asPatch() {
        if (this.patch.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        this.copyOnWrite = true;
        return new DataComponentPatch(this.patch);
    }

    public PatchedDataComponentMap copy() {
        this.copyOnWrite = true;
        return new PatchedDataComponentMap(this.prototype, this.patch, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatchedDataComponentMap)) return false;
        PatchedDataComponentMap patchedDataComponentMap = (PatchedDataComponentMap)object;
        if (!this.prototype.equals(patchedDataComponentMap.prototype)) return false;
        if (!this.patch.equals(patchedDataComponentMap.patch)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.prototype.hashCode() + this.patch.hashCode() * 31;
    }

    @Override
    public String toString() {
        return "{" + this.stream().map(TypedDataComponent::toString).collect(Collectors.joining(", ")) + "}";
    }
}

