/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class ShulkerBoxDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
        this.setSuccess(false);
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            net.minecraft.world.item.ItemStack eventStack;
            DispenseItemBehavior idispensebehavior;
            Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
            BlockPos blockposition = pointer.pos().relative(enumdirection);
            Direction enumdirection1 = pointer.level().isEmptyBlock(blockposition.below()) ? enumdirection : Direction.UP;
            CraftBlock bukkitBlock = CraftBlock.at(pointer.level(), pointer.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
            BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
            if (!DispenserBlock.eventFired) {
                pointer.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return stack;
            }
            if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.getDispenseBehavior(pointer, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(pointer, eventStack);
                return stack;
            }
            try {
                this.setSuccess(((BlockItem)item).place(new DirectionalPlaceContext((Level)pointer.level(), blockposition, enumdirection, CraftItemStack.asNMSCopy(event.getItem()), enumdirection1)).consumesAction());
                if (this.isSuccess()) {
                    stack.shrink(1);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)blockposition, (Object)exception);
            }
        }
        return stack;
    }
}

