/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.EquipmentModels;

public class EquipmentModelProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public EquipmentModelProvider(PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models/equipment");
    }

    @Override
    @Override
    public CompletableFuture<?> run(CachedOutput writer) {
        HashMap map = new HashMap();
        EquipmentModels.bootstrap((id, model) -> {
            if (map.putIfAbsent(id, model) != null) {
                throw new IllegalStateException("Tried to register equipment model twice for id: " + String.valueOf(id));
            }
        });
        return DataProvider.saveAll(writer, EquipmentModel.CODEC, this.pathProvider, map);
    }

    @Override
    @Override
    public String getName() {
        return "Equipment Model Definitions";
    }
}

