/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class ItemTagsProvider
extends IntrinsicHolderTagsProvider<Item> {
    private final CompletableFuture<TagsProvider.TagLookup<Block>> blockTags;
    private final Map<TagKey<Block>, TagKey<Item>> tagsToCopy = new HashMap<TagKey<Block>, TagKey<Item>>();

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagLookupFuture) {
        super(output, Registries.ITEM, registriesFuture, (T item) -> item.builtInRegistryHolder().key());
        this.blockTags = blockTagLookupFuture;
    }

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, CompletableFuture<TagsProvider.TagLookup<Item>> parentTagLookupFuture, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagLookupFuture) {
        super(output, Registries.ITEM, registriesFuture, parentTagLookupFuture, item -> item.builtInRegistryHolder().key());
        this.blockTags = blockTagLookupFuture;
    }

    protected void copy(TagKey<Block> blockTag, TagKey<Item> itemTag) {
        this.tagsToCopy.put(blockTag, itemTag);
    }

    @Override
    @Override
    protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
        return super.createContentsProvider().thenCombine(this.blockTags, (registries, blockTags) -> {
            this.tagsToCopy.forEach((blockTag, itemTag) -> {
                TagBuilder tagBuilder = this.getOrCreateRawBuilder(itemTag);
                Optional optional = (Optional)blockTags.apply(blockTag);
                ((TagBuilder)optional.orElseThrow(() -> new IllegalStateException("Missing block tag " + String.valueOf(itemTag.location())))).build().forEach(tagBuilder::add);
            });
            return registries;
        });
    }
}

