/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.BastionPieces;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.PillagerOutpostPools;
import net.minecraft.data.worldgen.TrailRuinsStructurePools;
import net.minecraft.data.worldgen.TrialChambersStructurePools;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Pools {
    public static final ResourceKey<StructureTemplatePool> EMPTY = Pools.createKey("empty");

    public static ResourceKey<StructureTemplatePool> createKey(ResourceLocation id) {
        return ResourceKey.create(Registries.TEMPLATE_POOL, id);
    }

    public static ResourceKey<StructureTemplatePool> createKey(String id) {
        return Pools.createKey(ResourceLocation.withDefaultNamespace(id));
    }

    public static ResourceKey<StructureTemplatePool> parseKey(String id) {
        return Pools.createKey(ResourceLocation.parse(id));
    }

    public static void register(BootstrapContext<StructureTemplatePool> structurePoolsRegisterable, String id, StructureTemplatePool pool) {
        structurePoolsRegisterable.register(Pools.createKey(id), pool);
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> structurePoolsRegisterable) {
        HolderGetter<StructureTemplatePool> holderGetter = structurePoolsRegisterable.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder = holderGetter.getOrThrow(EMPTY);
        structurePoolsRegisterable.register(EMPTY, new StructureTemplatePool(holder, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(), StructureTemplatePool.Projection.RIGID));
        BastionPieces.bootstrap(structurePoolsRegisterable);
        PillagerOutpostPools.bootstrap(structurePoolsRegisterable);
        VillagePools.bootstrap(structurePoolsRegisterable);
        AncientCityStructurePieces.bootstrap(structurePoolsRegisterable);
        TrailRuinsStructurePools.bootstrap(structurePoolsRegisterable);
        TrialChambersStructurePools.bootstrap(structurePoolsRegisterable);
    }
}

