/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class CipherDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private final VelocityCipher cipher;

    public CipherDecoder(VelocityCipher cipher) {
        this.cipher = cipher;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        ByteBuf compatible = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.cipher, (ByteBuf)byteBuf);
        try {
            this.cipher.process(compatible);
            list.add(compatible);
        }
        catch (Exception e) {
            compatible.release();
            throw e;
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cipher.close();
    }
}

