/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.papermc.paper.annotation.DoNotUse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.VarInt;

public class CompressionDecoder
extends ByteToMessageDecoder {
    public static final int MAXIMUM_COMPRESSED_LENGTH = 0x200000;
    public static final int MAXIMUM_UNCOMPRESSED_LENGTH = 0x800000;
    private Inflater inflater;
    private VelocityCompressor compressor;
    private int threshold;
    private boolean validateDecompressed;

    @DoNotUse
    public CompressionDecoder(int compressionThreshold, boolean rejectsBadPackets) {
        this(null, compressionThreshold, rejectsBadPackets);
    }

    public CompressionDecoder(VelocityCompressor compressor, int compressionThreshold, boolean rejectsBadPackets) {
        this.threshold = compressionThreshold;
        this.validateDecompressed = rejectsBadPackets;
        this.inflater = compressor == null ? new Inflater() : null;
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            int i = VarInt.read(byteBuf);
            if (i == 0) {
                list.add(byteBuf.readBytes(byteBuf.readableBytes()));
            } else {
                if (this.validateDecompressed) {
                    if (i < this.threshold) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is below server threshold of " + this.threshold);
                    }
                    if (i > 0x800000) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is larger than protocol maximum of 8388608");
                    }
                }
                if (this.inflater != null) {
                    this.setupInflaterInput(byteBuf);
                    ByteBuf byteBuf2 = this.inflate(channelHandlerContext, i);
                    this.inflater.reset();
                    list.add(byteBuf2);
                    return;
                }
                int claimedUncompressedSize = i;
                ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (ByteBuf)byteBuf);
                ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
                try {
                    this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                    list.add(uncompressed);
                    byteBuf.clear();
                }
                catch (Exception e) {
                    uncompressed.release();
                    throw e;
                }
                finally {
                    compatibleIn.release();
                }
            }
        }
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    private void setupInflaterInput(ByteBuf buf) {
        ByteBuffer byteBuffer;
        if (buf.nioBufferCount() > 0) {
            byteBuffer = buf.nioBuffer();
            buf.skipBytes(buf.readableBytes());
        } else {
            byteBuffer = ByteBuffer.allocateDirect(buf.readableBytes());
            buf.readBytes(byteBuffer);
            byteBuffer.flip();
        }
        this.inflater.setInput(byteBuffer);
    }

    private ByteBuf inflate(ChannelHandlerContext context, int expectedSize) throws DataFormatException {
        ByteBuf byteBuf = context.alloc().directBuffer(expectedSize);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(0, expectedSize);
            int i = byteBuffer.position();
            this.inflater.inflate(byteBuffer);
            int j = byteBuffer.position() - i;
            if (j != expectedSize) {
                throw new DecoderException("Badly compressed packet - actual length of uncompressed payload " + j + " is does not match declared size " + expectedSize);
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + j);
            return byteBuf;
        }
        catch (Exception var7) {
            byteBuf.release();
            throw var7;
        }
    }

    public void setThreshold(VelocityCompressor compressor, int compressionThreshold, boolean rejectsBadPackets) {
        if (this.compressor == null && compressor != null) {
            this.compressor = compressor;
            this.inflater = null;
        }
        this.threshold = compressionThreshold;
        this.validateDecompressed = rejectsBadPackets;
    }
}

