/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        @Override
        public Boolean decode(ByteBuf byteBuf) {
            return byteBuf.readBoolean();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Boolean boolean_) {
            byteBuf.writeBoolean(boolean_.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Boolean)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        @Override
        public Byte decode(ByteBuf byteBuf) {
            return byteBuf.readByte();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Byte byte_) {
            byteBuf.writeByte((int)byte_.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Byte)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Float> ROTATION_BYTE = BYTE.map(Mth::unpackDegrees, Mth::packDegrees);
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        @Override
        public Short decode(ByteBuf byteBuf) {
            return byteBuf.readShort();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Short short_) {
            byteBuf.writeShort((int)short_.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Short)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        @Override
        public Integer decode(ByteBuf byteBuf) {
            return byteBuf.readUnsignedShort();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeShort(integer.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        @Override
        public Integer decode(ByteBuf byteBuf) {
            return byteBuf.readInt();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeInt(integer.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        @Override
        public Integer decode(ByteBuf byteBuf) {
            return VarInt.read(byteBuf);
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            VarInt.write(byteBuf, integer);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_VAR_INT = VAR_INT.map(value -> value == 0 ? OptionalInt.empty() : OptionalInt.of(value - 1), value -> value.isPresent() ? value.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        @Override
        public Long decode(ByteBuf byteBuf) {
            return byteBuf.readLong();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Long long_) {
            byteBuf.writeLong(long_.longValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Long)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        @Override
        public Long decode(ByteBuf byteBuf) {
            return VarLong.read(byteBuf);
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Long long_) {
            VarLong.write(byteBuf, long_);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Long)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        @Override
        public Float decode(ByteBuf byteBuf) {
            return Float.valueOf(byteBuf.readFloat());
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Float float_) {
            byteBuf.writeFloat(float_.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Float)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        @Override
        public Double decode(ByteBuf byteBuf) {
            return byteBuf.readDouble();
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Double double_) {
            byteBuf.writeDouble(double_.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Double)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        @Override
        public byte[] decode(ByteBuf buf) {
            return FriendlyByteBuf.readByteArray(buf);
        }

        @Override
        @Override
        public void encode(ByteBuf buf, byte[] value) {
            FriendlyByteBuf.writeByteArray(buf, value);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (byte[])value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        @Override
        @Override
        public Optional<CompoundTag> decode(ByteBuf byteBuf) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt(byteBuf));
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Optional<CompoundTag> optional) {
            FriendlyByteBuf.writeNbt(byteBuf, optional.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Optional)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        @Override
        public Vector3f decode(ByteBuf byteBuf) {
            return FriendlyByteBuf.readVector3f(byteBuf);
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Vector3f vector3f) {
            FriendlyByteBuf.writeVector3f(byteBuf, vector3f);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Vector3f)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        @Override
        @Override
        public Quaternionf decode(ByteBuf byteBuf) {
            return FriendlyByteBuf.readQuaternion(byteBuf);
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Quaternionf quaternionf) {
            FriendlyByteBuf.writeQuaternion(byteBuf, quaternionf);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Quaternionf)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> CONTAINER_ID = new StreamCodec<ByteBuf, Integer>(){

        @Override
        @Override
        public Integer decode(ByteBuf byteBuf) {
            return FriendlyByteBuf.readContainerId(byteBuf);
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            FriendlyByteBuf.writeContainerId(byteBuf, integer);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        @Override
        @Override
        public PropertyMap decode(ByteBuf byteBuf) {
            int i = ByteBufCodecs.readCount(byteBuf, 16);
            PropertyMap propertyMap = new PropertyMap();
            for (int j = 0; j < i; ++j) {
                String string = Utf8String.read(byteBuf, 64);
                String string2 = Utf8String.read(byteBuf, Short.MAX_VALUE);
                String string3 = FriendlyByteBuf.readNullable(byteBuf, buf2 -> Utf8String.read(buf2, 1024));
                Property property = new Property(string, string2, string3);
                propertyMap.put((Object)property.name(), (Object)property);
            }
            return propertyMap;
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, PropertyMap propertyMap) {
            ByteBufCodecs.writeCount(byteBuf, propertyMap.size(), 16);
            for (Property property : propertyMap.values()) {
                Utf8String.write(byteBuf, property.name(), 64);
                Utf8String.write(byteBuf, property.value(), Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable(byteBuf, property.signature(), (buf2, signature) -> Utf8String.write(buf2, signature, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (PropertyMap)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = new StreamCodec<ByteBuf, GameProfile>(){

        @Override
        @Override
        public GameProfile decode(ByteBuf byteBuf) {
            UUID uUID = (UUID)UUIDUtil.STREAM_CODEC.decode(byteBuf);
            String string = Utf8String.read(byteBuf, 16);
            GameProfile gameProfile = new GameProfile(uUID, string);
            gameProfile.getProperties().putAll((Multimap)GAME_PROFILE_PROPERTIES.decode(byteBuf));
            return gameProfile;
        }

        @Override
        @Override
        public void encode(ByteBuf byteBuf, GameProfile gameProfile) {
            UUIDUtil.STREAM_CODEC.encode(byteBuf, gameProfile.getId());
            Utf8String.write(byteBuf, gameProfile.getName(), 16);
            GAME_PROFILE_PROPERTIES.encode(byteBuf, gameProfile.getProperties());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((ByteBuf)buf, (GameProfile)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((ByteBuf)buf);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int maxLength) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            @Override
            public byte[] decode(ByteBuf buf) {
                return FriendlyByteBuf.readByteArray(buf, maxLength);
            }

            @Override
            @Override
            public void encode(ByteBuf buf, byte[] value) {
                if (value.length > maxLength) {
                    throw new EncoderException("ByteArray with size " + value.length + " is bigger than allowed " + maxLength);
                }
                FriendlyByteBuf.writeByteArray(buf, value);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((ByteBuf)buf, (byte[])value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int maxLength) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            @Override
            public String decode(ByteBuf byteBuf) {
                return Utf8String.read(byteBuf, maxLength);
            }

            @Override
            @Override
            public void encode(ByteBuf byteBuf, String string) {
                Utf8String.write(byteBuf, string, maxLength);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((ByteBuf)buf, (String)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> sizeTracker) {
        return new StreamCodec<ByteBuf, Tag>(){

            @Override
            @Override
            public Tag decode(ByteBuf byteBuf) {
                Tag tag = FriendlyByteBuf.readNbt(byteBuf, (NbtAccounter)sizeTracker.get());
                if (tag == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return tag;
            }

            @Override
            @Override
            public void encode(ByteBuf byteBuf, Tag tag) {
                if (tag == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt(byteBuf, tag);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((ByteBuf)buf, (Tag)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> sizeTracker) {
        return ByteBufCodecs.tagCodec(sizeTracker).map(nbt -> {
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt;
                return compoundTag;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbt));
        }, nbt -> nbt);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> codec) {
        return ByteBufCodecs.fromCodec(codec, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> codec) {
        return ByteBufCodecs.fromCodec(codec, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> codec, Supplier<NbtAccounter> sizeTracker) {
        return ByteBufCodecs.tagCodec(sizeTracker).map(nbt -> codec.parse((DynamicOps)NbtOps.INSTANCE, nbt).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(nbt))), value -> (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(value))));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> codec) {
        return ByteBufCodecs.fromCodecWithRegistries(codec, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> codec) {
        return ByteBufCodecs.fromCodecWithRegistries(codec, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> codec, Supplier<NbtAccounter> sizeTracker) {
        final StreamCodec<ByteBuf, Tag> streamCodec = ByteBufCodecs.tagCodec(sizeTracker);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            @Override
            public T decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                Tag tag = (Tag)streamCodec.decode(registryFriendlyByteBuf);
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return codec.parse(registryOps, (Object)tag).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(tag)));
            }

            @Override
            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, T object) {
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag tag = (Tag)codec.encodeStart(registryOps, object).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(object)));
                streamCodec.encode(registryFriendlyByteBuf, tag);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((RegistryFriendlyByteBuf)((Object)buf), value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> codec) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            @Override
            public Optional<V> decode(B byteBuf) {
                if (byteBuf.readBoolean()) {
                    return Optional.of(codec.decode(byteBuf));
                }
                return Optional.empty();
            }

            @Override
            @Override
            public void encode(B byteBuf, Optional<V> optional) {
                if (optional.isPresent()) {
                    byteBuf.writeBoolean(true);
                    codec.encode(byteBuf, optional.get());
                } else {
                    byteBuf.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((Object)((ByteBuf)buf), (Optional)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((B)((ByteBuf)buf));
            }
        };
    }

    public static int readCount(ByteBuf buf, int maxSize) {
        int i = VarInt.read(buf);
        if (i > maxSize) {
            throw new DecoderException(i + " elements exceeded max size of: " + maxSize);
        }
        return i;
    }

    public static void writeCount(ByteBuf buf, int size, int maxSize) {
        if (size > maxSize) {
            throw new EncoderException(size + " elements exceeded max size of: " + maxSize);
        }
        VarInt.write(buf, size);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> factory, StreamCodec<? super B, V> elementCodec) {
        return ByteBufCodecs.collection(factory, elementCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> factory, final StreamCodec<? super B, V> elementCodec, final int maxSize) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B byteBuf) {
                int i = ByteBufCodecs.readCount(byteBuf, maxSize);
                Collection collection = (Collection)factory.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    collection.add(elementCodec.decode(byteBuf));
                }
                return collection;
            }

            @Override
            @Override
            public void encode(B byteBuf, C collection) {
                ByteBufCodecs.writeCount(byteBuf, collection.size(), maxSize);
                for (Object object : collection) {
                    elementCodec.encode(byteBuf, object);
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((B)((ByteBuf)buf), (C)((Collection)value));
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((B)((ByteBuf)buf));
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> collectionFactory) {
        return codec -> ByteBufCodecs.collection(collectionFactory, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return codec -> ByteBufCodecs.collection(ArrayList::new, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int maxLength) {
        return codec -> ByteBufCodecs.collection(ArrayList::new, codec, maxLength);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> factory, StreamCodec<? super B, K> keyCodec, StreamCodec<? super B, V> valueCodec) {
        return ByteBufCodecs.map(factory, keyCodec, valueCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> factory, final StreamCodec<? super B, K> keyCodec, final StreamCodec<? super B, V> valueCodec, final int maxSize) {
        return new StreamCodec<B, M>(){

            @Override
            @Override
            public void encode(B byteBuf, M map) {
                ByteBufCodecs.writeCount(byteBuf, map.size(), maxSize);
                map.forEach((k, v) -> {
                    keyCodec.encode(byteBuf, k);
                    valueCodec.encode(byteBuf, v);
                });
            }

            @Override
            @Override
            public M decode(B byteBuf) {
                int i = ByteBufCodecs.readCount(byteBuf, maxSize);
                Map map = (Map)factory.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    Object object = keyCodec.decode(byteBuf);
                    Object object2 = valueCodec.decode(byteBuf);
                    map.put(object, object2);
                }
                return map;
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((B)((ByteBuf)buf), (M)((Map)value));
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((B)((ByteBuf)buf));
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> left, final StreamCodec<? super B, R> right) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            @Override
            public Either<L, R> decode(B byteBuf) {
                if (byteBuf.readBoolean()) {
                    return Either.left(left.decode(byteBuf));
                }
                return Either.right(right.decode(byteBuf));
            }

            @Override
            @Override
            public void encode(B byteBuf, Either<L, R> either) {
                either.ifLeft(left -> {
                    byteBuf.writeBoolean(true);
                    left.encode(byteBuf, left);
                }).ifRight(right -> {
                    byteBuf.writeBoolean(false);
                    right.encode(byteBuf, right);
                });
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((Object)((ByteBuf)buf), (Either)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((B)((ByteBuf)buf));
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> indexToValue, final ToIntFunction<T> valueToIndex) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            @Override
            public T decode(ByteBuf byteBuf) {
                int i = VarInt.read(byteBuf);
                return indexToValue.apply(i);
            }

            @Override
            @Override
            public void encode(ByteBuf byteBuf, T object) {
                int i = valueToIndex.applyAsInt(object);
                VarInt.write(byteBuf, i);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((ByteBuf)buf, value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((ByteBuf)buf);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> iterable) {
        return ByteBufCodecs.idMapper(iterable::byIdOrThrow, iterable::getIdOrThrow);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> registry, final Function<Registry<T>, IdMap<R>> registryTransformer) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf buf) {
                return (IdMap)registryTransformer.apply(buf.registryAccess().lookupOrThrow(registry));
            }

            @Override
            @Override
            public R decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i = VarInt.read(registryFriendlyByteBuf);
                return this.getRegistryOrThrow(registryFriendlyByteBuf).byIdOrThrow(i);
            }

            @Override
            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, R object) {
                int i = this.getRegistryOrThrow(registryFriendlyByteBuf).getIdOrThrow(object);
                VarInt.write(registryFriendlyByteBuf, i);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((RegistryFriendlyByteBuf)((Object)buf), value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> registry2) {
        return ByteBufCodecs.registry(registry2, registry -> registry);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> registry) {
        return ByteBufCodecs.registry(registry, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> registry, final StreamCodec<? super RegistryFriendlyByteBuf, T> directCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf buf) {
                return buf.registryAccess().lookupOrThrow(registry).asHolderIdMap();
            }

            @Override
            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i = VarInt.read(registryFriendlyByteBuf);
                if (i == 0) {
                    return Holder.direct(directCodec.decode(registryFriendlyByteBuf));
                }
                return this.getRegistryOrThrow(registryFriendlyByteBuf).byIdOrThrow(i - 1);
            }

            @Override
            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Holder<T> holder) {
                switch (holder.kind()) {
                    case REFERENCE: {
                        int i = this.getRegistryOrThrow(registryFriendlyByteBuf).getIdOrThrow(holder);
                        VarInt.write(registryFriendlyByteBuf, i + 1);
                        break;
                    }
                    case DIRECT: {
                        VarInt.write(registryFriendlyByteBuf, 0);
                        directCodec.encode(registryFriendlyByteBuf, holder.value());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((RegistryFriendlyByteBuf)((Object)buf), (Holder)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> registryRef) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(registryRef);
            }

            @Override
            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i = VarInt.read(registryFriendlyByteBuf) - 1;
                if (i == -1) {
                    HolderLookup.RegistryLookup registry = registryFriendlyByteBuf.registryAccess().lookupOrThrow(registryRef);
                    return (HolderSet)registry.get(TagKey.create(registryRef, (ResourceLocation)ResourceLocation.STREAM_CODEC.decode(registryFriendlyByteBuf))).orElseThrow();
                }
                ArrayList<Holder> list = new ArrayList<Holder>(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    list.add((Holder)this.holderCodec.decode(registryFriendlyByteBuf));
                }
                return HolderSet.direct(list);
            }

            @Override
            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, HolderSet<T> holderSet) {
                Optional optional = holderSet.unwrapKey();
                if (optional.isPresent()) {
                    VarInt.write(registryFriendlyByteBuf, 0);
                    ResourceLocation.STREAM_CODEC.encode(registryFriendlyByteBuf, optional.get().location());
                } else {
                    VarInt.write(registryFriendlyByteBuf, holderSet.size() + 1);
                    for (Holder holder : holderSet) {
                        this.holderCodec.encode(registryFriendlyByteBuf, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((RegistryFriendlyByteBuf)((Object)buf), (HolderSet)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }
}

