/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;

public class ClientboundSetHeldSlotPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSetHeldSlotPacket> STREAM_CODEC = Packet.codec(ClientboundSetHeldSlotPacket::write, ClientboundSetHeldSlotPacket::new);
    private final int slot;

    public ClientboundSetHeldSlotPacket(int slot) {
        this.slot = slot;
    }

    private ClientboundSetHeldSlotPacket(FriendlyByteBuf buf) {
        this.slot = buf.readByte();
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeByte(this.slot);
    }

    @Override
    @Override
    public PacketType<ClientboundSetHeldSlotPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_HELD_SLOT;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleSetHeldSlot(this);
    }

    public int getSlot() {
        return this.slot;
    }
}

