/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class DebugPackets {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void sendGameTestAddMarker(ServerLevel world, BlockPos pos, String message, int color, int duration) {
        DebugPackets.sendPacketToAllPlayers(world, new GameTestAddMarkerDebugPayload(pos, color, message, duration));
    }

    public static void sendGameTestClearPacket(ServerLevel world) {
        DebugPackets.sendPacketToAllPlayers(world, new GameTestClearMarkersDebugPayload());
    }

    public static void sendPoiPacketsForChunk(ServerLevel world, ChunkPos pos) {
    }

    public static void sendPoiAddedPacket(ServerLevel world, BlockPos pos) {
        DebugPackets.sendVillageSectionsPacket(world, pos);
    }

    public static void sendPoiRemovedPacket(ServerLevel world, BlockPos pos) {
        DebugPackets.sendVillageSectionsPacket(world, pos);
    }

    public static void sendPoiTicketCountPacket(ServerLevel world, BlockPos pos) {
        DebugPackets.sendVillageSectionsPacket(world, pos);
    }

    private static void sendVillageSectionsPacket(ServerLevel world, BlockPos pos) {
    }

    public static void sendPathFindingPacket(Level world, Mob mob, @Nullable Path path, float nodeReachProximity) {
    }

    public static void sendNeighborsUpdatePacket(Level world, BlockPos pos) {
    }

    public static void sendWireUpdates(Level world, RedstoneWireOrientationsDebugPayload payload) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            DebugPackets.sendPacketToAllPlayers(serverLevel, payload);
        }
    }

    public static void sendStructurePacket(WorldGenLevel world, StructureStart structureStart) {
    }

    public static void sendGoalSelector(Level world, Mob mob, GoalSelector goalSelector) {
    }

    public static void sendRaids(ServerLevel server, Collection<Raid> raids) {
    }

    public static void sendEntityBrain(LivingEntity living) {
    }

    public static void sendBeeInfo(Bee bee) {
    }

    public static void sendBreezeInfo(Breeze breeze) {
    }

    public static void sendGameEventInfo(Level world, Holder<GameEvent> event, Vec3 pos) {
    }

    public static void sendGameEventListenerInfo(Level world, GameEventListener eventListener) {
    }

    public static void sendHiveInfo(Level world, BlockPos pos, BlockState state, BeehiveBlockEntity blockEntity) {
    }

    private static List<String> getMemoryDescriptions(LivingEntity entity, long currentTime) {
        Map<MemoryModuleType<?>, Optional<ExpirableValue<?>>> map = entity.getBrain().getMemories();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> entry : map.entrySet()) {
            String string4;
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            Optional<ExpirableValue<?>> optional = entry.getValue();
            if (optional.isPresent()) {
                ExpirableValue<?> expirableValue = optional.get();
                Object object = expirableValue.getValue();
                if (memoryModuleType == MemoryModuleType.HEARD_BELL_TIME) {
                    long l = currentTime - (Long)object;
                    String string = l + " ticks ago";
                } else if (expirableValue.canExpire()) {
                    String string2 = DebugPackets.getShortDescription((ServerLevel)entity.level(), object) + " (ttl: " + expirableValue.getTimeToLive() + ")";
                } else {
                    String string3 = DebugPackets.getShortDescription((ServerLevel)entity.level(), object);
                }
            } else {
                string4 = "-";
            }
            list.add(BuiltInRegistries.MEMORY_MODULE_TYPE.getKey(memoryModuleType).getPath() + ": " + string4);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String getShortDescription(ServerLevel world, @Nullable Object object) {
        if (object == null) {
            return "-";
        }
        if (object instanceof UUID) {
            return DebugPackets.getShortDescription(world, world.getEntity((UUID)object));
        }
        if (object instanceof LivingEntity) {
            Entity entity = (Entity)object;
            return DebugEntityNameGenerator.getEntityName(entity);
        }
        if (object instanceof Nameable) {
            return ((Nameable)object).getName().getString();
        }
        if (object instanceof WalkTarget) {
            return DebugPackets.getShortDescription(world, ((WalkTarget)object).getTarget());
        }
        if (object instanceof EntityTracker) {
            return DebugPackets.getShortDescription(world, ((EntityTracker)object).getEntity());
        }
        if (object instanceof GlobalPos) {
            return DebugPackets.getShortDescription(world, ((GlobalPos)object).pos());
        }
        if (object instanceof BlockPosTracker) {
            return DebugPackets.getShortDescription(world, ((BlockPosTracker)object).currentBlockPosition());
        }
        if (object instanceof DamageSource) {
            Entity entity2 = ((DamageSource)object).getEntity();
            return entity2 == null ? object.toString() : DebugPackets.getShortDescription(world, entity2);
        }
        if (object instanceof Collection) {
            ArrayList list = Lists.newArrayList();
            for (Object object2 : (Iterable)object) {
                list.add(DebugPackets.getShortDescription(world, object2));
            }
            return ((Object)list).toString();
        }
        return object.toString();
    }

    private static void sendPacketToAllPlayers(ServerLevel world, CustomPacketPayload payload) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
        for (ServerPlayer serverPlayer : world.players()) {
            serverPlayer.connection.send(packet);
        }
    }

    private static /* synthetic */ void lambda$sendGameEventInfo$7(ServerLevel serverLevel, Vec3 vec3, ResourceKey resourceKey) {
        DebugPackets.sendPacketToAllPlayers(serverLevel, new GameEventDebugPayload(resourceKey, vec3));
    }

    private static /* synthetic */ void lambda$sendEntityBrain$6(List list, UUID uUID, Object2IntMap object2IntMap) {
        String string = DebugEntityNameGenerator.getEntityName(uUID);
        object2IntMap.forEach((gossipType, integer) -> list.add(string + ": " + String.valueOf(gossipType) + ": " + integer));
    }

    private static /* synthetic */ String lambda$sendEntityBrain$4(String string) {
        return StringUtil.truncateStringIfNecessary(string, 255, true);
    }

    private static /* synthetic */ void lambda$sendGoalSelector$3(List list, WrappedGoal goal) {
        list.add(new GoalDebugPayload.DebugGoal(goal.getPriority(), goal.isRunning(), goal.getGoal().getClass().getSimpleName()));
    }

    private static /* synthetic */ String lambda$sendPoiAddedPacket$2(ResourceKey resourceKey) {
        return resourceKey.location().toString();
    }

    private static /* synthetic */ void lambda$sendPoiPacketsForChunk$1(ServerLevel world, PoiRecord poi) {
        DebugPackets.sendPoiAddedPacket(world, poi.getPos());
    }

    private static /* synthetic */ boolean lambda$sendPoiPacketsForChunk$0(Holder holder) {
        return true;
    }
}

