/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ServerPlaceRecipe<R extends Recipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final Inventory inventory;
    private final CraftingMenuAccess<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends Recipe<I>> RecipeBookMenu.PostPlaceAction placeRecipe(CraftingMenuAccess<R> handler, int width, int height, List<Slot> inputSlots, List<Slot> slotsToReturn, Inventory inventory, RecipeHolder<R> recipe, boolean craftAll, boolean creative) {
        ServerPlaceRecipe<R> serverPlaceRecipe = new ServerPlaceRecipe<R>(handler, inventory, craftAll, width, height, inputSlots, slotsToReturn);
        if (!creative && !serverPlaceRecipe.testClearGrid()) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents stackedItemContents = new StackedItemContents();
        stackedItemContents.initializeExtras((Recipe<?>)recipe.value(), null);
        inventory.fillStackedContents(stackedItemContents);
        handler.fillCraftSlotsStackedContents(stackedItemContents);
        return serverPlaceRecipe.tryPlaceRecipe(recipe, stackedItemContents);
    }

    private ServerPlaceRecipe(CraftingMenuAccess<R> handler, Inventory inventory, boolean craftAll, int width, int height, List<Slot> inputSlots, List<Slot> slotsToReturn) {
        this.menu = handler;
        this.inventory = inventory;
        this.useMaxItems = craftAll;
        this.gridWidth = width;
        this.gridHeight = height;
        this.inputGridSlots = inputSlots;
        this.slotsToClear = slotsToReturn;
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(RecipeHolder<R> recipe, StackedItemContents finder) {
        if (finder.canCraft((Recipe<?>)recipe.value(), null)) {
            this.placeRecipe(recipe, finder);
            this.inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot slot : this.slotsToClear) {
            ItemStack itemStack = slot.getItem().copy();
            this.inventory.placeItemBackInInventory(itemStack, false);
            slot.set(itemStack);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> recipe, StackedItemContents finder) {
        boolean bl = this.menu.recipeMatches(recipe);
        int i = finder.getBiggestCraftableStack((Recipe<?>)recipe.value(), null);
        if (bl) {
            for (Slot slot : this.inputGridSlots) {
                ItemStack itemStack = slot.getItem();
                if (itemStack.isEmpty() || Math.min(i, itemStack.getMaxStackSize()) >= itemStack.getCount() + 1) continue;
                return;
            }
        }
        int j = this.calculateAmountToCraft(i, bl);
        ArrayList list = new ArrayList();
        if (finder.canCraft((Recipe<?>)recipe.value(), j, list::add)) {
            OptionalInt optionalInt = list.stream().mapToInt(ItemOrExact::getMaxStackSize).min();
            if (optionalInt.isPresent()) {
                j = Math.min(j, optionalInt.getAsInt());
            }
            list.clear();
            if (finder.canCraft((Recipe<?>)recipe.value(), j, list::add)) {
                this.clearGrid();
                int k = j;
                PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, recipe.value(), recipe.value().placementInfo().slotInfo(), (slotx, index, x, y) -> {
                    if (!slotx.isEmpty()) {
                        Slot slot2 = this.inputGridSlots.get(index);
                        int jx = ((PlacementInfo.SlotInfo)slotx.get()).placerOutputPosition();
                        int kx = k;
                        while (kx > 0) {
                            ItemOrExact holder = (ItemOrExact)list.get(jx);
                            kx = this.moveItemToGrid(slot2, holder, kx);
                            if (kx != -1) continue;
                            return;
                        }
                    }
                });
            }
        }
    }

    private int calculateAmountToCraft(int forCraftAll, boolean match) {
        if (this.useMaxItems) {
            return forCraftAll;
        }
        if (match) {
            int i = Integer.MAX_VALUE;
            for (Slot slot : this.inputGridSlots) {
                ItemStack itemStack = slot.getItem();
                if (itemStack.isEmpty() || i <= itemStack.getCount()) continue;
                i = itemStack.getCount();
            }
            if (i != Integer.MAX_VALUE) {
                ++i;
            }
            return i;
        }
        return 1;
    }

    private int moveItemToGrid(Slot slot, ItemOrExact item, int count) {
        int j;
        int i = this.inventory.findSlotMatchingCraftingIngredient(item);
        if (i == -1) {
            return -1;
        }
        ItemStack itemStack = this.inventory.getItem(i);
        if (count < itemStack.getCount()) {
            this.inventory.removeItem(i, count);
            j = count;
        } else {
            this.inventory.removeItemNoUpdate(i);
            j = itemStack.getCount();
        }
        if (slot.getItem().isEmpty()) {
            slot.set(itemStack.copyWithCount(j));
        } else {
            slot.getItem().grow(j);
        }
        return count - j;
    }

    private boolean testClearGrid() {
        ArrayList list = Lists.newArrayList();
        int i = this.getAmountOfFreeSlotsInInventory();
        for (Slot slot : this.inputGridSlots) {
            ItemStack itemStack = slot.getItem().copy();
            if (itemStack.isEmpty()) continue;
            int j = this.inventory.getSlotWithRemainingSpace(itemStack);
            if (j == -1 && list.size() <= i) {
                for (ItemStack itemStack2 : list) {
                    if (!ItemStack.isSameItem(itemStack2, itemStack) || itemStack2.getCount() == itemStack2.getMaxStackSize() || itemStack2.getCount() + itemStack.getCount() > itemStack2.getMaxStackSize()) continue;
                    itemStack2.grow(itemStack.getCount());
                    itemStack.setCount(0);
                    break;
                }
                if (itemStack.isEmpty()) continue;
                if (list.size() >= i) {
                    return false;
                }
                list.add(itemStack);
                continue;
            }
            if (j != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int i = 0;
        for (ItemStack itemStack : this.inventory.items) {
            if (!itemStack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    public static interface CraftingMenuAccess<T extends Recipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

