/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ChainedJsonException
extends IOException {
    private final List<Entry> entries = Lists.newArrayList();
    private final String message;

    public ChainedJsonException(String message) {
        this.entries.add(new Entry());
        this.message = message;
    }

    public ChainedJsonException(String message, Throwable cause) {
        super(cause);
        this.entries.add(new Entry());
        this.message = message;
    }

    public void prependJsonKey(String key) {
        this.entries.get(0).addJsonKey(key);
    }

    public void setFilenameAndFlush(String fileName) {
        this.entries.get((int)0).filename = fileName;
        this.entries.add(0, new Entry());
    }

    @Override
    @Override
    public String getMessage() {
        return "Invalid " + String.valueOf(this.entries.get(this.entries.size() - 1)) + ": " + this.message;
    }

    public static ChainedJsonException forException(Exception cause) {
        if (cause instanceof ChainedJsonException) {
            return (ChainedJsonException)cause;
        }
        String string = cause.getMessage();
        if (cause instanceof FileNotFoundException) {
            string = "File not found";
        }
        return new ChainedJsonException(string, cause);
    }

    public static class Entry {
        @Nullable
        String filename;
        private final List<String> jsonKeys = Lists.newArrayList();

        Entry() {
        }

        void addJsonKey(String key) {
            this.jsonKeys.add(0, key);
        }

        @Nullable
        public String getFilename() {
            return this.filename;
        }

        public String getJsonKeys() {
            return StringUtils.join(this.jsonKeys, (String)"->");
        }

        @Override
        public String toString() {
            if (this.filename != null) {
                if (this.jsonKeys.isEmpty()) {
                    return this.filename;
                }
                return this.filename + " " + this.getJsonKeys();
            }
            if (this.jsonKeys.isEmpty()) {
                return "(Unknown file)";
            }
            return "(Unknown file) " + this.getJsonKeys();
        }
    }
}

