/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import dev.omega24.upnp4j.UPnP4J;
import dev.omega24.upnp4j.util.Protocol;
import gg.pufferfish.pufferfish.PufferfishConfig;
import gg.pufferfish.pufferfish.util.AsyncExecutor;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.FileUtil;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.DemoMode;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.network.ServerConnectionListener;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.help.SimpleHelpMap;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.configuration.transformation.VoidDamageHeightMigration;
import org.purpurmc.purpur.event.entity.RidableMoveEvent;
import org.purpurmc.purpur.task.BeehiveTask;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
ChunkIOErrorReporter,
CommandSource,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger LOGGER;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String VANILLA_BRAND = "vanilla";
    private static final float AVERAGE_TICK_TIME_SMOOTHING = 0.8f;
    private static final int TICK_STATS_SPAN = 100;
    private static final long OVERLOADED_THRESHOLD_NANOS;
    private static final int OVERLOADED_TICKS_THRESHOLD = 20;
    private static final long OVERLOADED_WARNING_INTERVAL_NANOS;
    private static final int OVERLOADED_TICKS_WARNING_INTERVAL = 100;
    private static final long STATUS_EXPIRE_TIME_NANOS;
    private static final long PREPARE_LEVELS_DEFAULT_DELAY_NANOS;
    private static final int MAX_STATUS_PLAYER_SAMPLE = 12;
    private static final int SPAWN_POSITION_SEARCH_RADIUS = 5;
    private static final int AUTOSAVE_INTERVAL = 6000;
    private static final int MIMINUM_AUTOSAVE_TICKS = 100;
    private static final int MAX_TICK_LATENCY = 3;
    public static final int ABSOLUTE_MAX_WORLD_SIZE = 29999984;
    public static final LevelSettings DEMO_SETTINGS;
    public static final GameProfile ANONYMOUS_PLAYER_PROFILE;
    public LevelStorageSource.LevelStorageAccess storageSource;
    public final PlayerDataStorage playerDataStorage;
    private final List<Runnable> tickables = Lists.newArrayList();
    private MetricsRecorder metricsRecorder;
    private Consumer<ProfileResults> onMetricsRecordingStopped;
    private Consumer<Path> onMetricsRecordingFinished;
    private boolean willStartRecordingMetrics;
    @Nullable
    private TimeProfiler debugCommandProfiler;
    private boolean debugCommandProfilerDelayStart;
    private ServerConnectionListener connection;
    public final ChunkProgressListenerFactory progressListenerFactory;
    @Nullable
    private ServerStatus status;
    @Nullable
    private ServerStatus.Favicon statusIcon;
    private final RandomSource random;
    public final DataFixer fixerUpper;
    private String localIp;
    private int port;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private Map<ResourceKey<net.minecraft.world.level.Level>, ServerLevel> levels;
    private PlayerList playerList;
    private volatile boolean running;
    private volatile boolean isRestarting = false;
    private boolean stopped;
    private int tickCount;
    private int ticksUntilAutosave;
    protected final Proxy proxy;
    private boolean onlineMode;
    private boolean preventProxyConnections;
    private boolean pvp;
    private boolean allowFlight;
    private Component motd;
    private int playerIdleTimeout;
    private final long[] tickTimesNanos;
    private long aggregatedTickTimesNanos;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair keyPair;
    @Nullable
    private GameProfile singleplayerProfile;
    private boolean isDemo;
    private volatile boolean isReady;
    private long lastOverloadWarningNanos;
    protected final Services services;
    private long lastServerStatus;
    public final Thread serverThread;
    private long lastTickNanos;
    private long taskExecutionStartNanos;
    private long idleTimeNanos;
    private long nextTickTimeNanos;
    private boolean waitingForNextTick;
    private long delayedTasksMaxNextTickTimeNanos;
    private boolean mayHaveDelayedTasks;
    private final PackRepository packRepository;
    private final ServerScoreboard scoreboard;
    @Nullable
    private CommandStorage commandStorage;
    private final CustomBossEvents customBossEvents;
    private final ServerFunctionManager functionManager;
    private boolean enforceWhitelist;
    private float smoothedTickTimeMillis;
    public final Executor executor;
    @Nullable
    private String serverId;
    public ReloadableResources resources;
    private final StructureTemplateManager structureTemplateManager;
    private final ServerTickRateManager tickRateManager;
    protected WorldData worldData;
    public PotionBrewing potionBrewing;
    private FuelValues fuelValues;
    private int emptyTicks;
    private volatile boolean isSaving;
    private static final AtomicReference<RuntimeException> fatalException;
    private final SuppressedExceptionCollector suppressedExceptions;
    private final DiscontinuousFrame tickFrame;
    public final WorldLoader.DataLoadContext worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public static final long startTimeMillis;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    @Deprecated(forRemoval=true)
    public final double[] recentTps = new double[4];
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    public boolean lagging = false;
    protected boolean upnp = false;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    public static final long SERVER_INIT;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    public AsyncExecutor mobSpawnExecutor = new AsyncExecutor("MobSpawning");
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    public volatile boolean hasFullyShutdown = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps5s = new RollingAverage(5);
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(LOGGER)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    public static <S extends MinecraftServer> S spin(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicreference.get()).runServer(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> LOGGER.error("Uncaught exception in server thread", throwable));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (ServerLevel world : this.getAllLevels()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.getChunkSource().pollTask()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    public MinecraftServer(OptionSet options, WorldLoader.DataLoadContext worldLoader, Thread thread, LevelStorageSource.LevelStorageAccess convertable_conversionsession, PackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, ChunkProgressListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
        this.onMetricsRecordingStopped = methodprofilerresults -> this.stopRecordingMetrics();
        this.onMetricsRecordingFinished = path -> {};
        this.random = RandomSource.create();
        this.port = -1;
        this.levels = Maps.newLinkedHashMap();
        this.running = true;
        this.ticksUntilAutosave = 6000;
        this.tickTimesNanos = new long[100];
        this.aggregatedTickTimesNanos = 0L;
        this.lastTickNanos = Util.getNanos();
        this.taskExecutionStartNanos = Util.getNanos();
        this.nextTickTimeNanos = Util.getNanos();
        this.waitingForNextTick = false;
        this.scoreboard = new ServerScoreboard(this);
        this.customBossEvents = new CustomBossEvents();
        this.suppressedExceptions = new SuppressedExceptionCollector();
        this.registries = worldstem.registries();
        this.worldData = worldstem.worldData();
        this.proxy = proxy;
        this.packRepository = resourcepackrepository;
        this.resources = new ReloadableResources(worldstem.resourceManager(), worldstem.dataPackResources());
        this.services = services;
        if (services.profileCache() != null) {
            services.profileCache().setExecutor(this);
        }
        this.tickRateManager = new ServerTickRateManager(this);
        this.progressListenerFactory = worldloadlistenerfactory;
        this.storageSource = convertable_conversionsession;
        this.playerDataStorage = convertable_conversionsession.createPlayerStorage();
        this.fixerUpper = datafixer;
        this.functionManager = new ServerFunctionManager(this, this.resources.managers.getFunctionLibrary());
        HolderLookup.RegistryLookup holdergetter = this.registries.compositeAccess().lookupOrThrow(Registries.BLOCK).filterFeatures(this.worldData.enabledFeatures());
        this.structureTemplateManager = new StructureTemplateManager(worldstem.resourceManager(), convertable_conversionsession, datafixer, holdergetter);
        this.serverThread = thread;
        this.executor = Util.backgroundExecutor();
        this.potionBrewing = PotionBrewing.bootstrap(this.worldData.enabledFeatures());
        this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
        this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
        this.tickFrame = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.options = options;
        this.worldLoader = worldLoader;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    private void readScoreboard(DimensionDataStorage persistentStateManager) {
        persistentStateManager.computeIfAbsent(this.getScoreboard().dataFactory(), "scoreboard");
    }

    protected abstract boolean initServer() throws IOException;

    protected void loadLevel(String s) {
        if (!JvmProfiler.INSTANCE.isRunning()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.INSTANCE.onWorldLoadedStarted();
        this.loadWorld0(s);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.INSTANCE.stop();
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void forceDifficulty() {
    }

    private void loadWorld0(String s) {
        LevelStorageSource.LevelStorageAccess worldSession = this.storageSource;
        RegistryAccess.Frozen iregistrycustom_dimension = this.registries.compositeAccess();
        HolderLookup.RegistryLookup dimensions = iregistrycustom_dimension.lookupOrThrow(Registries.LEVEL_STEM);
        Iterator<ServerLevel> iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            ServerLevel world;
            PrimaryLevelData worlddata;
            Dynamic<?> dynamic;
            String name;
            LevelStem worldDimension = (LevelStem)iterator.next();
            ResourceKey<LevelStem> dimensionKey = dimensions.getResourceKey(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == LevelStem.NETHER) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == LevelStem.END) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != LevelStem.OVERWORLD) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.location().getNamespace() + "_" + dimensionKey.location().getPath() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == LevelStem.OVERWORLD ? s : s + "_" + worldType;
            if (dimension != 0) {
                File newWorld = LevelStorageSource.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = LevelStorageSource.getStorageFolder(new File(s).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    LOGGER.info("---- Migration of old " + worldType + " folder required ----");
                    LOGGER.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    LOGGER.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    LOGGER.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        LOGGER.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            LOGGER.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                LOGGER.warn("Unable to migrate world data.");
                            }
                            LOGGER.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            LOGGER.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        LOGGER.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = LevelStorageSource.createDefault(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.hasWorldData()) {
                LevelSummary worldinfo;
                try {
                    dynamic = worldSession.getDataTag();
                    worldinfo = worldSession.getSummary(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    LevelStorageSource.LevelDirectory convertable_b = worldSession.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)convertable_b.dataFile(), (Object)ioexception);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.getDataTagFallback();
                        worldinfo = worldSession.getSummary(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        LOGGER.error("Failed to load world data from {}", (Object)convertable_b.oldDataFile(), (Object)ioexception1);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.dataFile(), (Object)convertable_b.oldDataFile());
                        return;
                    }
                    worldSession.restoreLevelDataFromOld();
                }
                if (worldinfo.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.DataLoadContext worldloader_a = this.worldLoader;
            HolderLookup.RegistryLookup iregistry = worldloader_a.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.getLevelDataAndDimensions(dynamic, worldloader_a.dataConfiguration(), (Registry<LevelStem>)iregistry, worldloader_a.datapackWorldgen());
                worlddata = (PrimaryLevelData)leveldataanddimensions.worldData();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                LevelSettings worldsettings;
                if (this.isDemo()) {
                    worldsettings = DEMO_SETTINGS;
                    worldoptions = WorldOptions.DEMO_OPTIONS;
                    worlddimensions = WorldPresets.createNormalWorldDimensions(worldloader_a.datapackWorldgen());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).getProperties();
                    worldsettings = new LevelSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gamemode, dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty, false, new GameRules(worldloader_a.dataConfiguration().enabledFeatures()), worldloader_a.dataConfiguration());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.worldOptions.withBonusChest(true) : dedicatedserverproperties.worldOptions;
                    worlddimensions = dedicatedserverproperties.createDimensions(worldloader_a.datapackWorldgen());
                }
                WorldDimensions.Complete worlddimensions_b = worlddimensions.bake((Registry<LevelStem>)iregistry);
                Lifecycle lifecycle = worlddimensions_b.lifecycle().add(worldloader_a.datapackWorldgen().allRegistriesLifecycle());
                worlddata = new PrimaryLevelData(worldsettings, worldoptions, worlddimensions_b.specialWorldProperty(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.forceUpgrade(worldSession, DataFixers.getDataFixer(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            PrimaryLevelData iworlddataserver = worlddata;
            boolean flag = worlddata.isDebugWorld();
            WorldOptions worldoptions = worlddata.worldGenOptions();
            long i = worldoptions.seed();
            long j = BiomeManager.obfuscateSeed(i);
            ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(iworlddataserver));
            LevelStem worlddimension = (LevelStem)dimensions.getValue(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.type().value(), worlddimension.generator(), this.registryAccess());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            ResourceKey<net.minecraft.world.level.Level> worldKey = ResourceKey.create(Registries.DIMENSION, dimensionKey.location());
            if (dimensionKey == LevelStem.OVERWORLD) {
                this.worldData = worlddata;
                this.worldData.setGameType(((DedicatedServer)this).getProperties().gamemode);
                worldloadlistener = this.progressListenerFactory.create(this.worldData.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS));
                world = new ServerLevel(this, this.executor, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j, (List<CustomSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                DimensionDataStorage worldpersistentdata = world.getDataStorage();
                this.readScoreboard(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.getScoreboard());
                this.commandStorage = new CommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.progressListenerFactory.create(this.worldData.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS));
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE).getResourceKey(worlddimension.type().value()).orElseThrow() == BuiltinDimensionTypes.OVERWORLD ? list : Collections.emptyList();
                world = new ServerLevel(this, this.executor, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j, (List<CustomSpawner>)spawners, true, this.overworld().getRandomSequences(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.setModdedInfo(this.getServerModName(), this.getModdedStatus().shouldReportAsModified());
            this.addLevel(world);
            this.initWorld(world, worlddata, this.worldData, worldoptions);
            this.getPlayerList().addWorldborderListener(world);
            if (worlddata.getCustomBossEvents() == null) continue;
            this.getCustomBossEvents().load(worlddata.getCustomBossEvents(), this.registryAccess());
        }
        this.forceDifficulty();
        for (ServerLevel worldserver : this.getAllLevels()) {
            this.prepareLevels(worldserver.getChunkSource().chunkMap.progressListener, worldserver);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ServerScoreboard scoreboard = this.getScoreboard();
        Collection toRemove = scoreboard.getPlayerTeams().stream().filter(team -> team.getName().startsWith("collideRule_")).map(PlayerTeam::getName).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.removePlayerTeam(scoreboard.getPlayerTeam(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.getPlayerList().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            PlayerTeam collideTeam = scoreboard.addPlayerTeam(this.getPlayerList().collideRuleTeamName);
            collideTeam.setSeeFriendlyInvisibles(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.connection.acceptConnections();
    }

    public void initWorld(ServerLevel worldserver, ServerLevelData iworlddataserver, WorldData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.isDebugWorld();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.getWorldBorder();
        worldborder.applySettings(iworlddataserver.getWorldBorder());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.isInitialized()) {
            try {
                MinecraftServer.setInitialSpawn(worldserver, iworlddataserver, worldoptions.generateBonusChest(), flag);
                iworlddataserver.setInitialized(true);
                if (flag) {
                    this.setupDebugLevel(this.worldData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception initializing level");
                try {
                    worldserver.fillReportDetails(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.setInitialized(true);
        }
    }

    private static void setInitialSpawn(ServerLevel world, ServerLevelData worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.setSpawn(BlockPos.ZERO.above(80), 0.0f);
        } else {
            ServerChunkCache chunkproviderserver = world.getChunkSource();
            if (world.generator != null) {
                Random rand = new Random(world.getSeed());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.getLevelName() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.setSpawn(new BlockPos(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            ChunkPos chunkcoordintpair = new ChunkPos(chunkproviderserver.randomState().sampler().findSpawnPosition());
            int i = chunkproviderserver.getGenerator().getSpawnHeight(world);
            if (i < world.getMinY()) {
                BlockPos blockposition = chunkcoordintpair.getWorldPosition();
                i = world.getHeight(Heightmap.Types.WORLD_SURFACE, blockposition.getX() + 8, blockposition.getZ() + 8);
            }
            worldProperties.setSpawn(chunkcoordintpair.getWorldPosition().offset(8, i, 8), 0.0f);
            int j = 0;
            int k = 0;
            int l = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < Mth.square(11); ++j1) {
                BlockPos blockposition1;
                if (j >= -5 && j <= 5 && k >= -5 && k <= 5 && (blockposition1 = PlayerRespawnLogic.getSpawnPosInChunk(world, new ChunkPos(chunkcoordintpair.x + j, chunkcoordintpair.z + k))) != null) {
                    worldProperties.setSpawn(blockposition1, 0.0f);
                    break;
                }
                if (j == k || j < 0 && j == -k || j > 0 && j == 1 - k) {
                    int k1 = l;
                    l = -i1;
                    i1 = k1;
                }
                j += l;
                k += i1;
            }
            if (bonusChest) {
                world.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.get(MiscOverworldFeatures.BONUS_CHEST)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(world, chunkproviderserver.getGenerator(), world.random, worldProperties.getSpawnPos()));
            }
        }
    }

    private void setupDebugLevel(WorldData properties) {
        properties.setDifficulty(Difficulty.PEACEFUL);
        properties.setDifficultyLocked(true);
        ServerLevelData iworlddataserver = properties.overworldData();
        iworlddataserver.setRaining(false);
        iworlddataserver.setThundering(false);
        iworlddataserver.setClearWeatherTime(1000000000);
        iworlddataserver.setDayTime(6000L);
        iworlddataserver.setGameType(GameType.SPECTATOR);
    }

    public void prepareLevels(ChunkProgressListener worldloadlistener, ServerLevel worldserver) {
        int j;
        this.forceTicks = true;
        LOGGER.info("Preparing start region for dimension {}", (Object)worldserver.dimension().location());
        BlockPos blockposition = worldserver.getSharedSpawnPos();
        worldloadlistener.updateSpawnPos(new ChunkPos(blockposition));
        ServerChunkCache chunkproviderserver = worldserver.getChunkSource();
        this.nextTickTimeNanos = Util.getNanos();
        worldserver.setDefaultSpawnPos(blockposition, worldserver.getSharedSpawnAngle());
        int i = worldserver.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS);
        int n = j = i > 0 ? Mth.square(ChunkProgressListener.calculateDiameter(i)) : 0;
        while (chunkproviderserver.getTickingGenerated() < j) {
            this.executeModerately();
        }
        this.executeModerately();
        ServerLevel worldserver1 = worldserver;
        ForcedChunksSavedData forcedchunk = worldserver1.getDataStorage().get(ForcedChunksSavedData.factory(), "chunks");
        if (forcedchunk != null) {
            LongIterator longiterator = forcedchunk.getChunks().iterator();
            while (longiterator.hasNext()) {
                long k = longiterator.nextLong();
                ChunkPos chunkcoordintpair = new ChunkPos(k);
                worldserver1.getChunkSource().updateChunkForced(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        worldloadlistener.stop();
        worldserver.setSpawnSettings(worldserver.serverLevelData.getDifficulty() != Difficulty.PEACEFUL && ((DedicatedServer)this).settings.getProperties().spawnMonsters);
        this.forceTicks = false;
    }

    public GameType getDefaultGameType() {
        return this.worldData.getGameType();
    }

    public boolean isHardcore() {
        return this.worldData.isHardcore();
    }

    public abstract int getOperatorUserPermissionLevel();

    public abstract int getFunctionCompilationLevel();

    public abstract boolean shouldRconBroadcast();

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag3 = false;
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (!suppressLogs) {
                LOGGER.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.dimension().location());
            }
            worldserver.save(null, flush, worldserver.noSave && !force, close);
            flag3 = true;
        }
        if (flush) {
            for (ServerLevel worldserver2 : this.getAllLevels()) {
                LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver2.getChunkSource().chunkMap.getStorageName());
            }
            LOGGER.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEverything(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.isSaving = true;
            this.getPlayerList().saveAll();
            flag3 = this.saveAllChunks(suppressLogs, flush, force);
        }
        finally {
            this.isSaving = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (this.metricsRecorder.isRecording()) {
            this.cancelRecordingMetrics();
        }
        LOGGER.info("Stopping server");
        Commands.COMMAND_SENDING_POOL.shutdownNow();
        if (this.upnp) {
            if (UPnP4J.close((int)this.getPort(), (Protocol)Protocol.TCP)) {
                LOGGER.info("[UPnP] Port {} closed", (Object)this.getPort());
            } else {
                LOGGER.error("[UPnP] Failed to close port {}", (Object)this.getPort());
            }
        }
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.getConnection().stop();
        this.isSaving = true;
        if (this.playerList != null) {
            LOGGER.info("Saving players");
            this.playerList.saveAll();
            this.playerList.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.info("Saving worlds");
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.noSave = false;
        }
        this.saveAllChunks(false, true, true, true);
        this.isSaving = false;
        this.resources.close();
        try {
            this.storageSource.close();
        }
        catch (IOException ioexception1) {
            LOGGER.error("Failed to unlock level {}", (Object)this.storageSource.getLevelId(), (Object)ioexception1);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            LOGGER.info("Saving usercache.json");
            this.getProfileCache().save(false);
        }
        LOGGER.info("Waiting for I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        LOGGER.info("All I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        Util.shutdownExecutors();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.onServerExit();
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String serverIp) {
        this.localIp = serverIp;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void halt(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        BossBarTask.stopAll();
        BeehiveTask.instance().unregister();
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.running = false;
        if (waitForShutdown) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedexception) {
                LOGGER.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runServer() {
        try {
            long serverStartTime = Util.getNanos();
            if (!this.initServer()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.nextTickTimeNanos = Util.getNanos();
            this.statusIcon = this.loadStatusIcon().orElse(null);
            this.status = this.buildServerStatus();
            LOGGER.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - org.bukkit.craftbukkit.Main.BOOT_TIME.toEpochMilli();
            LOGGER.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            this.server.spark.enableBeforePlugins();
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = Util.getNanos();
            if (GlobalConfiguration.isFirstStart) {
                LOGGER.info("*************************************************************************************");
                LOGGER.info("This is the first time you're starting this server.");
                LOGGER.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                LOGGER.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                LOGGER.info("*************************************************************************************");
            }
            if (VoidDamageHeightMigration.HAS_BEEN_REGISTERED) {
                try {
                    PurpurConfig.config.save((File)this.options.valueOf("purpur-settings"));
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Could not save " + String.valueOf(this.options.valueOf("purpur-settings")), ex);
                }
            }
            if (!Boolean.getBoolean("Purpur.IReallyDontWantStartupCommands") && !PurpurConfig.startupCommands.isEmpty()) {
                LOGGER.info("Purpur: Running startup commands specified in purpur.yml.");
                for (String startupCommand : PurpurConfig.startupCommands) {
                    LOGGER.info("Purpur: Running the following command: \"{}\"", (Object)startupCommand);
                    ((DedicatedServer)this).handleConsoleInput(startupCommand, this.createCommandSourceStack());
                }
            }
            while (this.running) {
                boolean flag;
                long i;
                if (!this.isPaused() && this.tickRateManager.isSprinting() && this.tickRateManager.checkShouldSprintThisTick()) {
                    i = 0L;
                    this.lastOverloadWarningNanos = this.nextTickTimeNanos = Util.getNanos();
                } else {
                    i = this.tickRateManager.nanosecondsPerTick();
                    long j = Util.getNanos() - this.nextTickTimeNanos;
                    if (j > OVERLOADED_THRESHOLD_NANOS + 20L * i && this.nextTickTimeNanos - this.lastOverloadWarningNanos >= OVERLOADED_WARNING_INTERVAL_NANOS + 100L * i) {
                        long k = j / i;
                        if (this.server.getWarnOnOverload()) {
                            LOGGER.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j / TimeUtil.NANOSECONDS_PER_MILLISECOND), (Object)k);
                        }
                        this.nextTickTimeNanos += k * i;
                        this.lastOverloadWarningNanos = this.nextTickTimeNanos;
                    }
                }
                long currentTime = Util.getNanos();
                if (++currentTick % 20 == 0) {
                    long diff = currentTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps5s.add(currentTps, diff);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps5s.getAverage();
                    this.recentTps[1] = this.tps1.getAverage();
                    this.recentTps[2] = this.tps5.getAverage();
                    this.recentTps[3] = this.tps15.getAverage();
                    this.lagging = this.recentTps[0] < PurpurConfig.laggingThreshold;
                    tickSection = currentTime;
                }
                boolean bl = flag = i == 0L;
                if (this.debugCommandProfilerDelayStart) {
                    this.debugCommandProfilerDelayStart = false;
                    this.debugCommandProfiler = new TimeProfiler(Util.getNanos(), this.tickCount);
                }
                this.lastTick = currentTime;
                this.nextTickTimeNanos += i;
                try (Profiler.Scope profiler_a = Profiler.use(this.createProfiler());){
                    ProfilerFiller gameprofilerfiller = Profiler.get();
                    gameprofilerfiller.push("tick");
                    this.tickFrame.start();
                    this.tickServer(flag ? () -> false : this::haveTime);
                    Throwable crash = this.chunkSystemCrash;
                    if (crash != null) {
                        this.chunkSystemCrash = null;
                        throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                    }
                    this.tickFrame.end();
                    gameprofilerfiller.popPush("nextTickWait");
                    this.mayHaveDelayedTasks = true;
                    this.delayedTasksMaxNextTickTimeNanos = Math.max(Util.getNanos() + i, this.nextTickTimeNanos);
                    if (!PufferfishConfig.tpsCatchup || !PufferfishConfig.tpsCatchup) {
                        this.delayedTasksMaxNextTickTimeNanos = this.nextTickTimeNanos = currentTime + i;
                    }
                    this.startMeasuringTaskExecutionTime();
                    this.waitUntilNextTick();
                    this.finishMeasuringTaskExecutionTime();
                    if (flag) {
                        this.tickRateManager.endTickWork();
                    }
                    gameprofilerfiller.pop();
                    this.logFullTickTime();
                }
                finally {
                    this.endMetricsRecordingTick();
                }
                this.isReady = true;
                JvmProfiler.INSTANCE.onServerTick(this.smoothedTickTimeMillis);
            }
            return;
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof ThreadDeath) {
                LOGGER.error("Main thread terminated by WatchDog due to hard crash", throwable2);
                return;
            }
            LOGGER.error("Encountered an unexpected exception", throwable2);
            CrashReport crashreport = MinecraftServer.constructOrExtractCrashReport(throwable2);
            this.fillSystemReport(crashreport.getSystemReport());
            Path path = this.getServerDirectory().resolve("crash-reports").resolve("crash-" + Util.getFilenameFormattedDateTime() + "-server.txt");
            if (crashreport.saveToFile(path, ReportType.CRASH)) {
                LOGGER.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                LOGGER.error("We were unable to save this crash report to disk.");
            }
            this.onServerCrash(crashreport);
            return;
        }
        finally {
            try {
                this.stopped = true;
                this.stopServer();
            }
            catch (Throwable throwable3) {
                LOGGER.error("Exception stopping the server", throwable3);
            }
            finally {
                if (this.services.profileCache() != null) {
                    this.services.profileCache().clearExecutor();
                }
            }
        }
    }

    private void logFullTickTime() {
        long i = Util.getNanos();
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logSample(i - this.lastTickNanos);
        }
        this.lastTickNanos = i;
    }

    private void startMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            this.taskExecutionStartNanos = Util.getNanos();
            this.idleTimeNanos = 0L;
        }
    }

    private void finishMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            SampleLogger samplelogger = this.getTickTimeLogger();
            samplelogger.logPartialSample(Util.getNanos() - this.taskExecutionStartNanos - this.idleTimeNanos, TpsDebugDimensions.SCHEDULED_TASKS.ordinal());
            samplelogger.logPartialSample(this.idleTimeNanos, TpsDebugDimensions.IDLE.ordinal());
        }
    }

    private static CrashReport constructOrExtractCrashReport(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.getReport();
            if (reportedexception != throwable) {
                crashreport.addCategory("Wrapped in").setDetailError("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean haveTime() {
        return this.forceTicks || this.runningTask() || Util.getNanos() < (this.mayHaveDelayedTasks ? this.delayedTasksMaxNextTickTimeNanos : this.nextTickTimeNanos);
    }

    private void executeModerately() {
        this.runAllTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean throwIfFatalException() {
        RuntimeException runtimeexception = fatalException.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void setFatalException(RuntimeException exception) {
        fatalException.compareAndSet(null, exception);
    }

    @Override
    public void managedBlock(BooleanSupplier stopCondition) {
        super.managedBlock(() -> MinecraftServer.throwIfFatalException() && stopCondition.getAsBoolean());
    }

    protected void waitUntilNextTick() {
        this.runAllTasks();
        this.waitingForNextTick = true;
        try {
            this.managedBlock(() -> !this.haveTime());
        }
        finally {
            this.waitingForNextTick = false;
        }
    }

    @Override
    public void waitForTasks() {
        boolean flag = this.isTickTimeLoggingEnabled();
        long i = flag ? Util.getNanos() : 0L;
        long j = this.waitingForNextTick ? this.nextTickTimeNanos - Util.getNanos() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j);
        if (flag) {
            this.idleTimeNanos += Util.getNanos() - i;
        }
    }

    @Override
    public TickTask wrapRunnable(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.tickCount, runnable);
    }

    @Override
    protected boolean shouldRun(TickTask ticktask) {
        return ticktask.getTick() + 3 < this.tickCount || this.haveTime();
    }

    @Override
    public boolean pollTask() {
        boolean flag;
        this.mayHaveDelayedTasks = flag = this.pollTaskInternal();
        return flag;
    }

    private boolean pollTaskInternal() {
        if (super.pollTask()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.tickRateManager.isSprinting() || this.haveTime()) {
            for (ServerLevel worldserver : this.getAllLevels()) {
                if (!worldserver.getChunkSource().pollTask()) continue;
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void doRunTask(TickTask ticktask) {
        Profiler.get().incrementCounter("runTask");
        super.doRunTask(ticktask);
    }

    private Optional<ServerStatus.Favicon> loadStatusIcon() {
        Optional<Path> optional = Optional.of(this.getFile("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.storageSource.getIconFile().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerStatus.Favicon(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> getWorldScreenshotFile() {
        return this.storageSource.getIconFile();
    }

    public Path getServerDirectory() {
        return Path.of("", new String[0]);
    }

    public void onServerCrash(CrashReport report) {
    }

    public void onServerExit() {
    }

    public boolean isPaused() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickServer(BooleanSupplier shouldKeepTicking) {
        WatchdogThread.tick();
        long i = Util.getNanos();
        int j = this.pauseWhileEmptySeconds() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (j > 0) {
            this.emptyTicks = this.playerList.getPlayerCount() == 0 && !this.tickRateManager.isSprinting() && this.pluginsBlockingSleep.isEmpty() ? ++this.emptyTicks : 0;
            if (this.emptyTicks >= j) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.emptyTicks == j) {
                    LOGGER.info("Server empty for {} seconds, pausing", (Object)this.pauseWhileEmptySeconds());
                    this.autoSave();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (ServerLevel level : this.levels.values()) {
                    level.getChunkSource().tick(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.tickConnection();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.lastTick) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.tickCount + 1).callEvent();
        ++this.tickCount;
        this.tickRateManager.tick();
        this.tickChildren(shouldKeepTicking);
        if (i - this.lastServerStatus >= STATUS_EXPIRE_TIME_NANOS) {
            this.lastServerStatus = i;
            this.status = this.buildServerStatus();
        }
        --this.ticksUntilAutosave;
        ProfilerFiller profiler = Profiler.get();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.push("save");
        boolean fullSave = this.autosavePeriod > 0 && this.tickCount % this.autosavePeriod == 0;
        try {
            this.isSaving = true;
            if (playerSaveInterval > 0) {
                this.playerList.saveAll(playerSaveInterval);
            }
            for (ServerLevel level : this.getAllLevels()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.isSaving = false;
        }
        profiler.pop();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        this.runAllTasks();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.tickCount, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.lastTick) / 1000000.0);
        gameprofilerfiller.push("tallying");
        long k = Util.getNanos() - i;
        int l = this.tickCount % 100;
        this.aggregatedTickTimesNanos -= this.tickTimesNanos[l];
        this.aggregatedTickTimesNanos += k;
        this.tickTimesNanos[l] = k;
        this.smoothedTickTimeMillis = this.smoothedTickTimeMillis * 0.8f + (float)k / (float)TimeUtil.NANOSECONDS_PER_MILLISECOND * 0.19999999f;
        this.tickTimes5s.add(this.tickCount, k);
        this.tickTimes10s.add(this.tickCount, k);
        this.tickTimes60s.add(this.tickCount, k);
        this.logTickMethodTime(i);
        gameprofilerfiller.pop();
    }

    private void autoSave() {
        this.ticksUntilAutosave = this.autosavePeriod;
        LOGGER.debug("Autosave started");
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("save");
        this.saveEverything(true, false, false);
        gameprofilerfiller.pop();
        LOGGER.debug("Autosave finished");
    }

    private void logTickMethodTime(long tickStartTime) {
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logPartialSample(Util.getNanos() - tickStartTime, TpsDebugDimensions.TICK_SERVER_METHOD.ordinal());
        }
    }

    private int computeNextAutosaveInterval() {
        float f;
        if (this.tickRateManager.isSprinting()) {
            long i = this.getAverageTickTimeNanos() + 1L;
            f = (float)TimeUtil.NANOSECONDS_PER_SECOND / (float)i;
        } else {
            f = this.tickRateManager.tickrate();
        }
        boolean flag = true;
        return Math.max(100, (int)(f * 300.0f));
    }

    public void onTickRateChanged() {
        int i = this.computeNextAutosaveInterval();
        if (i < this.ticksUntilAutosave) {
            this.ticksUntilAutosave = i;
        }
    }

    protected abstract SampleLogger getTickTimeLogger();

    public abstract boolean isTickTimeLoggingEnabled();

    private ServerStatus buildServerStatus() {
        ServerStatus.Players serverping_serverpingplayersample = this.buildPlayerStatus();
        return new ServerStatus(PaperAdventure.asVanilla(this.motd), Optional.of(serverping_serverpingplayersample), Optional.of(ServerStatus.Version.current()), Optional.ofNullable(this.statusIcon), this.enforceSecureProfile());
    }

    private ServerStatus.Players buildPlayerStatus() {
        List<ServerPlayer> list = this.playerList.getPlayers();
        int i = this.getMaxPlayers();
        if (this.hidesOnlinePlayers()) {
            return new ServerStatus.Players(i, list.size(), List.of());
        }
        int j = Math.min(list.size(), SpigotConfig.playerSample);
        ObjectArrayList objectarraylist = new ObjectArrayList(j);
        int k = Mth.nextInt(this.random, 0, list.size() - j);
        for (int l = 0; l < j; ++l) {
            ServerPlayer entityplayer = list.get(k + l);
            objectarraylist.add((Object)(entityplayer.allowsListing() ? entityplayer.getGameProfile() : ANONYMOUS_PLAYER_PROFILE));
        }
        Util.shuffle(objectarraylist, this.random);
        return new ServerStatus.Players(i, list.size(), (List<GameProfile>)objectarraylist);
    }

    protected void tickChildren(BooleanSupplier shouldKeepTicking) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        this.getPlayerList().getPlayers().forEach(entityplayer -> entityplayer.connection.suspendFlushing());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.getAllLevels().forEach(level -> {
            for (Entity entity : level.getEntities().getAll()) {
                CraftEntity bukkit;
                if (entity.isRemoved() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.tickCount);
        gameprofilerfiller.push("commandFunctions");
        this.getFunctions().tick();
        gameprofilerfiller.popPush("levels");
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (ServerLevel level2 : this.getAllLevels()) {
            boolean doDaylight = level2.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT);
            long dayTime = level2.getDayTime();
            long worldTime = level2.getGameTime();
            ClientboundSetTimePacket worldPacket = new ClientboundSetTimePacket(worldTime, dayTime, doDaylight);
            for (Player player : level2.players()) {
                if (!(player instanceof ServerPlayer) || !level2.isForceTime() && (this.tickCount + player.getId()) % 20 != 0) continue;
                ServerPlayer entityplayer2 = (ServerPlayer)player;
                long playerTime = entityplayer2.getPlayerTime();
                ClientboundSetTimePacket packet = playerTime == dayTime ? worldPacket : new ClientboundSetTimePacket(worldTime, playerTime, doDaylight);
                entityplayer2.connection.send(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (ServerLevel worldserver : this.getAllLevels()) {
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            HopperBlockEntity.skipHopperEvents = worldserver.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            worldserver.updateLagCompensationTick();
            worldserver.hasRidableMoveEvent = RidableMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            gameprofilerfiller.push(() -> {
                String s = String.valueOf(worldserver);
                return s + " " + String.valueOf(worldserver.dimension().location());
            });
            gameprofilerfiller.push("tick");
            try {
                worldserver.tick(shouldKeepTicking);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception ticking world");
                worldserver.fillReportDetails(crashreport);
                throw new ReportedException(crashreport);
            }
            gameprofilerfiller.pop();
            gameprofilerfiller.pop();
            worldserver.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        gameprofilerfiller.popPush("connection");
        this.tickConnection();
        gameprofilerfiller.popPush("players");
        this.playerList.tick();
        if (SharedConstants.IS_RUNNING_IN_IDE && this.tickRateManager.runsNormally()) {
            GameTestTicker.SINGLETON.tick();
        }
        gameprofilerfiller.popPush("server gui refresh");
        for (int i = 0; i < this.tickables.size(); ++i) {
            this.tickables.get(i).run();
        }
        gameprofilerfiller.popPush("send chunks");
        for (ServerPlayer entityplayer3 : this.playerList.getPlayers()) {
            entityplayer3.connection.chunkSender.sendNextChunks(entityplayer3);
            entityplayer3.connection.resumeFlushing();
        }
        gameprofilerfiller.pop();
    }

    public void tickConnection() {
        this.getConnection().tick();
    }

    private void synchronizeTime(ServerLevel world) {
        this.playerList.broadcastAll(new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)), world.dimension());
    }

    public void forceTimeSynchronization() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("timeSync");
        for (ServerLevel worldserver : this.getAllLevels()) {
            this.synchronizeTime(worldserver);
        }
        gameprofilerfiller.pop();
    }

    public boolean isLevelEnabled(net.minecraft.world.level.Level world) {
        return true;
    }

    public void addTickable(Runnable tickable) {
        this.tickables.add(tickable);
    }

    protected void setId(String serverId) {
        this.serverId = serverId;
    }

    public boolean isShutdown() {
        return !this.serverThread.isAlive();
    }

    public Path getFile(String path) {
        return this.getServerDirectory().resolve(path);
    }

    public final ServerLevel overworld() {
        return this.levels.get(net.minecraft.world.level.Level.OVERWORLD);
    }

    @Nullable
    public ServerLevel getLevel(ResourceKey<net.minecraft.world.level.Level> key) {
        return this.levels.get(key);
    }

    public void addLevel(ServerLevel level) {
        Map<ResourceKey<net.minecraft.world.level.Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.dimension(), level);
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(ServerLevel level) {
        Map<ResourceKey<net.minecraft.world.level.Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.dimension());
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.Level>> levelKeys() {
        return this.levels.keySet();
    }

    public Iterable<ServerLevel> getAllLevels() {
        return this.levels.values();
    }

    @Override
    public String getServerVersion() {
        return SharedConstants.getCurrentVersion().getName();
    }

    @Override
    public int getPlayerCount() {
        return this.playerList.getPlayerCount();
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public String[] getPlayerNames() {
        return this.playerList.getPlayerNamesArray();
    }

    @DontObfuscate
    public String getServerModName() {
        return PurpurConfig.serverModName;
    }

    public SystemReport fillSystemReport(SystemReport details) {
        details.setDetail("Server Running", () -> Boolean.toString(this.running));
        if (this.playerList != null) {
            details.setDetail("Player Count", () -> {
                int i = this.playerList.getPlayerCount();
                return i + " / " + this.playerList.getMaxPlayers() + "; " + String.valueOf(this.playerList.getPlayers());
            });
        }
        details.setDetail("Active Data Packs", () -> PackRepository.displayPackList(this.packRepository.getSelectedPacks()));
        details.setDetail("Available Data Packs", () -> PackRepository.displayPackList(this.packRepository.getAvailablePacks()));
        details.setDetail("Enabled Feature Flags", () -> FeatureFlags.REGISTRY.toNames(this.worldData.enabledFeatures()).stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        details.setDetail("World Generation", () -> this.worldData.worldGenSettingsLifecycle().toString());
        details.setDetail("World Seed", () -> String.valueOf(this.worldData.worldGenOptions().seed()));
        SuppressedExceptionCollector suppressedexceptioncollector = this.suppressedExceptions;
        Objects.requireNonNull(this.suppressedExceptions);
        details.setDetail("Suppressed Exceptions", suppressedexceptioncollector::dump);
        if (this.serverId != null) {
            details.setDetail("Server Id", () -> this.serverId);
        }
        return this.fillServerSystemReport(details);
    }

    public abstract SystemReport fillServerSystemReport(SystemReport var1);

    public ModCheck getModdedStatus() {
        return ModCheck.identify(VANILLA_BRAND, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        LOGGER.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int serverPort) {
        this.port = serverPort;
    }

    @Nullable
    public GameProfile getSingleplayerProfile() {
        return this.singleplayerProfile;
    }

    public void setSingleplayerProfile(@Nullable GameProfile hostProfile) {
        this.singleplayerProfile = hostProfile;
    }

    public boolean isSingleplayer() {
        return this.singleplayerProfile != null;
    }

    protected void initializeKeyPair() {
        LOGGER.info("Generating keypair");
        try {
            this.keyPair = Crypt.generateKeyPair();
        }
        catch (CryptException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(ServerLevel level, Difficulty difficulty, boolean forceUpdate) {
        PrimaryLevelData worldData = level.serverLevelData;
        if (forceUpdate || !worldData.isDifficultyLocked()) {
            worldData.setDifficulty(worldData.isHardcore() ? Difficulty.HARD : difficulty);
            level.setSpawnSettings(worldData.getDifficulty() != Difficulty.PEACEFUL && ((DedicatedServer)this).settings.getProperties().spawnMonsters);
        }
    }

    public int getScaledTrackingDistance(int initialDistance) {
        return initialDistance;
    }

    private void updateMobSpawningFlags() {
        for (ServerLevel worldserver : this.getAllLevels()) {
            worldserver.setSpawnSettings(worldserver.serverLevelData.getDifficulty() != Difficulty.PEACEFUL && ((DedicatedServer)this).settings.getProperties().spawnMonsters);
        }
    }

    public void setDifficultyLocked(boolean locked) {
        this.worldData.setDifficultyLocked(locked);
        this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
    }

    private void sendDifficultyUpdate(ServerPlayer player) {
        LevelData worlddata = player.level().getLevelData();
        player.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
    }

    public boolean isSpawningMonsters() {
        return this.worldData.getDifficulty() != Difficulty.PEACEFUL;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean demo) {
        this.isDemo = demo;
    }

    public Optional<ServerResourcePackInfo> getServerResourcePack() {
        return Optional.empty();
    }

    public boolean isResourcePackRequired() {
        return this.getServerResourcePack().filter(ServerResourcePackInfo::isRequired).isPresent();
    }

    public abstract boolean isDedicatedServer();

    public abstract int getRateLimitPacketsPerSecond();

    public boolean usesAuthentication() {
        return this.onlineMode;
    }

    public void setUsesAuthentication(boolean onlineMode) {
        this.onlineMode = onlineMode;
    }

    public boolean getPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public void setPreventProxyConnections(boolean preventProxyConnections) {
        this.preventProxyConnections = preventProxyConnections;
    }

    public abstract boolean isEpollEnabled();

    public boolean isPvpAllowed() {
        return this.pvp;
    }

    public void setPvpAllowed(boolean pvpEnabled) {
        this.pvp = pvpEnabled;
    }

    public boolean isFlightAllowed() {
        return this.allowFlight;
    }

    public void setFlightAllowed(boolean flightEnabled) {
        this.allowFlight = flightEnabled;
    }

    public abstract boolean isCommandBlockEnabled();

    @Override
    public String getMotd() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    public void setMotd(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public void setPlayerList(PlayerList playerManager) {
        this.playerList = playerManager;
    }

    public abstract boolean isPublished();

    public void setDefaultGameType(GameType gameMode) {
        this.worldData.setGameType(gameMode);
    }

    public ServerConnectionListener getConnection() {
        return this.connection == null ? (this.connection = new ServerConnectionListener(this)) : this.connection;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean publishServer(@Nullable GameType gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public int getSpawnProtectionRadius() {
        return 16;
    }

    public boolean isUnderSpawnProtection(ServerLevel world, BlockPos pos, Player player) {
        return false;
    }

    public boolean repliesToStatus() {
        return true;
    }

    public boolean hidesOnlinePlayers() {
        return false;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getPlayerIdleTimeout() {
        return this.playerIdleTimeout;
    }

    public void setPlayerIdleTimeout(int playerIdleTimeout) {
        this.playerIdleTimeout = playerIdleTimeout;
    }

    public MinecraftSessionService getSessionService() {
        return this.services.sessionService();
    }

    @Nullable
    public SignatureValidator getProfileKeySignatureValidator() {
        return this.services.profileKeySignatureValidator();
    }

    public GameProfileRepository getProfileRepository() {
        return this.services.profileRepository();
    }

    @Nullable
    public GameProfileCache getProfileCache() {
        return this.services.profileCache();
    }

    @Nullable
    public ServerStatus getStatus() {
        return this.status;
    }

    public void invalidateStatus() {
        this.lastServerStatus = 0L;
    }

    public int getAbsoluteMaxWorldSize() {
        return 29999984;
    }

    @Override
    public boolean scheduleExecutables() {
        return super.scheduleExecutables() && !this.isStopped();
    }

    @Override
    public void executeIfPossible(Runnable runnable) {
        if (this.isStopped()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.executeIfPossible(runnable);
    }

    @Override
    public Thread getRunningThread() {
        return this.serverThread;
    }

    public int getCompressionThreshold() {
        return 256;
    }

    public boolean enforceSecureProfile() {
        return false;
    }

    public long getNextTickTime() {
        return this.nextTickTimeNanos;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public int getSpawnRadius(@Nullable ServerLevel world) {
        return world != null ? world.getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS) : 10;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.resources.managers.getAdvancements();
    }

    public ServerFunctionManager getFunctions() {
        return this.functionManager;
    }

    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            PackRepository resourcepackrepository = this.packRepository;
            Objects.requireNonNull(this.packRepository);
            return (ImmutableList)stream.map(resourcepackrepository::getPack).filter(Objects::nonNull).map(Pack::open).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            MultiPackResourceManager resourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, (List<PackResources>)immutablelist);
            List<Registry.PendingTags<?>> list = TagLoader.loadTagsForExistingRegistries(resourcemanager, this.registries.compositeAccess(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)ReloadableServerResources.loadResources(resourcemanager, this.registries, list, this.worldData.enabledFeatures(), this.isDedicatedServer() ? Commands.CommandSelection.DEDICATED : Commands.CommandSelection.INTEGRATED, this.getFunctionCompilationLevel(), this.executor, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(resourcemanager, (ReloadableServerResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            PaperBrigadier.moveBukkitCommands(this.resources.managers().getCommands(), minecraftserver_reloadableresources.managers().commands);
            this.resources.close();
            this.resources = minecraftserver_reloadableresources;
            this.packRepository.setSelected(dataPacks);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.getSelectedPacks(this.packRepository, true), this.worldData.enabledFeatures());
            this.worldData.setDataConfiguration(worlddataconfiguration);
            this.resources.managers.updateStaticRegistryTags();
            this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
            this.potionBrewing = this.potionBrewing.reload(this.worldData.enabledFeatures());
            if (Thread.currentThread() != this.serverThread) {
                return;
            }
            for (ServerPlayer player : this.getPlayerList().getPlayers()) {
                player.getAdvancements().save();
            }
            this.getPlayerList().reloadResources();
            this.functionManager.replaceLibrary(this.resources.managers.getFunctionLibrary());
            this.structureTemplateManager.onResourceManagerReload(this.resources.resourceManager);
            this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.isSameThread()) {
            Objects.requireNonNull(completablefuture);
            this.managedBlock(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration configurePackRepository(PackRepository resourcePackManager, WorldDataConfiguration dataConfiguration, boolean initMode, boolean safeMode) {
        DataPackConfig datapackconfiguration = dataConfiguration.dataPacks();
        FeatureFlagSet featureflagset = initMode ? FeatureFlagSet.of() : dataConfiguration.enabledFeatures();
        FeatureFlagSet featureflagset1 = initMode ? FeatureFlags.REGISTRY.allFlags() : dataConfiguration.enabledFeatures();
        resourcePackManager.reload();
        if (safeMode) {
            return MinecraftServer.configureRepositoryWithSelection(resourcePackManager, List.of(VANILLA_BRAND), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s : datapackconfiguration.getEnabled()) {
            if (resourcePackManager.isAvailable(s)) {
                set.add(s);
                continue;
            }
            LOGGER.warn("Missing data pack {}", (Object)s);
        }
        for (Pack resourcepackloader : resourcePackManager.getAvailablePacks()) {
            String s1 = resourcepackloader.getId();
            if (datapackconfiguration.getDisabled().contains(s1)) continue;
            FeatureFlagSet featureflagset2 = resourcepackloader.getRequestedFeatures();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.getPackSource().shouldAddAutomatically()) {
                if (featureflagset2.isSubsetOf(featureflagset1)) {
                    LOGGER.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    LOGGER.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.printMissingFlags(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.isSubsetOf(featureflagset1)) continue;
            LOGGER.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.printMissingFlags(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            LOGGER.info("No datapacks selected, forcing vanilla");
            set.add(VANILLA_BRAND);
        }
        return MinecraftServer.configureRepositoryWithSelection(resourcePackManager, set, featureflagset, true);
    }

    private static WorldDataConfiguration configureRepositoryWithSelection(PackRepository resourcePackManager, Collection<String> enabledProfiles, FeatureFlagSet enabledFeatures, boolean allowEnabling) {
        resourcePackManager.setSelected(enabledProfiles);
        MinecraftServer.enableForcedFeaturePacks(resourcePackManager, enabledFeatures);
        DataPackConfig datapackconfiguration = MinecraftServer.getSelectedPacks(resourcePackManager, allowEnabling);
        FeatureFlagSet featureflagset1 = resourcePackManager.getRequestedFeatureFlags().join(enabledFeatures);
        return new WorldDataConfiguration(datapackconfiguration, featureflagset1);
    }

    private static void enableForcedFeaturePacks(PackRepository resourcePackManager, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet featureflagset1 = resourcePackManager.getRequestedFeatureFlags();
        FeatureFlagSet featureflagset2 = enabledFeatures.subtract(featureflagset1);
        if (!featureflagset2.isEmpty()) {
            ObjectArraySet set = new ObjectArraySet(resourcePackManager.getSelectedIds());
            for (Pack resourcepackloader : resourcePackManager.getAvailablePacks()) {
                if (featureflagset2.isEmpty()) break;
                if (resourcepackloader.getPackSource() != PackSource.FEATURE) continue;
                String s = resourcepackloader.getId();
                FeatureFlagSet featureflagset3 = resourcepackloader.getRequestedFeatures();
                if (featureflagset3.isEmpty() || !featureflagset3.intersects(featureflagset2) || !featureflagset3.isSubsetOf(enabledFeatures)) continue;
                if (!set.add(s)) {
                    throw new IllegalStateException("Tried to force '" + s + "', but it was already enabled");
                }
                LOGGER.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s);
                featureflagset2 = featureflagset2.subtract(featureflagset3);
            }
            resourcePackManager.setSelected((Collection<String>)set);
        }
    }

    private static DataPackConfig getSelectedPacks(PackRepository dataPackManager, boolean allowEnabling) {
        Collection<String> collection = dataPackManager.getSelectedIds();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = allowEnabling ? dataPackManager.getAvailableIds().stream().filter(s -> !collection.contains(s)).toList() : List.of();
        return new DataPackConfig((List<String>)list, list1);
    }

    public void kickUnlistedPlayers(CommandSourceStack source) {
        if (this.isEnforceWhitelist()) {
            PlayerList playerlist = source.getServer().getPlayerList();
            UserWhiteList whitelist = playerlist.getWhiteList();
            if (!((DedicatedServer)MinecraftServer.getServer()).getProperties().whiteList.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.getPlayers());
            for (ServerPlayer entityplayer : list) {
                if (whitelist.isWhiteListed(entityplayer.getGameProfile()) || this.getPlayerList().isOp(entityplayer.getGameProfile())) continue;
                entityplayer.connection.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public PackRepository getPackRepository() {
        return this.packRepository;
    }

    public Commands getCommands() {
        return this.resources.managers.getCommands();
    }

    public CommandSourceStack createCommandSourceStack() {
        ServerLevel worldserver = this.overworld();
        return new CommandSourceStack(this, worldserver == null ? Vec3.ZERO : Vec3.atLowerCornerOf(worldserver.getSharedSpawnPos()), Vec2.ZERO, worldserver, 4, "Server", net.minecraft.network.chat.Component.literal("Server"), this, null);
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public abstract boolean shouldInformAdmins();

    public RecipeManager getRecipeManager() {
        return this.resources.managers.getRecipeManager();
    }

    public ServerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public CommandStorage getCommandStorage() {
        if (this.commandStorage == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.commandStorage;
    }

    public GameRules getGameRules() {
        return this.overworld().getGameRules();
    }

    public CustomBossEvents getCustomBossEvents() {
        return this.customBossEvents;
    }

    public boolean isEnforceWhitelist() {
        return this.enforceWhitelist;
    }

    public void setEnforceWhitelist(boolean enforceWhitelist) {
        this.enforceWhitelist = enforceWhitelist;
    }

    public float getCurrentSmoothedTickTime() {
        return this.smoothedTickTimeMillis;
    }

    public ServerTickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public long getAverageTickTimeNanos() {
        return this.aggregatedTickTimesNanos / (long)Math.min(100, Math.max(this.tickCount, 1));
    }

    public long[] getTickTimesNanos() {
        return this.tickTimesNanos;
    }

    public int getProfilePermissions(GameProfile profile) {
        if (this.getPlayerList().isOp(profile)) {
            ServerOpListEntry oplistentry = (ServerOpListEntry)this.getPlayerList().getOps().get(profile);
            return oplistentry != null ? oplistentry.getLevel() : (this.isSingleplayerOwner(profile) ? 4 : (this.isSingleplayer() ? (this.getPlayerList().isAllowCommandsForAllPlayers() ? 4 : 0) : this.getOperatorUserPermissionLevel()));
        }
        return 0;
    }

    public abstract boolean isSingleplayerOwner(GameProfile var1);

    public void dumpServerProperties(Path file) throws IOException {
    }

    private void saveDebugReport(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.Level>, ServerLevel> entry : this.levels.entrySet()) {
                ResourceLocation minecraftkey = entry.getKey().location();
                Path path2 = path1.resolve(minecraftkey.getNamespace()).resolve(minecraftkey.getPath());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().saveDebugReport(path2);
            }
            this.dumpGameRules(path.resolve("gamerules.txt"));
            this.dumpClasspath(path.resolve("classpath.txt"));
            this.dumpMiscStats(path.resolve("stats.txt"));
            this.dumpThreads(path.resolve("threads.txt"));
            this.dumpServerProperties(path.resolve("server.properties.txt"));
            this.dumpNativeModules(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void dumpMiscStats(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getPendingTasksCount()));
            bufferedwriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.getCurrentSmoothedTickTime())));
            bufferedwriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.tickTimesNanos)));
            bufferedwriter.write(String.format(Locale.ROOT, "queue: %s\n", Util.backgroundExecutor()));
        }
    }

    private void dumpGameRules(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.getGameRules();
            gamerules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

                @Override
                public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.getId(), gamerules.getRule(key)));
                }
            });
            for (String s : list) {
                bufferedwriter.write(s);
            }
        }
    }

    private void dumpClasspath(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s2 : Splitter.on((String)s1).split((CharSequence)s)) {
                bufferedwriter.write(s2);
                bufferedwriter.write("\n");
            }
        }
    }

    private void dumpThreads(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i = athreadinfo.length;
            for (int j = 0; j < i; ++j) {
                ThreadInfo threadinfo = athreadinfo1[j];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void dumpNativeModules(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.listModules());
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.name));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.NativeModuleInfo nativemodulelister_a2 = (NativeModuleLister.NativeModuleInfo)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean isSameThread() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    @Deprecated
    public static RegistryAccess getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private ProfilerFiller createProfiler() {
        if (PufferfishConfig.disableMethodProfiler) {
            return InactiveProfiler.INSTANCE;
        }
        if (this.willStartRecordingMetrics) {
            this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ServerMetricsSamplersProvider(Util.timeSource, this.isDedicatedServer()), Util.timeSource, Util.ioPool(), new MetricsPersister("server"), this.onMetricsRecordingStopped, path -> {
                this.executeBlocking(() -> this.saveDebugReport(path.resolve("server")));
                this.onMetricsRecordingFinished.accept((Path)path);
            });
            this.willStartRecordingMetrics = false;
        }
        this.metricsRecorder.startTick();
        return SingleTickProfiler.decorateFiller(this.metricsRecorder.getProfiler(), SingleTickProfiler.createTickProfiler("Server"));
    }

    public void endMetricsRecordingTick() {
        this.metricsRecorder.endTick();
    }

    public boolean isRecordingMetrics() {
        return this.metricsRecorder.isRecording();
    }

    public void startRecordingMetrics(Consumer<ProfileResults> resultConsumer, Consumer<Path> dumpConsumer) {
        this.onMetricsRecordingStopped = methodprofilerresults -> {
            this.stopRecordingMetrics();
            resultConsumer.accept((ProfileResults)methodprofilerresults);
        };
        this.onMetricsRecordingFinished = dumpConsumer;
        this.willStartRecordingMetrics = true;
    }

    public void stopRecordingMetrics() {
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    }

    public void finishRecordingMetrics() {
        this.metricsRecorder.end();
    }

    public void cancelRecordingMetrics() {
        this.metricsRecorder.cancel();
    }

    public Path getWorldPath(LevelResource worldSavePath) {
        return this.storageSource.getLevelPath(worldSavePath);
    }

    public boolean forceSynchronousWrites() {
        return true;
    }

    public StructureTemplateManager getStructureManager() {
        return this.structureTemplateManager;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    public RegistryAccess.Frozen registryAccess() {
        return this.registries.compositeAccess();
    }

    public LayeredRegistryAccess<RegistryLayer> registries() {
        return this.registries;
    }

    public ReloadableServerRegistries.Holder reloadableRegistries() {
        return this.resources.managers.fullRegistries();
    }

    public TextFilter createTextFilterForPlayer(ServerPlayer player) {
        return TextFilter.DUMMY;
    }

    public ServerPlayerGameMode createGameModeForPlayer(ServerPlayer player) {
        return this.isDemo() ? new DemoMode(player) : new ServerPlayerGameMode(player);
    }

    @Nullable
    public GameType getForcedGameType() {
        return null;
    }

    public ResourceManager getResourceManager() {
        return this.resources.resourceManager;
    }

    public boolean isCurrentlySaving() {
        return this.isSaving;
    }

    public boolean isTimeProfilerRunning() {
        return this.debugCommandProfilerDelayStart || this.debugCommandProfiler != null;
    }

    public void startTimeProfiler() {
        this.debugCommandProfilerDelayStart = true;
    }

    public ProfileResults stopTimeProfiler() {
        if (this.debugCommandProfiler == null) {
            return EmptyProfileResults.EMPTY;
        }
        ProfileResults methodprofilerresults = this.debugCommandProfiler.stop(Util.getNanos(), this.tickCount);
        this.debugCommandProfiler = null;
        return methodprofilerresults;
    }

    public int getMaxChainedNeighborUpdates() {
        return 1000000;
    }

    public void logChatMessage(net.minecraft.network.chat.Component message, ChatType.Bound params, @Nullable String prefix) {
        Component s1 = PaperAdventure.asAdventure(params.decorate(message));
        if (prefix != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)prefix, (Object)s1);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator getChatDecorator() {
        return this.improvedChatDecorator;
    }

    public boolean logIPs() {
        return true;
    }

    public void subscribeToDebugSample(ServerPlayer player, RemoteDebugSampleType type) {
    }

    public boolean acceptsTransfers() {
        return false;
    }

    private void storeChunkIoError(CrashReport report, ChunkPos pos, RegionStorageInfo key) {
        Util.ioPool().execute(() -> {
            try {
                Path path = this.getFile("debug");
                FileUtil.createDirectoriesSafe(path);
                String s = FileUtil.sanitizeName(key.level());
                Path path1 = path.resolve("chunk-" + s + "-" + Util.getFilenameFormattedDateTime() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i = filestore.getUsableSpace();
                if (i < 8192L) {
                    LOGGER.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                CrashReportCategory crashreportsystemdetails = report.addCategory("Chunk Info");
                Objects.requireNonNull(key);
                crashreportsystemdetails.setDetail("Level", key::level);
                crashreportsystemdetails.setDetail("Dimension", () -> key.dimension().location().toString());
                Objects.requireNonNull(key);
                crashreportsystemdetails.setDetail("Storage", key::type);
                Objects.requireNonNull(pos);
                crashreportsystemdetails.setDetail("Position", pos::toString);
                report.saveToFile(path1, ReportType.CHUNK_IO_ERROR);
                LOGGER.info("Saved details to {}", (Object)report.getSaveFile());
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void reportChunkLoadFailure(Throwable exception, RegionStorageInfo key, ChunkPos chunkPos) {
        LOGGER.error("Failed to load chunk {},{}", new Object[]{chunkPos.x, chunkPos.z, exception});
        this.suppressedExceptions.addEntry("chunk/load", exception);
        this.storeChunkIoError(CrashReport.forThrowable(exception, "Chunk load failure"), chunkPos, key);
    }

    @Override
    public void reportChunkSaveFailure(Throwable exception, RegionStorageInfo key, ChunkPos chunkPos) {
        LOGGER.error("Failed to save chunk {},{}", new Object[]{chunkPos.x, chunkPos.z, exception});
        this.suppressedExceptions.addEntry("chunk/save", exception);
        this.storeChunkIoError(CrashReport.forThrowable(exception, "Chunk save failure"), chunkPos, key);
    }

    public void reportPacketHandlingException(Throwable exception, PacketType<?> type) {
        this.suppressedExceptions.addEntry("packet/" + type.toString(), exception);
    }

    public PotionBrewing potionBrewing() {
        return this.potionBrewing;
    }

    public FuelValues fuelValues() {
        return this.fuelValues;
    }

    public ServerLinks serverLinks() {
        return ServerLinks.EMPTY;
    }

    protected int pauseWhileEmptySeconds() {
        return 0;
    }

    public boolean isTickPaused() {
        return this.emptyTicks > 0 && this.emptyTicks >= this.pauseWhileEmptySeconds() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(ServerLevel worldserver1) {
        return worldserver1.getChunkSource().chunkMap.hasWork();
    }

    static {
        LOGGER = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)LOGGER.getName());
        OVERLOADED_THRESHOLD_NANOS = 30L * TimeUtil.NANOSECONDS_PER_SECOND / 20L;
        OVERLOADED_WARNING_INTERVAL_NANOS = 10L * TimeUtil.NANOSECONDS_PER_SECOND;
        STATUS_EXPIRE_TIME_NANOS = 5L * TimeUtil.NANOSECONDS_PER_SECOND;
        PREPARE_LEVELS_DEFAULT_DELAY_NANOS = 10L * TimeUtil.NANOSECONDS_PER_MILLISECOND;
        DEMO_SETTINGS = new LevelSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(FeatureFlags.DEFAULT_FLAGS), WorldDataConfiguration.DEFAULT);
        ANONYMOUS_PLAYER_PROFILE = new GameProfile(Util.NIL_UUID, "Anonymous Player");
        fatalException = new AtomicReference();
        startTimeMillis = System.currentTimeMillis();
        SERVER_INIT = System.nanoTime();
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i = 0; i < size; ++i) {
                this.samples[i] = RollingAverage.dec(20L);
                this.times[i] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t) {
            return new BigDecimal(t);
        }

        public void add(BigDecimal x, long t) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x;
            this.times[this.index] = t;
            this.time += t;
            this.total = this.total.add(x.multiply(RollingAverage.dec(t)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(CloseableResourceManager resourceManager, ReloadableServerResources managers) implements AutoCloseable
    {
        @Override
        public void close() {
            this.resourceManager.close();
        }
    }

    private static class TimeProfiler {
        final long startNanos;
        final int startTick;

        TimeProfiler(long time, int tick) {
            this.startNanos = time;
            this.startTick = tick;
        }

        ProfileResults stop(final long endTime, final int endTick) {
            return new ProfileResults(){

                @Override
                public List<ResultField> getTimes(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean saveResults(Path path) {
                    return false;
                }

                @Override
                public long getStartTimeNano() {
                    return startNanos;
                }

                @Override
                public int getStartTimeTicks() {
                    return startTick;
                }

                @Override
                public long getEndTimeNano() {
                    return endTime;
                }

                @Override
                public int getEndTimeTicks() {
                    return endTick;
                }

                @Override
                public String getProfilerResults() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID id, String url, String hash, boolean isRequired, @Nullable net.minecraft.network.chat.Component prompt) {
    }
}

