/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Queue;
import net.minecraft.util.ArrayListDeque;

public class SuppressedExceptionCollector {
    private static final int LATEST_ENTRY_COUNT = 8;
    private final Queue<LongEntry> latestEntries = new ArrayListDeque<LongEntry>();
    private final Object2IntLinkedOpenHashMap<ShortEntry> entryCounts = new Object2IntLinkedOpenHashMap();

    private static long currentTimeMs() {
        return System.currentTimeMillis();
    }

    public synchronized void addEntry(String location, Throwable exception) {
        long l = SuppressedExceptionCollector.currentTimeMs();
        String string = exception.getMessage();
        this.latestEntries.add(new LongEntry(l, location, exception.getClass(), string));
        while (this.latestEntries.size() > 8) {
            this.latestEntries.remove();
        }
        ShortEntry shortEntry = new ShortEntry(location, exception.getClass());
        int i = this.entryCounts.getInt((Object)shortEntry);
        this.entryCounts.putAndMoveToFirst((Object)shortEntry, i + 1);
    }

    public synchronized String dump() {
        long l = SuppressedExceptionCollector.currentTimeMs();
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.latestEntries.isEmpty()) {
            stringBuilder.append("\n\t\tLatest entries:\n");
            for (LongEntry longEntry : this.latestEntries) {
                stringBuilder.append("\t\t\t").append(longEntry.location).append(":").append(longEntry.cls).append(": ").append(longEntry.message).append(" (").append(l - longEntry.timestampMs).append("ms ago)").append("\n");
            }
        }
        if (!this.entryCounts.isEmpty()) {
            if (stringBuilder.isEmpty()) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("\t\tEntry counts:\n");
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.entryCounts)) {
                stringBuilder.append("\t\t\t").append(((ShortEntry)entry.getKey()).location).append(":").append(((ShortEntry)entry.getKey()).cls).append(" x ").append(entry.getIntValue()).append("\n");
            }
        }
        if (stringBuilder.isEmpty()) {
            return "~~NONE~~";
        }
        return stringBuilder.toString();
    }

    record LongEntry(long timestampMs, String location, Class<? extends Throwable> cls, String message) {
    }

    record ShortEntry(String location, Class<? extends Throwable> cls) {
    }
}

