/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.ticks.LevelTicks;

public class CloneCommands {
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((maxCount, count) -> Component.translatableEscape("commands.clone.toobig", maxCount, count));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.failed"));
    public static final Predicate<BlockInWorld> FILTER_AIR = pos -> !pos.getState().isAir();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clone").requires(source -> source.hasPermission(2))).then(CloneCommands.beginEndDestinationAndModeSuffix(commandRegistryAccess, context -> ((CommandSourceStack)context.getSource()).getLevel()))).then(Commands.literal("from").then(Commands.argument("sourceDimension", DimensionArgument.dimension()).then(CloneCommands.beginEndDestinationAndModeSuffix(commandRegistryAccess, context -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> beginEndDestinationAndModeSuffix(CommandBuildContext commandRegistryAccess, CommandFunction<CommandContext<CommandSourceStack>, ServerLevel> worldGetter) {
        return Commands.argument("begin", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("end", BlockPosArgument.blockPos()).then(CloneCommands.destinationAndModeSuffix(commandRegistryAccess, worldGetter, context -> ((CommandSourceStack)context.getSource()).getLevel()))).then(Commands.literal("to").then(Commands.argument("targetDimension", DimensionArgument.dimension()).then(CloneCommands.destinationAndModeSuffix(commandRegistryAccess, worldGetter, context -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "targetDimension"))))));
    }

    private static DimensionAndPosition getLoadedDimensionAndPosition(CommandContext<CommandSourceStack> context, ServerLevel world, String name) throws CommandSyntaxException {
        BlockPos blockPos = BlockPosArgument.getLoadedBlockPos(context, world, name);
        return new DimensionAndPosition(world, blockPos);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> destinationAndModeSuffix(CommandBuildContext commandRegistryAccess, CommandFunction<CommandContext<CommandSourceStack>, ServerLevel> sourceWorldGetter, CommandFunction<CommandContext<CommandSourceStack>, ServerLevel> targetWorldGetter) {
        CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> commandFunction = context -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)context, (ServerLevel)sourceWorldGetter.apply((CommandContext<CommandSourceStack>)context), "begin");
        CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> commandFunction2 = context -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)context, (ServerLevel)sourceWorldGetter.apply((CommandContext<CommandSourceStack>)context), "end");
        CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> commandFunction3 = context -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)context, (ServerLevel)targetWorldGetter.apply((CommandContext<CommandSourceStack>)context), "destination");
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("destination", BlockPosArgument.blockPos()).executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)commandFunction.apply(context), (DimensionAndPosition)commandFunction2.apply(context), (DimensionAndPosition)commandFunction3.apply(context), pos -> true, Mode.NORMAL))).then(CloneCommands.wrapWithCloneMode(commandFunction, commandFunction2, commandFunction3, context -> blockInWorld -> true, Commands.literal("replace").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)commandFunction.apply(context), (DimensionAndPosition)commandFunction2.apply(context), (DimensionAndPosition)commandFunction3.apply(context), pos -> true, Mode.NORMAL))))).then(CloneCommands.wrapWithCloneMode(commandFunction, commandFunction2, commandFunction3, context -> FILTER_AIR, Commands.literal("masked").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)commandFunction.apply(context), (DimensionAndPosition)commandFunction2.apply(context), (DimensionAndPosition)commandFunction3.apply(context), FILTER_AIR, Mode.NORMAL))))).then(Commands.literal("filtered").then(CloneCommands.wrapWithCloneMode(commandFunction, commandFunction2, commandFunction3, context -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "filter"), Commands.argument("filter", BlockPredicateArgument.blockPredicate(commandRegistryAccess)).executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)commandFunction.apply(context), (DimensionAndPosition)commandFunction2.apply(context), (DimensionAndPosition)commandFunction3.apply(context), BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "filter"), Mode.NORMAL)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithCloneMode(CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> beginPosGetter, CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> endPosGetter, CommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> destinationPosGetter, CommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> filterGetter, ArgumentBuilder<CommandSourceStack, ?> builder) {
        return ((ArgumentBuilder)((ArgumentBuilder)builder.then(Commands.literal("force").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)beginPosGetter.apply(context), (DimensionAndPosition)endPosGetter.apply(context), (DimensionAndPosition)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.FORCE)))).then(Commands.literal("move").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)beginPosGetter.apply(context), (DimensionAndPosition)endPosGetter.apply(context), (DimensionAndPosition)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.MOVE)))).then(Commands.literal("normal").executes(context -> CloneCommands.clone((CommandSourceStack)context.getSource(), (DimensionAndPosition)beginPosGetter.apply(context), (DimensionAndPosition)endPosGetter.apply(context), (DimensionAndPosition)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.NORMAL)));
    }

    private static int clone(CommandSourceStack source, DimensionAndPosition begin, DimensionAndPosition end, DimensionAndPosition destination, Predicate<BlockInWorld> filter, Mode mode) throws CommandSyntaxException {
        int j;
        BlockPos blockPos = begin.position();
        BlockPos blockPos2 = end.position();
        BoundingBox boundingBox = BoundingBox.fromCorners(blockPos, blockPos2);
        BlockPos blockPos3 = destination.position();
        BlockPos blockPos4 = blockPos3.offset(boundingBox.getLength());
        BoundingBox boundingBox2 = BoundingBox.fromCorners(blockPos3, blockPos4);
        ServerLevel serverLevel = begin.dimension();
        ServerLevel serverLevel2 = destination.dimension();
        if (!mode.canOverlap() && serverLevel == serverLevel2 && boundingBox2.intersects(boundingBox)) {
            throw ERROR_OVERLAP.create();
        }
        int i = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (i > (j = source.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)j, (Object)i);
        }
        if (!serverLevel.hasChunksAt(blockPos, blockPos2) || !serverLevel2.hasChunksAt(blockPos3, blockPos4)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        LinkedList deque = Lists.newLinkedList();
        BlockPos blockPos5 = new BlockPos(boundingBox2.minX() - boundingBox.minX(), boundingBox2.minY() - boundingBox.minY(), boundingBox2.minZ() - boundingBox.minZ());
        for (int k = boundingBox.minZ(); k <= boundingBox.maxZ(); ++k) {
            for (int l = boundingBox.minY(); l <= boundingBox.maxY(); ++l) {
                for (int m = boundingBox.minX(); m <= boundingBox.maxX(); ++m) {
                    BlockPos blockPos6 = new BlockPos(m, l, k);
                    BlockPos blockPos7 = blockPos6.offset(blockPos5);
                    BlockInWorld blockInWorld = new BlockInWorld(serverLevel, blockPos6, false);
                    BlockState blockState = blockInWorld.getState();
                    if (!filter.test(blockInWorld)) continue;
                    BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos6);
                    if (blockEntity != null) {
                        CloneBlockEntityInfo cloneBlockEntityInfo = new CloneBlockEntityInfo(blockEntity.saveCustomOnly(source.registryAccess()), blockEntity.components());
                        list2.add(new CloneBlockInfo(blockPos7, blockState, cloneBlockEntityInfo));
                        deque.addLast(blockPos6);
                        continue;
                    }
                    if (blockState.isSolidRender() || blockState.isCollisionShapeFullBlock(serverLevel, blockPos6)) {
                        list.add(new CloneBlockInfo(blockPos7, blockState, null));
                        deque.addLast(blockPos6);
                        continue;
                    }
                    list3.add(new CloneBlockInfo(blockPos7, blockState, null));
                    deque.addFirst(blockPos6);
                }
            }
        }
        if (mode == Mode.MOVE) {
            for (BlockPos blockPos8 : deque) {
                BlockEntity blockEntity2 = serverLevel.getBlockEntity(blockPos8);
                Clearable.tryClear(blockEntity2);
                serverLevel.setBlock(blockPos8, Blocks.BARRIER.defaultBlockState(), 2);
            }
            for (BlockPos blockPos9 : deque) {
                serverLevel.setBlock(blockPos9, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        ArrayList list4 = Lists.newArrayList();
        list4.addAll(list);
        list4.addAll(list2);
        list4.addAll(list3);
        List list5 = Lists.reverse((List)list4);
        for (Iterator cloneBlockInfo : list5) {
            BlockEntity blockEntity3 = serverLevel2.getBlockEntity(((CloneBlockInfo)((Object)cloneBlockInfo)).pos);
            Clearable.tryClear(blockEntity3);
            serverLevel2.setBlock(((CloneBlockInfo)((Object)cloneBlockInfo)).pos, Blocks.BARRIER.defaultBlockState(), 2);
        }
        int n = 0;
        for (CloneBlockInfo cloneBlockInfo2 : list4) {
            if (!serverLevel2.setBlock(cloneBlockInfo2.pos, cloneBlockInfo2.state, 2)) continue;
            ++n;
        }
        for (CloneBlockInfo cloneBlockInfo3 : list2) {
            BlockEntity blockEntity4 = serverLevel2.getBlockEntity(cloneBlockInfo3.pos);
            if (cloneBlockInfo3.blockEntityInfo != null && blockEntity4 != null) {
                blockEntity4.loadCustomOnly(cloneBlockInfo3.blockEntityInfo.tag, serverLevel2.registryAccess());
                blockEntity4.setComponents(cloneBlockInfo3.blockEntityInfo.components);
                blockEntity4.setChanged();
            }
            serverLevel2.setBlock(cloneBlockInfo3.pos, cloneBlockInfo3.state, 2);
        }
        for (CloneBlockInfo cloneBlockInfo4 : list5) {
            serverLevel2.blockUpdated(cloneBlockInfo4.pos, cloneBlockInfo4.state.getBlock());
        }
        ((LevelTicks)serverLevel2.getBlockTicks()).copyAreaFrom(serverLevel.getBlockTicks(), boundingBox, blockPos5);
        if (n == 0) {
            throw ERROR_FAILED.create();
        }
        int o = n;
        source.sendSuccess(() -> Component.translatable("commands.clone.success", o), true);
        return n;
    }

    @FunctionalInterface
    static interface CommandFunction<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    record DimensionAndPosition(ServerLevel dimension, BlockPos position) {
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean canOverlap;

        private Mode(boolean allowsOverlap) {
            this.canOverlap = allowsOverlap;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }
    }

    record CloneBlockEntityInfo(CompoundTag tag, DataComponentMap components) {
    }

    record CloneBlockInfo(BlockPos pos, BlockState state, @Nullable CloneBlockEntityInfo blockEntityInfo) {
    }
}

