/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;

public class ExecuteCommand {
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((maxCount, count) -> Component.translatableEscape("commands.execute.blocks.toobig", maxCount, count));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(count -> Component.translatableEscape("commands.execute.conditional.fail_count", count));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_CONDITION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((function, message) -> Component.translatableEscape("commands.execute.function.instantiationFailure", function, message));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PREDICATE = (context, builder) -> {
        ReloadableServerRegistries.Holder holder = ((CommandSourceStack)context.getSource()).getServer().reloadableRegistries();
        return SharedSuggestionProvider.suggestResource(holder.getKeys(Registries.PREDICATE), builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        LiteralCommandNode<CommandSourceStack> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("execute").requires(source -> source.hasPermission(2))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("execute").requires(source -> source.hasPermission(2))).then(Commands.literal("run").redirect(dispatcher.getRoot()))).then(ExecuteCommand.addConditionals(literalCommandNode, Commands.literal("if"), true, commandRegistryAccess))).then(ExecuteCommand.addConditionals(literalCommandNode, Commands.literal("unless"), false, commandRegistryAccess))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withEntity(entity));
            }
            return list;
        })))).then(Commands.literal("at").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withLevel((ServerLevel)entity.level()).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)Commands.literal("store").then(ExecuteCommand.wrapStores(literalCommandNode, Commands.literal("result"), true))).then(ExecuteCommand.wrapStores(literalCommandNode, Commands.literal("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("positioned").then(Commands.argument("pos", Vec3Argument.vec3()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos")).withAnchor(EntityAnchorArgument.Anchor.FEET)))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withPosition(entity.position()));
            }
            return list;
        })))).then(Commands.literal("over").then(Commands.argument("heightmap", HeightmapTypeArgument.heightmap()).redirect(literalCommandNode, context -> {
            Vec3 vec3 = ((CommandSourceStack)context.getSource()).getPosition();
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
            double d = vec3.x();
            double e = vec3.z();
            if (!serverLevel.hasChunk(SectionPos.blockToSectionCoord(d), SectionPos.blockToSectionCoord(e))) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            int i = serverLevel.getHeight(HeightmapTypeArgument.getHeightmap((CommandContext<CommandSourceStack>)context, "heightmap"), Mth.floor(d), Mth.floor(e));
            return ((CommandSourceStack)context.getSource()).withPosition(new Vec3(d, i, e));
        }))))).then(((LiteralArgumentBuilder)Commands.literal("rotated").then(Commands.argument("rot", RotationArgument.rotation()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withRotation(RotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rot").getRotation((CommandSourceStack)context.getSource()))))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withRotation(entity.getRotationVector()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("anchor", EntityAnchorArgument.anchor()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            EntityAnchorArgument.Anchor anchor = EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "anchor");
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).facing(entity, anchor));
            }
            return list;
        }))))).then(Commands.argument("pos", Vec3Argument.vec3()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).facing(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos")))))).then(Commands.literal("align").then(Commands.argument("axes", SwizzleArgument.swizzle()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withPosition(((CommandSourceStack)context.getSource()).getPosition().align(SwizzleArgument.getSwizzle((CommandContext<CommandSourceStack>)context, "axes"))))))).then(Commands.literal("anchored").then(Commands.argument("anchor", EntityAnchorArgument.anchor()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withAnchor(EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "anchor")))))).then(Commands.literal("in").then(Commands.argument("dimension", DimensionArgument.dimension()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withLevel(DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "dimension")))))).then(Commands.literal("summon").then(Commands.argument("entity", ResourceArgument.resource(commandRegistryAccess, Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).redirect(literalCommandNode, context -> ExecuteCommand.spawnEntityAndRedirect((CommandSourceStack)context.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)context, "entity")))))).then(ExecuteCommand.createRelationOperations(literalCommandNode, Commands.literal("on")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapStores(LiteralCommandNode<CommandSourceStack> node, LiteralArgumentBuilder<CommandSourceStack> builder, boolean requestResult) {
        builder.then(Commands.literal("score").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).redirect(node, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), requestResult)))));
        builder.then(Commands.literal("bossbar").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(BossBarCommands.SUGGEST_BOSS_BAR).then(Commands.literal("value").redirect(node, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), true, requestResult)))).then(Commands.literal("max").redirect(node, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), false, requestResult)))));
        for (DataCommands.DataProvider dataProvider : DataCommands.TARGET_PROVIDERS) {
            dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)builder, builderx -> builderx.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).then(Commands.literal("int").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> IntTag.valueOf((int)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(Commands.literal("float").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> FloatTag.valueOf((float)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(Commands.literal("short").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> ShortTag.valueOf((short)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(Commands.literal("long").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> LongTag.valueOf((long)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))).then(Commands.literal("double").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> DoubleTag.valueOf((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")), requestResult))))).then(Commands.literal("byte").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)node, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), result -> ByteTag.valueOf((byte)((double)result * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), requestResult))))));
        }
        return builder;
    }

    private static CommandSourceStack storeValue(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, boolean requestResult) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        return source.withCallback((successful, returnValue) -> {
            for (ScoreHolder scoreHolder : targets) {
                ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
                int i = requestResult ? returnValue : (successful ? 1 : 0);
                scoreAccess.set(i);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeValue(CommandSourceStack source, CustomBossEvent bossBar, boolean storeInValue, boolean requestResult) {
        return source.withCallback((successful, returnValue) -> {
            int i;
            int n = requestResult ? returnValue : (i = successful ? 1 : 0);
            if (storeInValue) {
                bossBar.setValue(i);
            } else {
                bossBar.setMax(i);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeData(CommandSourceStack source, DataAccessor object, NbtPathArgument.NbtPath path, IntFunction<Tag> nbtSetter, boolean requestResult) {
        return source.withCallback((successful, returnValue) -> {
            try {
                CompoundTag compoundTag = object.getData();
                int i = requestResult ? returnValue : (successful ? 1 : 0);
                path.set(compoundTag, (Tag)nbtSetter.apply(i));
                object.setData(compoundTag);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean isChunkLoaded(ServerLevel world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk levelChunk = world.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
        if (levelChunk != null) {
            return levelChunk.getFullStatus() == FullChunkStatus.ENTITY_TICKING && world.areEntitiesLoaded(chunkPos.toLong());
        }
        return false;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionals(CommandNode<CommandSourceStack> root, LiteralArgumentBuilder<CommandSourceStack> argumentBuilder, boolean positive, CommandBuildContext commandRegistryAccess) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(root, Commands.argument("block", BlockPredicateArgument.blockPredicate(commandRegistryAccess)), positive, context -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "block").test(new BlockInWorld(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), true))))))).then(Commands.literal("biome").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(root, Commands.argument("biome", ResourceOrTagArgument.resourceOrTag(commandRegistryAccess, Registries.BIOME)), positive, context -> ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandSourceStack>)context, "biome", Registries.BIOME).test(((CommandSourceStack)context.getSource()).getLevel().getBiome(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos")))))))).then(Commands.literal("loaded").then(ExecuteCommand.addConditional(root, Commands.argument("pos", BlockPosArgument.blockPos()), positive, commandContext -> ExecuteCommand.isChunkLoaded(((CommandSourceStack)commandContext.getSource()).getLevel(), BlockPosArgument.getBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos")))))).then(Commands.literal("dimension").then(ExecuteCommand.addConditional(root, Commands.argument("dimension", DimensionArgument.dimension()), positive, context -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "dimension") == ((CommandSourceStack)context.getSource()).getLevel())))).then(Commands.literal("score").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.literal("=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(root, Commands.argument("sourceObjective", ObjectiveArgument.objective()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int targetScore, int sourceScore) -> targetScore == sourceScore)))))).then(Commands.literal("<").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(root, Commands.argument("sourceObjective", ObjectiveArgument.objective()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int targetScore, int sourceScore) -> targetScore < sourceScore)))))).then(Commands.literal("<=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(root, Commands.argument("sourceObjective", ObjectiveArgument.objective()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int targetScore, int sourceScore) -> targetScore <= sourceScore)))))).then(Commands.literal(">").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(root, Commands.argument("sourceObjective", ObjectiveArgument.objective()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int targetScore, int sourceScore) -> targetScore > sourceScore)))))).then(Commands.literal(">=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(root, Commands.argument("sourceObjective", ObjectiveArgument.objective()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int targetScore, int sourceScore) -> targetScore >= sourceScore)))))).then(Commands.literal("matches").then(ExecuteCommand.addConditional(root, Commands.argument("range", RangeArgument.intRange()), positive, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)context, "range"))))))))).then(Commands.literal("blocks").then(Commands.argument("start", BlockPosArgument.blockPos()).then(Commands.argument("end", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("destination", BlockPosArgument.blockPos()).then(ExecuteCommand.addIfBlocksConditional(root, Commands.literal("all"), positive, false))).then(ExecuteCommand.addIfBlocksConditional(root, Commands.literal("masked"), positive, true))))))).then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("entities", EntityArgument.entities()).fork(root, context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, positive, !EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "entities").isEmpty()))).executes(ExecuteCommand.createNumericConditionalHandler(positive, context -> EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "entities").size()))))).then(Commands.literal("predicate").then(ExecuteCommand.addConditional(root, Commands.argument("predicate", ResourceOrIdArgument.lootPredicate(commandRegistryAccess)).suggests(SUGGEST_PREDICATE), positive, context -> ExecuteCommand.checkCustomPredicate((CommandSourceStack)context.getSource(), ResourceOrIdArgument.getLootPredicate((CommandContext<CommandSourceStack>)context, "predicate")))))).then(Commands.literal("function").then(Commands.argument("name", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).fork(root, (RedirectModifier)new ExecuteIfFunctionCustomModifier(positive))))).then(((LiteralArgumentBuilder)Commands.literal("items").then(Commands.literal("entity").then(Commands.argument("entities", EntityArgument.entities()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(commandRegistryAccess)).fork(root, commandContext -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)commandContext, positive, ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(positive, commandContext -> ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate"))))))))).then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(commandRegistryAccess)).fork(root, commandContext -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)commandContext, positive, ExecuteCommand.countItems((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(positive, commandContext -> ExecuteCommand.countItems((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate")))))))));
        for (DataCommands.DataProvider dataProvider : DataCommands.SOURCE_PROVIDERS) {
            argumentBuilder.then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("data"), builder -> builder.then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).fork(root, context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, positive, ExecuteCommand.checkMatchingData(dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(positive, context -> ExecuteCommand.checkMatchingData(dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path")))))));
        }
        return argumentBuilder;
    }

    private static int countItems(Iterable<? extends Entity> entities, SlotRange slotRange, Predicate<ItemStack> predicate) {
        int i = 0;
        for (Entity entity : entities) {
            IntList intList = slotRange.slots();
            for (int j = 0; j < intList.size(); ++j) {
                int k = intList.getInt(j);
                SlotAccess slotAccess = entity.getSlot(k);
                ItemStack itemStack = slotAccess.get();
                if (!predicate.test(itemStack)) continue;
                i += itemStack.getCount();
            }
        }
        return i;
    }

    private static int countItems(CommandSourceStack source, BlockPos pos, SlotRange slotRange, Predicate<ItemStack> predicate) throws CommandSyntaxException {
        int i = 0;
        Container container = ItemCommands.getContainer(source, pos, ItemCommands.ERROR_SOURCE_NOT_A_CONTAINER);
        int j = container.getContainerSize();
        IntList intList = slotRange.slots();
        for (int k = 0; k < intList.size(); ++k) {
            ItemStack itemStack;
            int l = intList.getInt(k);
            if (l < 0 || l >= j || !predicate.test(itemStack = container.getItem(l))) continue;
            i += itemStack.getCount();
        }
        return i;
    }

    private static Command<CommandSourceStack> createNumericConditionalHandler(boolean positive, CommandNumericPredicate condition) {
        if (positive) {
            return context -> {
                int i = condition.test((CommandContext<CommandSourceStack>)context);
                if (i > 0) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", i), false);
                    return i;
                }
                throw ERROR_CONDITIONAL_FAILED.create();
            };
        }
        return context -> {
            int i = condition.test((CommandContext<CommandSourceStack>)context);
            if (i == 0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)i);
        };
    }

    private static int checkMatchingData(DataAccessor object, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        return path.countMatching(object.getData());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> context, IntBiPredicate predicate) throws CommandSyntaxException {
        ScoreHolder scoreHolder = ScoreHolderArgument.getName(context, "target");
        Objective objective = ObjectiveArgument.getObjective(context, "targetObjective");
        ScoreHolder scoreHolder2 = ScoreHolderArgument.getName(context, "source");
        Objective objective2 = ObjectiveArgument.getObjective(context, "sourceObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
        ReadOnlyScoreInfo readOnlyScoreInfo2 = scoreboard.getPlayerScoreInfo(scoreHolder2, objective2);
        if (readOnlyScoreInfo == null || readOnlyScoreInfo2 == null) {
            return false;
        }
        return predicate.test(readOnlyScoreInfo.value(), readOnlyScoreInfo2.value());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> context, MinMaxBounds.Ints range) throws CommandSyntaxException {
        ScoreHolder scoreHolder = ScoreHolderArgument.getName(context, "target");
        Objective objective = ObjectiveArgument.getObjective(context, "targetObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
        if (readOnlyScoreInfo == null) {
            return false;
        }
        return range.matches(readOnlyScoreInfo.value());
    }

    private static boolean checkCustomPredicate(CommandSourceStack source, Holder<LootItemCondition> lootCondition) {
        ServerLevel serverLevel = source.getLevel();
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, source.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, source.getEntity()).create(LootContextParamSets.COMMAND);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        lootContext.pushVisitedElement(LootContext.createVisitedEntry(lootCondition.value()));
        return lootCondition.value().test(lootContext);
    }

    private static Collection<CommandSourceStack> expect(CommandContext<CommandSourceStack> context, boolean positive, boolean value) {
        if (value == positive) {
            return Collections.singleton((CommandSourceStack)context.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditional(CommandNode<CommandSourceStack> root, ArgumentBuilder<CommandSourceStack, ?> builder, boolean positive, CommandPredicate condition) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandSourceStack>)((RedirectModifier)context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, positive, condition.test((CommandContext<CommandSourceStack>)context))))).executes(context -> {
            if (positive == condition.test((CommandContext<CommandSourceStack>)context)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addIfBlocksConditional(CommandNode<CommandSourceStack> root, ArgumentBuilder<CommandSourceStack, ?> builder, boolean positive, boolean masked) {
        return ((ArgumentBuilder)builder.fork(root, (RedirectModifier<CommandSourceStack>)((RedirectModifier)context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, positive, ExecuteCommand.checkRegions((CommandContext<CommandSourceStack>)context, masked).isPresent())))).executes(positive ? context -> ExecuteCommand.checkIfRegions((CommandContext<CommandSourceStack>)context, masked) : context -> ExecuteCommand.checkUnlessRegions((CommandContext<CommandSourceStack>)context, masked));
    }

    private static int checkIfRegions(CommandContext<CommandSourceStack> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.checkRegions(context, masked);
        if (optionalInt.isPresent()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandSourceStack> context, boolean masked) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.checkRegions(context, masked);
        if (optionalInt.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)optionalInt.getAsInt());
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandSourceStack> context, boolean masked) throws CommandSyntaxException {
        return ExecuteCommand.checkRegions(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos(context, "start"), BlockPosArgument.getLoadedBlockPos(context, "end"), BlockPosArgument.getLoadedBlockPos(context, "destination"), masked);
    }

    private static OptionalInt checkRegions(ServerLevel world, BlockPos start, BlockPos end, BlockPos destination, boolean masked) throws CommandSyntaxException {
        BoundingBox boundingBox = BoundingBox.fromCorners(start, end);
        BoundingBox boundingBox2 = BoundingBox.fromCorners(destination, destination.offset(boundingBox.getLength()));
        BlockPos blockPos = new BlockPos(boundingBox2.minX() - boundingBox.minX(), boundingBox2.minY() - boundingBox.minY(), boundingBox2.minZ() - boundingBox.minZ());
        int i = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (i > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)i);
        }
        RegistryAccess registryAccess = world.registryAccess();
        int j = 0;
        for (int k = boundingBox.minZ(); k <= boundingBox.maxZ(); ++k) {
            for (int l = boundingBox.minY(); l <= boundingBox.maxY(); ++l) {
                for (int m = boundingBox.minX(); m <= boundingBox.maxX(); ++m) {
                    BlockPos blockPos2 = new BlockPos(m, l, k);
                    BlockPos blockPos3 = blockPos2.offset(blockPos);
                    BlockState blockState = world.getBlockState(blockPos2);
                    if (masked && blockState.is(Blocks.AIR)) continue;
                    if (blockState != world.getBlockState(blockPos3)) {
                        return OptionalInt.empty();
                    }
                    BlockEntity blockEntity = world.getBlockEntity(blockPos2);
                    BlockEntity blockEntity2 = world.getBlockEntity(blockPos3);
                    if (blockEntity != null) {
                        CompoundTag compoundTag2;
                        if (blockEntity2 == null) {
                            return OptionalInt.empty();
                        }
                        if (blockEntity2.getType() != blockEntity.getType()) {
                            return OptionalInt.empty();
                        }
                        if (!blockEntity.components().equals(blockEntity2.components())) {
                            return OptionalInt.empty();
                        }
                        CompoundTag compoundTag = blockEntity.saveCustomOnly(registryAccess);
                        if (!compoundTag.equals(compoundTag2 = blockEntity2.saveCustomOnly(registryAccess))) {
                            return OptionalInt.empty();
                        }
                    }
                    ++j;
                }
            }
        }
        return OptionalInt.of(j);
    }

    private static RedirectModifier<CommandSourceStack> expandOneToOneEntityRelation(Function<Entity, Optional<Entity>> function) {
        return context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            Entity entity2 = commandSourceStack.getEntity();
            if (entity2 == null) {
                return List.of();
            }
            return ((Optional)function.apply(entity2)).filter(entity -> !entity.isRemoved()).map(entity -> List.of(commandSourceStack.withEntity((Entity)entity))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandSourceStack> expandOneToManyEntityRelation(Function<Entity, Stream<Entity>> function) {
        return context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            Entity entity2 = commandSourceStack.getEntity();
            if (entity2 == null) {
                return List.of();
            }
            return ((Stream)function.apply(entity2)).filter(entity -> !entity.isRemoved()).map(commandSourceStack::withEntity).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRelationOperations(CommandNode<CommandSourceStack> node, LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.literal("owner").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("leasher").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                optional = Optional.ofNullable(leashable.getLeashHolder());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("target").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.getTarget());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("attacker").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.getLastAttacker());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("vehicle").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> Optional.ofNullable(entity.getVehicle()))))).then(Commands.literal("controller").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> Optional.ofNullable(entity.getControllingPassenger()))))).then(Commands.literal("origin").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("passengers").fork(node, ExecuteCommand.expandOneToManyEntityRelation(entity -> entity.getPassengers().stream())));
    }

    private static CommandSourceStack spawnEntityAndRedirect(CommandSourceStack source, Holder.Reference<EntityType<?>> entityType) throws CommandSyntaxException {
        Entity entity = SummonCommand.createEntity(source, entityType, source.getPosition(), new CompoundTag(), true);
        return source.withEntity(entity);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void scheduleFunctionConditionsAndTest(T baseSource, List<T> sources, Function<T, T> functionSourceGetter, IntPredicate predicate, ContextChain<T> contextChain, @Nullable CompoundTag args, ExecutionControl<T> control, CommandGetter<T, Collection<CommandFunction<T>>> functionNamesGetter, ChainModifiers flags) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$89(List list, ExecutionCommandSource executionCommandSource, ExecutionControl newControl) {
        for (InstantiatedFunction instantiatedFunction : list) {
            newControl.queueNext(new CallFunction<ExecutionCommandSource>(instantiatedFunction, newControl.currentFrame().returnValueConsumer(), true).bind(executionCommandSource));
        }
        newControl.queueNext(FallthroughTask.instance());
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$88(IntPredicate intPredicate, List list, ExecutionCommandSource executionCommandSource, boolean successful, int returnValue) {
        if (intPredicate.test(returnValue)) {
            list.add(executionCommandSource);
        }
    }

    @FunctionalInterface
    static interface CommandPredicate {
        public boolean test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface CommandNumericPredicate {
        public int test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    static class ExecuteIfFunctionCustomModifier
    implements CustomModifierExecutor.ModifierAdapter<CommandSourceStack> {
        private final IntPredicate check;

        ExecuteIfFunctionCustomModifier(boolean success) {
            this.check = success ? result -> result != 0 : result -> result == 0;
        }

        @Override
        @Override
        public void apply(CommandSourceStack baseSource, List<CommandSourceStack> sources, ContextChain<CommandSourceStack> contextChain, ChainModifiers flags, ExecutionControl<CommandSourceStack> control) {
            ExecuteCommand.scheduleFunctionConditionsAndTest(baseSource, sources, FunctionCommand::modifySenderForExecution, this.check, contextChain, null, control, context -> FunctionArgument.getFunctions((CommandContext<CommandSourceStack>)context, "name"), flags);
        }
    }

    @FunctionalInterface
    static interface IntBiPredicate {
        public boolean test(int var1, int var2);
    }

    @FunctionalInterface
    public static interface CommandGetter<T, R> {
        public R get(CommandContext<T> var1) throws CommandSyntaxException;
    }
}

