/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.world.level.ChunkPos;

public class ChunkTaskPriorityQueue {
    public static final int PRIORITY_LEVEL_COUNT = ChunkLevel.MAX_LEVEL + 2;
    private final List<Long2ObjectLinkedOpenHashMap<List<Runnable>>> queuesPerPriority = IntStream.range(0, PRIORITY_LEVEL_COUNT).mapToObj(level -> new Long2ObjectLinkedOpenHashMap()).toList();
    private volatile int topPriorityQueueIndex = PRIORITY_LEVEL_COUNT;
    private final String name;

    public ChunkTaskPriorityQueue(String name) {
        this.name = name;
    }

    protected void resortChunkTasks(int fromLevel, ChunkPos pos, int toLevel) {
        if (fromLevel >= PRIORITY_LEVEL_COUNT) {
            return;
        }
        Long2ObjectLinkedOpenHashMap<List<Runnable>> long2ObjectLinkedOpenHashMap = this.queuesPerPriority.get(fromLevel);
        List list = (List)long2ObjectLinkedOpenHashMap.remove(pos.toLong());
        if (fromLevel == this.topPriorityQueueIndex) {
            while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
                ++this.topPriorityQueueIndex;
            }
        }
        if (list != null && !list.isEmpty()) {
            ((List)this.queuesPerPriority.get(toLevel).computeIfAbsent(pos.toLong(), chunkPos -> Lists.newArrayList())).addAll(list);
            this.topPriorityQueueIndex = Math.min(this.topPriorityQueueIndex, toLevel);
        }
    }

    protected void submit(Runnable task, long pos, int level) {
        ((List)this.queuesPerPriority.get(level).computeIfAbsent(pos, chunkPos -> Lists.newArrayList())).add(task);
        this.topPriorityQueueIndex = Math.min(this.topPriorityQueueIndex, level);
    }

    protected void release(long pos, boolean removeElement) {
        for (Long2ObjectLinkedOpenHashMap<List<Runnable>> long2ObjectLinkedOpenHashMap : this.queuesPerPriority) {
            List list = (List)long2ObjectLinkedOpenHashMap.get(pos);
            if (list == null) continue;
            if (removeElement) {
                list.clear();
            }
            if (!list.isEmpty()) continue;
            long2ObjectLinkedOpenHashMap.remove(pos);
        }
        while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
            ++this.topPriorityQueueIndex;
        }
    }

    @Nullable
    public TasksForChunk pop() {
        if (!this.hasWork()) {
            return null;
        }
        int i = this.topPriorityQueueIndex;
        Long2ObjectLinkedOpenHashMap<List<Runnable>> long2ObjectLinkedOpenHashMap = this.queuesPerPriority.get(i);
        long l = long2ObjectLinkedOpenHashMap.firstLongKey();
        List list = (List)long2ObjectLinkedOpenHashMap.removeFirst();
        while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
            ++this.topPriorityQueueIndex;
        }
        return new TasksForChunk(l, list);
    }

    public boolean hasWork() {
        return this.topPriorityQueueIndex < PRIORITY_LEVEL_COUNT;
    }

    @Override
    public String toString() {
        return this.name + " " + this.topPriorityQueueIndex + "...";
    }

    public record TasksForChunk(long chunkPos, List<Runnable> tasks) {
    }
}

