/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.IteratorSafeOrderedReferenceSet;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import gg.pufferfish.pufferfish.PufferfishConfig;
import gg.pufferfish.pufferfish.util.IterableWrapper;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ServerChunkCache
extends ChunkSource
implements ChunkSystemServerChunkCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DistanceManager distanceManager;
    private final ServerLevel level;
    public final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    public final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    private final List<LevelChunk> tickingChunks = new ArrayList<LevelChunk>();
    private final Set<ChunkHolder> chunkHoldersToBroadcast = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;
    private final ConcurrentLong2ReferenceChainedHashTable<LevelChunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    long chunkFutureAwaitCounter;
    private final SimpleThreadUnsafeRandom shuffleRandom = new SimpleThreadUnsafeRandom(0L);
    public boolean firstRunSpawnCounts = true;
    public final AtomicBoolean _pufferfish_spawnCountsReady = new AtomicBoolean(false);

    public int getFullChunksCount() {
        return this.fullChunks.size();
    }

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, LevelChunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, chunk);
        }
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private ChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        ChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = this.level.moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.BLOCKING, completable::complete);
        if (TickThread.isTickThreadFor((Level)this.level, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.level, chunkX, chunkZ);
            this.mainThreadProcessor.managedBlock(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (ChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    private ChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        LevelChunk loading;
        ChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = this.level.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkAccess chunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.FULL || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        PlatformHooks platformHooks = PlatformHooks.get();
        if (platformHooks.hasCurrentlyLoadingChunk() && currentChunk != null && (loading = platformHooks.getCurrentlyLoadingChunk(currentChunk.vanillaChunkHolder)) != null && TickThread.isTickThread()) {
            return loading;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    private boolean isChunkNearPlayer(ChunkMap chunkMap, ChunkPos chunkPos, LevelChunk levelChunk) {
        ChunkData chunkData = levelChunk.moonrise$getChunkAndHolder().holder().moonrise$getRealChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        ReferenceList<ServerPlayer> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            if (!chunkMap.playerIsCloseEnoughForSpawning(raw[i], chunkPos, 16384.0)) continue;
            return true;
        }
        return false;
    }

    public ServerChunkCache(ServerLevel world, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, ChunkProgressListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<DimensionDataStorage> persistentStateManagerFactory) {
        this.level = world;
        this.mainThreadProcessor = new MainThreadExecutor(world);
        this.mainThread = Thread.currentThread();
        Path path = session.getDimensionPath(world.dimension()).resolve("data");
        try {
            FileUtil.createDirectoriesSafe(path);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to create dimension data storage directory", (Throwable)ioexception);
        }
        this.dataStorage = new DimensionDataStorage(path, dataFixer, world.registryAccess());
        this.chunkMap = new ChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.mainThreadProcessor, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(simulationDistance);
        this.clearCache();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = this.chunkMap.getUpdatingChunkIfPresent(ChunkPos.asLong(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Nullable
    public ChunkAccess getChunkAtImmediately(int x, int z) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong(x, z));
        if (holder == null) {
            return null;
        }
        return holder.getLatestChunk();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.addTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.removeTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public LevelChunk getChunkAtIfCachedImmediately(int x, int z) {
        long k = ChunkPos.asLong(x, z);
        ChunkHolder playerChunk = this.getVisibleChunkIfPresent(k);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public LevelChunk getChunkAtIfLoadedImmediately(int x, int z) {
        return this.fullChunks.get(ChunkPos.asLong(x, z));
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long pos) {
        return this.chunkMap.getVisibleChunkIfPresent(pos);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long pos, @Nullable ChunkAccess chunk, ChunkStatus status) {
        for (int j = 3; j > 0; --j) {
            this.lastChunkPos[j] = this.lastChunkPos[j - 1];
            this.lastChunkStatus[j] = this.lastChunkStatus[j - 1];
            this.lastChunk[j] = this.lastChunk[j - 1];
        }
        this.lastChunkPos[0] = pos;
        this.lastChunkStatus[0] = status;
        this.lastChunk[0] = chunk;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus leastStatus, boolean create) {
        if (leastStatus == ChunkStatus.FULL) {
            LevelChunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(x, z));
            if (ret != null) {
                return ret;
            }
            return create ? this.getChunkFallback(x, z, leastStatus, create) : null;
        }
        return this.getChunkFallback(x, z, leastStatus, create);
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int chunkX, int chunkZ) {
        LevelChunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (!PlatformHooks.get().hasCurrentlyLoadingChunk()) {
            return ret;
        }
        if (ret != null || !TickThread.isTickThread()) {
            return ret;
        }
        NewChunkHolder holder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (holder == null) {
            return ret;
        }
        return PlatformHooks.get().getCurrentlyLoadingChunk(holder.vanillaChunkHolder);
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<ChunkResult<ChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.mainThread;
        if (flag1) {
            completablefuture = this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create);
            MainThreadExecutor chunkproviderserver_b = this.mainThreadProcessor;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.managedBlock(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create), this.mainThreadProcessor).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        ChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread((Level)this.level, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.byStatus(leastStatus);
        NewChunkHolder chunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.FULL && (chunkHolder == null || !chunkHolder.getChunkStatus().isOrAfter(FullChunkStatus.FULL));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return GenerationChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        ChunkAccess chunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(leastStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<ChunkAccess>> ret = new CompletableFuture<ChunkResult<ChunkAccess>>();
            Consumer<ChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(GenerationChunkHolder.UNLOADED_CHUNK);
                } else {
                    ret.complete(ChunkResult.of(chunk));
                }
            };
            this.level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.of(ifPresent));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.getChunkNow(x, z) != null;
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    public boolean runDistanceManagerUpdates() {
        return this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(long pos) {
        NewChunkHolder newChunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    public void save(boolean flush) {
        this.chunkMap.saveAllChunks(flush);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        this.dataStorage.close();
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
    }

    @Override
    public void tick(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("purge");
        if (this.level.tickRateManager().runsNormally() || !tickChunks || this.level.spigotConfig.unloadFrozenChunks) {
            this.distanceManager.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        gameprofilerfiller.popPush("chunks");
        if (tickChunks) {
            this.level.moonrise$getPlayerChunkLoader().tick();
            this.tickChunks();
            this.chunkMap.tick();
        }
        gameprofilerfiller.popPush("unload");
        this.chunkMap.tick(shouldKeepTicking);
        gameprofilerfiller.pop();
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickChunks() {
        long i = this.level.getGameTime();
        long j = i - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = i;
        if (!this.level.isDebug()) {
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("pollingChunks");
            if (this.level.tickRateManager().runsNormally()) {
                List<LevelChunk> list = this.tickingChunks;
                try {
                    gameprofilerfiller.push("filteringTickingChunks");
                    this.collectTickingChunks(list);
                    gameprofilerfiller.popPush("shuffleChunks");
                    this.shuffleRandom.setSeed(this.level.random.nextLong());
                    if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
                        Util.shuffle(list, this.shuffleRandom);
                    }
                    this.tickChunks(gameprofilerfiller, j, list);
                    gameprofilerfiller.pop();
                }
                finally {
                    list.clear();
                }
            }
            this.broadcastChangedChunks(gameprofilerfiller);
            gameprofilerfiller.pop();
        }
        if (PufferfishConfig.enableAsyncMobSpawning) {
            for (ServerPlayer player : this.level.players) {
                for (int ii = 0; ii < ServerPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                    player.mobCounts[ii] = 0;
                    int newBackoff = player.mobBackoffCounts[ii] - 1;
                    if (newBackoff < 0) {
                        newBackoff = 0;
                    }
                    player.mobBackoffCounts[ii] = newBackoff;
                }
            }
            if (this.firstRunSpawnCounts) {
                this.firstRunSpawnCounts = false;
                this._pufferfish_spawnCountsReady.set(true);
            }
            if (this._pufferfish_spawnCountsReady.getAndSet(false)) {
                MinecraftServer.getServer().mobSpawnExecutor.submit(() -> {
                    int mapped = this.distanceManager.getNaturalSpawnChunkCount();
                    IteratorSafeOrderedReferenceSet.Iterator<Entity> objectiterator = this.level.entityTickList.entities.iterator(1);
                    try {
                        IterableWrapper<Entity> wrappedIterator = new IterableWrapper<Entity>(objectiterator);
                        this.lastSpawnState = NaturalSpawner.createState(mapped, wrappedIterator, this::getFullChunk, null, true);
                    }
                    finally {
                        objectiterator.finishedIterating();
                    }
                    this._pufferfish_spawnCountsReady.set(true);
                });
            }
        }
    }

    private void broadcastChangedChunks(ProfilerFiller profiler) {
        profiler.push("broadcast");
        for (ChunkHolder playerchunk : this.chunkHoldersToBroadcast) {
            LevelChunk chunk = playerchunk.getChunkToSend();
            if (chunk == null) continue;
            playerchunk.broadcastChanges(chunk);
        }
        this.chunkHoldersToBroadcast.clear();
        profiler.pop();
    }

    private void collectTickingChunks(List<LevelChunk> chunks) {
        ReferenceList<ChunkAndHolder> tickingChunks = this.level.moonrise$getPlayerTickingChunks();
        ChunkAndHolder[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        ChunkMap chunkMap = this.chunkMap;
        for (int i = 0; i < size; ++i) {
            ChunkAndHolder chunkAndHolder = raw[i];
            LevelChunk levelChunk = chunkAndHolder.chunk();
            if (!this.isChunkNearPlayer(chunkMap, levelChunk.getPos(), levelChunk)) continue;
            chunks.add(levelChunk);
        }
    }

    private void tickChunks(ProfilerFiller profiler, long timeDelta, List<LevelChunk> chunks) {
        List<MobCategory> list1;
        int j;
        profiler.popPush("naturalSpawnCount");
        int naturalSpawnChunkCount = j = this.distanceManager.getNaturalSpawnChunkCount();
        if ((this.spawnFriendlies || this.spawnEnemies) && this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            if (!PufferfishConfig.enableAsyncMobSpawning) {
                for (ServerPlayer player : this.level.players) {
                    for (int ii = 0; ii < ServerPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                        player.mobCounts[ii] = 0;
                        int newBackoff = player.mobBackoffCounts[ii] - 1;
                        if (newBackoff < 0) {
                            newBackoff = 0;
                        }
                        player.mobBackoffCounts[ii] = newBackoff;
                    }
                }
                this.lastSpawnState = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, null, true);
            }
        } else {
            this.lastSpawnState = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, !this.level.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.chunkMap) : null, false);
            this._pufferfish_spawnCountsReady.set(true);
        }
        profiler.popPush("spawnAndTick");
        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && !this.level.players().isEmpty();
        int k = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if (flag && (this.spawnEnemies || this.spawnFriendlies)) {
            for (ServerPlayer entityPlayer : this.level.players()) {
                int chunkRange = Math.min(this.level.spigotConfig.mobSpawnRange, entityPlayer.getBukkitEntity().getViewDistance());
                chunkRange = Math.min(chunkRange, 8);
                entityPlayer.playerNaturallySpawnedEvent = new PlayerNaturallySpawnCreaturesEvent((Player)entityPlayer.getBukkitEntity(), (byte)chunkRange);
                entityPlayer.playerNaturallySpawnedEvent.callEvent();
            }
            boolean flag1 = this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.level.getLevelData().getGameTime() % this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            list1 = NaturalSpawner.getFilteredSpawningCategories(this.lastSpawnState, this.spawnFriendlies, this.spawnEnemies, flag1, this.level);
        } else {
            list1 = List.of();
        }
        for (LevelChunk chunk : chunks) {
            ChunkPos chunkcoordintpair = chunk.getPos();
            chunk.incrementInhabitedTime(timeDelta);
            if (!list1.isEmpty() && this.level.getWorldBorder().isWithinBounds(chunkcoordintpair) && (!PufferfishConfig.enableAsyncMobSpawning || this._pufferfish_spawnCountsReady.get()) && this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
                NaturalSpawner.spawnForChunk(this.level, chunk, this.lastSpawnState, list1);
            }
            this.level.tickChunk(chunk, k);
        }
        profiler.popPush("customSpawners");
        if (flag) {
            this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
        }
    }

    private void getFullChunk(long pos, Consumer<LevelChunk> chunkConsumer) {
        LevelChunk fullChunk = this.fullChunks.get(pos);
        if (fullChunk != null) {
            chunkConsumer.accept(fullChunk);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos pos) {
        int j;
        int i = SectionPos.blockToSectionCoord(pos.getX());
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(ChunkPos.asLong(i, j = SectionPos.blockToSectionCoord(pos.getZ())));
        if (playerchunk != null && playerchunk.blockChanged(pos)) {
            this.chunkHoldersToBroadcast.add(playerchunk);
        }
    }

    @Override
    public void onLightUpdate(LightLayer type, SectionPos pos) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos.chunk().toLong());
            if (playerchunk != null && playerchunk.sectionLightChanged(type, pos.y())) {
                this.chunkHoldersToBroadcast.add(playerchunk);
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.addRegionTicket(ticketType, pos, radius, argument);
    }

    public <T> void removeRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.removeRegionTicket(ticketType, pos, radius, argument);
    }

    @Override
    public void updateChunkForced(ChunkPos pos, boolean forced) {
        this.distanceManager.updateChunkForced(pos, forced);
    }

    public void move(ServerPlayer player) {
        if (!player.isRemoved()) {
            this.chunkMap.move(player);
        }
    }

    public void removeEntity(Entity entity) {
        this.chunkMap.removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        this.chunkMap.addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcast(entity, packet);
    }

    public void setViewDistance(int watchDistance) {
        this.chunkMap.setServerViewDistance(watchDistance);
    }

    public void setSendViewDistance(int viewDistance) {
        this.level.moonrise$getPlayerChunkLoader().setSendDistance(viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        this.distanceManager.updateSimulationDistance(simulationDistance);
    }

    @Override
    public void setSpawnSettings(boolean spawnMonsters) {
        this.setSpawnSettings(spawnMonsters, this.spawnFriendlies);
    }

    public void setSpawnSettings(boolean flag, boolean spawnFriendlies) {
        this.spawnEnemies = flag;
        this.spawnFriendlies = spawnFriendlies;
    }

    public String getChunkDebugData(ChunkPos pos) {
        return this.chunkMap.getChunkDebugData(pos);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    public void onChunkReadyToSend(ChunkHolder chunkHolder) {
        if (chunkHolder.hasChangesToBroadcast()) {
            this.chunkHoldersToBroadcast.add(chunkHolder);
        }
    }

    private static /* synthetic */ boolean lambda$purgeUnload$3() {
        return true;
    }

    public final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level world) {
            super("Chunk source main thread executor for " + String.valueOf(world.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier stopCondition) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && stopCondition.getAsBoolean());
        }

        @Override
        public Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean shouldRun(Runnable task) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable task) {
            Profiler.get().incrementCounter("runTask");
            super.doRunTask(task);
        }

        @Override
        public boolean pollTask() {
            ServerChunkCache serverChunkCache = ServerChunkCache.this;
            if (serverChunkCache.runDistanceManagerUpdates()) {
                return true;
            }
            return super.pollTask() | serverChunkCache.level.moonrise$getChunkTaskScheduler().executeMainThreadTask();
        }
    }

    public record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

