/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTicks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class ServerLevel
extends Level
implements ServerEntityGetter,
WorldGenLevel,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPos END_SPAWN_POINT = new BlockPos(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<ServerPlayer> players = Lists.newArrayList();
    public final ServerChunkCache chunkSource;
    private final MinecraftServer server;
    public final PrimaryLevelData serverLevelData;
    private int lastSpawnChunkRadius;
    final EntityTickList entityTickList = new EntityTickList();
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalForcer portalForcer;
    private final LevelTicks<Block> blockTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final LevelTicks<Fluid> fluidTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final PathTypeCache pathTypesByPosCache = new PathTypeCache();
    final Set<Mob> navigatingMobs = new ObjectOpenHashSet();
    volatile boolean isUpdatingNavigations;
    protected final Raids raids;
    private final ObjectLinkedOpenHashSet<BlockEventData> blockEvents = new ObjectLinkedOpenHashSet();
    private final List<BlockEventData> blockEventsToReschedule = new ArrayList<BlockEventData>(64);
    private boolean handlingTick;
    private final List<CustomSpawner> customSpawners;
    @Nullable
    private EndDragonFight dragonFight;
    final Int2ObjectMap<EnderDragonPart> dragonParts = new Int2ObjectOpenHashMap();
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private double preciseTime;
    private boolean forceTime;
    private final RandomSequences randomSequences;
    public final LevelStorageSource.LevelStorageAccess convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    public boolean hasRidableMoveEvent = false;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final ServerChunkCache.ChunkAndHolder[] EMPTY_CHUNK_AND_HOLDERS = new ServerChunkCache.ChunkAndHolder[0];
    private final ReferenceList<ServerChunkCache.ChunkAndHolder> loadedChunks = new ReferenceList<ServerChunkCache.ChunkAndHolder>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ServerChunkCache.ChunkAndHolder> tickingChunks = new ReferenceList<ServerChunkCache.ChunkAndHolder>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ServerChunkCache.ChunkAndHolder> entityTickingChunks = new ReferenceList<ServerChunkCache.ChunkAndHolder>(EMPTY_CHUNK_AND_HOLDERS);
    private static final ServerChunkCache.ChunkAndHolder[] EMPTY_PLAYER_CHUNK_HOLDERS = new ServerChunkCache.ChunkAndHolder[0];
    private final ReferenceList<ServerChunkCache.ChunkAndHolder> playerTickingChunks = new ReferenceList<ServerChunkCache.ChunkAndHolder>(EMPTY_PLAYER_CHUNK_HOLDERS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.generateUniqueSeed());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    @Override
    public LevelChunk getChunkIfLoaded(int x, int z) {
        return this.chunkSource.getChunkAtIfLoadedImmediately(x, z);
    }

    @Override
    public ResourceKey<LevelStem> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AABB axisalignedbb) {
        int minBlockX = Mth.floor(axisalignedbb.minX - 1.0E-7) - 3;
        int maxBlockX = Mth.floor(axisalignedbb.maxX + 1.0E-7) + 3;
        int minBlockZ = Mth.floor(axisalignedbb.minZ - 1.0E-7) - 3;
        int maxBlockZ = Mth.floor(axisalignedbb.maxZ + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ServerChunkCache chunkProvider = this.getChunkSource();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AABB axisalignedbb, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        int minBlockX = Mth.floor(axisalignedbb.minX - 1.0E-7) - 3;
        int minBlockZ = Mth.floor(axisalignedbb.minZ - 1.0E-7) - 3;
        int maxBlockX = Mth.floor(axisalignedbb.maxX + 1.0E-7) + 3;
        int maxBlockZ = Mth.floor(axisalignedbb.maxZ + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public Player getPlayerByUUID(UUID uuid) {
        ServerPlayer player = this.getServer().getPlayerList().getPlayer(uuid);
        return player != null && player.level() == this ? player : null;
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.chunkSource.getChunkNow(chunkX, chunkZ);
    }

    @Override
    public final ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.server.moonrise$executeMidTickTasks();
    }

    @Override
    public final ChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPos pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.getX() - radiusBlocks >> 4, pos.getX() + radiusBlocks >> 4, pos.getZ() - radiusBlocks >> 4, pos.getZ() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.FULL, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<ChunkAccess>> onLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<ChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.getPos(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i = 0; i < len; ++i) {
                        ChunkPos chunkPos = ((ChunkAccess)ret.get(i)).getPos();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkTaskScheduler.scheduleChunkLoad(cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<ServerChunkCache.ChunkAndHolder> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<ServerChunkCache.ChunkAndHolder> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<ServerChunkCache.ChunkAndHolder> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ServerChunkCache chunkSource = this.chunkSource;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final ReferenceList<ServerChunkCache.ChunkAndHolder> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(LevelChunk chunk) {
        ChunkPos pos = chunk.getPos();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(LevelChunk chunk) {
        this.playerTickingChunks.remove(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((Level)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add(((LevelChunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((Level)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove(((LevelChunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    public ServerLevel(MinecraftServer minecraftserver, Executor executor, LevelStorageSource.LevelStorageAccess convertable_conversionsession, PrimaryLevelData iworlddataserver, ResourceKey<Level> resourcekey, LevelStem worlddimension, ChunkProgressListener worldloadlistener, boolean flag, long i, List<CustomSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.registryAccess(), worlddimension.type(), false, flag, i, minecraftserver.getMaxChainedNeighborUpdates(), gen, biomeProvider, env, spigotConfig -> minecraftserver.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(convertable_conversionsession.levelDirectory.path(), iworlddataserver.getLevelName(), resourcekey.location(), spigotConfig, minecraftserver.registryAccess(), iworlddataserver.getGameRules())), executor);
        this.pvpMode = minecraftserver.isPvpAllowed();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.levelDirectory.path().toFile());
        this.tickTime = flag1;
        this.server = minecraftserver;
        this.customSpawners = Lists.newArrayList();
        if (this.purpurConfig.phantomSpawning) {
            this.customSpawners.add(new PhantomSpawner());
        }
        if (this.purpurConfig.patrolSpawning) {
            this.customSpawners.add(new PatrolSpawner());
        }
        if (this.purpurConfig.catSpawning) {
            this.customSpawners.add(new CatSpawner());
        }
        if (this.purpurConfig.villageSiegeSpawning) {
            this.customSpawners.add(new VillageSiege());
        }
        if (this.purpurConfig.villagerTraderSpawning) {
            this.customSpawners.add(new WanderingTraderSpawner(iworlddataserver));
        }
        this.serverLevelData = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.generator();
        this.serverLevelData.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, (Registry<Biome>)this.server.registryAccess().lookupOrThrow(Registries.BIOME), chunkgenerator.getBiomeSource());
            if (chunkgenerator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator cga = (NoiseBasedChunkGenerator)chunkgenerator;
                chunkgenerator = new NoiseBasedChunkGenerator((BiomeSource)worldChunkManager, cga.settings);
            } else if (chunkgenerator instanceof FlatLevelSource) {
                FlatLevelSource cpf = (FlatLevelSource)chunkgenerator;
                chunkgenerator = new FlatLevelSource(cpf.settings(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.forceSynchronousWrites();
        DataFixer datafixer = minecraftserver.getFixerUpper();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.getLevelId(), resourcekey, "entities"), convertable_conversionsession.getDimensionPath(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.ENTITY_CHUNK), this, minecraftserver);
        StructureTemplateManager structuretemplatemanager = minecraftserver.getStructureManager();
        int j = this.spigotConfig.viewDistance;
        int k = this.spigotConfig.simulationDistance;
        this.chunkSource = new ServerChunkCache(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j, k, flag2, worldloadlistener, null, () -> minecraftserver.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalForcer(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.getWorldBorder().setAbsoluteMaxSize(minecraftserver.getAbsoluteMaxWorldSize());
        this.raids = this.getDataStorage().computeIfAbsent(Raids.factory(this), Raids.getFileId(this.dimensionTypeRegistration()));
        if (!minecraftserver.isSingleplayer()) {
            iworlddataserver.setGameType(minecraftserver.getDefaultGameType());
        }
        long l = minecraftserver.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), minecraftserver.getStructureManager(), this.getTypeKey(), chunkgenerator, this.chunkSource.randomState(), this, chunkgenerator.getBiomeSource(), l, datafixer);
        this.structureManager = new StructureManager(this, this.serverLevelData.worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == Level.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) || env == World.Environment.THE_END ? new EndDragonFight(this, this.serverLevelData.worldGenOptions().seed(), this.serverLevelData.endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(randomsequences, () -> this.getDataStorage().computeIfAbsent(RandomSequences.factory(l), "random_sequences"));
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new EntityCallbacks()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(convertable_conversionsession.getLevelId(), resourcekey, "entities"), convertable_conversionsession.getDimensionPath(resourcekey).resolve("entities"), minecraftserver.forceSynchronousWrites()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
        this.preciseTime = this.serverLevelData.getDayTime();
    }

    @Override
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.getChunkSource().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EndDragonFight enderDragonFight) {
        this.dragonFight = enderDragonFight;
    }

    public void setWeatherParameters(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.serverLevelData.setClearWeatherTime(clearDuration);
        this.serverLevelData.setRainTime(rainDuration);
        this.serverLevelData.setThunderTime(rainDuration);
        this.serverLevelData.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.serverLevelData.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(biomeX, biomeY, biomeZ, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier shouldKeepTicking) {
        boolean flag1;
        long j;
        ProfilerFiller gameprofilerfiller = Profiler.get();
        this.handlingTick = true;
        TickRateManager tickratemanager = this.tickRateManager();
        boolean flag = tickratemanager.runsNormally();
        if (flag) {
            gameprofilerfiller.push("world border");
            this.getWorldBorder().tick();
            gameprofilerfiller.popPush("weather");
            this.advanceWeatherCycle();
            gameprofilerfiller.pop();
        }
        int i = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
        if (this.purpurConfig.playersSkipNight && this.sleepStatus.areEnoughSleeping(i) && this.sleepStatus.areEnoughDeepSleeping(i, this.players)) {
            j = this.levelData.getDayTime() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j - j % 24000L - this.getDayTime());
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setDayTime(this.getDayTime() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.wakeUpAllPlayers();
            }
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if (flag) {
            this.tickTime();
        }
        gameprofilerfiller.push("tickPending");
        if (!this.isDebug() && flag) {
            j = this.getGameTime();
            gameprofilerfiller.push("blockTicks");
            this.blockTicks.tick(j, this.paperConfig().environment.maxBlockTicks, this::tickBlock);
            gameprofilerfiller.popPush("fluidTicks");
            this.fluidTicks.tick(j, this.paperConfig().environment.maxFluidTicks, this::tickFluid);
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.popPush("raid");
        if (flag) {
            this.raids.tick();
        }
        gameprofilerfiller.popPush("chunkSource");
        this.getChunkSource().tick(shouldKeepTicking, true);
        gameprofilerfiller.popPush("blockEvents");
        if (flag) {
            this.runBlockEvents();
        }
        this.handlingTick = false;
        gameprofilerfiller.pop();
        boolean bl = flag1 = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || !this.players.isEmpty() || !this.getForcedChunks().isEmpty();
        if (flag1) {
            this.resetEmptyTime();
        }
        if (flag1 || this.emptyTime++ < 300) {
            gameprofilerfiller.push("entities");
            if (this.dragonFight != null && flag) {
                gameprofilerfiller.push("dragonFight");
                this.dragonFight.tick();
                gameprofilerfiller.pop();
            }
            ActivationRange.activateEntities(this);
            this.entityTickList.forEach(entity -> {
                entity.activatedPriorityReset = false;
                if (!entity.isRemoved() && !tickratemanager.isEntityFrozen((net.minecraft.world.entity.Entity)entity)) {
                    gameprofilerfiller.push("checkDespawn");
                    entity.checkDespawn();
                    gameprofilerfiller.pop();
                    net.minecraft.world.entity.Entity entity1 = entity.getVehicle();
                    if (entity1 != null) {
                        if (!entity1.isRemoved() && entity1.hasPassenger((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.stopRiding();
                    }
                    gameprofilerfiller.push("tick");
                    try {
                        this.tickNonPassenger((net.minecraft.world.entity.Entity)entity);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw throwable;
                        }
                        String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.level().getWorld().getName(), entity.getX(), entity.getY(), entity.getZ());
                        MinecraftServer.LOGGER.error(msg, throwable);
                        this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
                        entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    }
                    this.moonrise$midTickTasks();
                    gameprofilerfiller.pop();
                }
            });
            gameprofilerfiller.pop();
            this.tickBlockEntities();
        }
        gameprofilerfiller.push("entityManagement");
        gameprofilerfiller.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void tickTime() {
        if (this.tickTime) {
            long i = this.levelData.getGameTime() + 1L;
            this.serverLevelData.setGameTime(i);
            Profiler.get().push("scheduledFunctions");
            this.serverLevelData.getScheduledEvents().tick(this.server, i);
            Profiler.get().pop();
            if (this.serverLevelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                int incrementTicks;
                int n = incrementTicks = this.isDay() ? this.purpurConfig.daytimeTicks : this.purpurConfig.nighttimeTicks;
                if (incrementTicks != 12000) {
                    this.preciseTime += 12000.0 / (double)incrementTicks;
                    this.setDayTime(this.preciseTime);
                } else {
                    this.setDayTime(this.levelData.getDayTime() + 1L);
                }
            }
        }
    }

    public void setDayTime(long timeOfDay) {
        this.serverLevelData.setDayTime(timeOfDay);
        this.preciseTime = timeOfDay;
        this.forceTime = false;
    }

    public void setDayTime(double i) {
        this.serverLevelData.setDayTime((long)i);
        this.forceTime = true;
    }

    public boolean isForceTime() {
        return this.forceTime;
    }

    public void tickCustomSpawners(boolean spawnMonsters, boolean spawnAnimals) {
        for (CustomSpawner mobspawner : this.customSpawners) {
            mobspawner.tick(this, spawnMonsters, spawnAnimals);
        }
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(LivingEntity::isSleeping).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.stopSleepInBed(false, false));
    }

    private void optimiseRandomTick(LevelChunk chunk, int tickSpeed) {
        LevelChunkSection[] sections = chunk.getSections();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkPos cpos = chunk.getPos();
        int offsetX = cpos.x << 4;
        int offsetZ = cpos.z << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            LevelChunkSection section = sections[sectionIndex];
            PalettedContainer<BlockState> states = section.states;
            if (!section.isRandomlyTickingBlocks()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i = 0; i < tickSpeed; ++i) {
                FluidState fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.nextInt() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                BlockState state = states.get(location);
                BlockPos pos = new BlockPos(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.randomTick(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.getFluidState()).isRandomlyTicking()) continue;
                fluidState.randomTick(this, pos, simpleRandom);
            }
        }
    }

    public void tickChunk(LevelChunk chunk, int randomTickSpeed) {
        BlockPos blockposition;
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkPos chunkcoordintpair = chunk.getPos();
        boolean flag = this.isRaining();
        int j = chunkcoordintpair.getMinBlockX();
        int k = chunkcoordintpair.getMinBlockZ();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("thunder");
        if (!this.paperConfig().environment.disableThunder && flag && this.isThundering() && this.spigotConfig.thunderChance > 0 && chunk.shouldDoLightning(this.simpleRandom) && this.isRainingAt(blockposition = this.findLightningTargetAround(this.getBlockRandomPos(j, 0, k, 15)))) {
            LightningBolt entitylightning;
            boolean flag1;
            DifficultyInstance difficultydamagescaler = this.getCurrentDifficultyAt(blockposition);
            boolean bl = flag1 = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)difficultydamagescaler.getEffectiveDifficulty() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.getBlockState(blockposition.below()).is(Blocks.LIGHTNING_ROD);
            if (flag1) {
                AbstractHorse entityhorseskeleton;
                if (this.purpurConfig.zombieHorseSpawnChance > 0.0 && this.random.nextDouble() <= this.purpurConfig.zombieHorseSpawnChance) {
                    entityhorseskeleton = EntityType.ZOMBIE_HORSE.create(this, EntitySpawnReason.EVENT);
                } else {
                    entityhorseskeleton = EntityType.SKELETON_HORSE.create(this, EntitySpawnReason.EVENT);
                    if (entityhorseskeleton != null) {
                        ((SkeletonHorse)entityhorseskeleton).setTrap(true);
                    }
                }
                if (entityhorseskeleton != null) {
                    entityhorseskeleton.setAge(0);
                    entityhorseskeleton.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                    this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
            }
            if ((entitylightning = EntityType.LIGHTNING_BOLT.create(this, EntitySpawnReason.EVENT)) != null) {
                entitylightning.moveTo(Vec3.atBottomCenterOf(blockposition));
                entitylightning.setVisualOnly(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.popPush("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int l = 0; l < randomTickSpeed; ++l) {
                if (simpleRandom.nextInt(48) != 0) continue;
                this.tickPrecipitation(this.getBlockRandomPos(j, 0, k, 15));
            }
        }
        gameprofilerfiller.popPush("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        gameprofilerfiller.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPos pos) {
        BlockPos blockposition1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
        BlockPos blockposition2 = blockposition1.below();
        Biome biomebase = this.getBiome(blockposition1).value();
        if (biomebase.shouldFreeze(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((Level)this, blockposition2, Blocks.ICE.defaultBlockState(), null);
        }
        if (this.isRaining()) {
            Biome.Precipitation biomebase_precipitation;
            int i = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if (i > 0 && biomebase.shouldSnow(this, blockposition1)) {
                BlockState iblockdata = this.getBlockState(blockposition1);
                if (iblockdata.is(Blocks.SNOW)) {
                    int j = iblockdata.getValue(SnowLayerBlock.LAYERS);
                    if (j < Math.min(i, 8)) {
                        BlockState iblockdata1 = (BlockState)iblockdata.setValue(SnowLayerBlock.LAYERS, j + 1);
                        Block.pushEntitiesUp(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((Level)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((Level)this, blockposition1, Blocks.SNOW.defaultBlockState(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.getPrecipitationAt(blockposition2, this.getSeaLevel())) != Biome.Precipitation.NONE) {
                BlockState iblockdata2 = this.getBlockState(blockposition2);
                iblockdata2.getBlock().handlePrecipitation(iblockdata2, this, blockposition2, biomebase_precipitation);
            }
        }
    }

    public Optional<BlockPos> findLightningRod(BlockPos pos) {
        Optional<BlockPos> optional = this.getPoiManager().findClosest(holder -> holder.is(PoiTypes.LIGHTNING_ROD), blockposition1 -> blockposition1.getY() == this.getHeight(Heightmap.Types.WORLD_SURFACE, blockposition1.getX(), blockposition1.getZ()) - 1, pos, PurpurConfig.lightningRodRange, PoiManager.Occupancy.ANY);
        return optional.map(blockposition1 -> blockposition1.above(1));
    }

    protected BlockPos findLightningTargetAround(BlockPos pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPos findLightningTargetAround(BlockPos pos, boolean returnNullWhenNoTarget) {
        BlockPos blockposition1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
        Optional<BlockPos> optional = this.findLightningRod(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AABB axisalignedbb = AABB.encapsulatingFullBlocks(blockposition1, blockposition1.atY(this.getMaxY() + 1)).inflate(3.0);
        List<LivingEntity> list = this.getEntitiesOfClass(LivingEntity.class, axisalignedbb, entityliving -> entityliving != null && entityliving.isAlive() && this.canSeeSky(entityliving.blockPosition()) && !entityliving.isSpectator());
        if (!list.isEmpty()) {
            return list.get(this.random.nextInt(list.size())).blockPosition();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.getY() == this.getMinY() - 1) {
            blockposition1 = blockposition1.above(2);
        }
        return blockposition1;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        if (this.canSleepThroughNights() && (!this.getServer().isSingleplayer() || this.getServer().isPublished())) {
            Component ichatmutablecomponent;
            int i = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
            if (this.sleepStatus.areEnoughSleeping(i)) {
                if (PurpurConfig.sleepSkippingNight.isBlank()) {
                    return;
                }
                ichatmutablecomponent = !PurpurConfig.sleepSkippingNight.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.sleepSkippingNight)) : Component.translatable("sleep.skipping_night");
            } else {
                if (PurpurConfig.sleepingPlayersPercent.isBlank()) {
                    return;
                }
                ichatmutablecomponent = !PurpurConfig.sleepingPlayersPercent.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize(PurpurConfig.sleepingPlayersPercent, new TagResolver[]{Placeholder.parsed((String)"count", (String)Integer.toString(this.sleepStatus.amountSleeping())), Placeholder.parsed((String)"total", (String)Integer.toString(this.sleepStatus.sleepersNeeded(i)))})) : Component.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded(i));
            }
            for (ServerPlayer entityplayer : this.players) {
                entityplayer.displayClientMessage(ichatmutablecomponent, true);
            }
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ServerScoreboard getScoreboard() {
        return this.server.getScoreboard();
    }

    private void advanceWeatherCycle() {
        int idx;
        boolean flag = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int i = this.serverLevelData.getClearWeatherTime();
                int j = this.serverLevelData.getThunderTime();
                int k = this.serverLevelData.getRainTime();
                boolean flag1 = this.levelData.isThundering();
                boolean flag2 = this.levelData.isRaining();
                if (i > 0) {
                    --i;
                    j = flag1 ? 0 : 1;
                    k = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j > 0) {
                        if (--j == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j = flag1 ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if (k > 0) {
                        if (--k == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k = flag2 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.serverLevelData.setThunderTime(j);
                this.serverLevelData.setRainTime(k);
                this.serverLevelData.setClearWeatherTime(i);
                this.serverLevelData.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.serverLevelData.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = Mth.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = Mth.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).tickWeather();
        }
        if (flag != this.isRaining()) {
            for (idx = 0; idx < this.players.size(); ++idx) {
                if (this.players.get(idx).level() != this) continue;
                this.players.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).updateWeather(this.oRainLevel, this.rainLevel, this.oThunderLevel, this.thunderLevel);
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        if (this.purpurConfig.rainStopsAfterSleep) {
            this.serverLevelData.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        }
        if (!this.serverLevelData.isRaining()) {
            this.serverLevelData.setRainTime(0);
        }
        if (this.purpurConfig.thunderStopsAfterSleep) {
            this.serverLevelData.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        }
        if (!this.serverLevelData.isThundering()) {
            this.serverLevelData.setThunderTime(0);
        }
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPos pos, Fluid fluid) {
        BlockState iblockdata = this.getBlockState(pos);
        FluidState fluid1 = iblockdata.getFluidState();
        if (fluid1.is(fluid)) {
            fluid1.tick(this, pos, iblockdata);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.server.moonrise$executeMidTickTasks();
        }
    }

    private void tickBlock(BlockPos pos, Block block) {
        BlockState iblockdata = this.getBlockState(pos);
        if (iblockdata.is(block)) {
            iblockdata.tick(this, pos, this.random);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.server.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickNonPassenger(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.setOldPosAndRot();
            ProfilerFiller gameprofilerfiller = Profiler.get();
            ++entity.tickCount;
            gameprofilerfiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString());
            gameprofilerfiller.incrementCounter("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.tick();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            gameprofilerfiller.pop();
            for (net.minecraft.world.entity.Entity entity1 : entity.getPassengers()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger, boolean isActive) {
        if (!passenger.isRemoved() && passenger.getVehicle() == vehicle) {
            if (passenger instanceof Player || this.entityTickList.contains(passenger)) {
                passenger.setOldPosAndRot();
                ++passenger.tickCount;
                ProfilerFiller gameprofilerfiller = Profiler.get();
                gameprofilerfiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(passenger.getType()).toString());
                gameprofilerfiller.incrementCounter("tickPassenger");
                if (isActive) {
                    passenger.rideTick();
                    passenger.postTick();
                } else {
                    passenger.setDeltaMovement(Vec3.ZERO);
                    passenger.inactiveTick();
                    vehicle.positionRider(passenger);
                }
                gameprofilerfiller.pop();
                for (net.minecraft.world.entity.Entity entity2 : passenger.getPassengers()) {
                    this.tickPassenger(passenger, entity2, isActive);
                }
            }
        } else {
            passenger.stopRiding();
        }
    }

    @Override
    public boolean mayInteract(Player player, BlockPos pos) {
        return !this.server.isUnderSpawnProtection(this, pos, player) && this.getWorldBorder().isWithinBounds(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ServerChunkCache chunkproviderserver = this.getChunkSource();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.saveLevelData(true);
        }
        if (doFull) {
            ServerLevel worldserver1 = this;
            this.serverLevelData.setWorldBorder(worldserver1.getWorldBorder().createSettings());
            this.serverLevelData.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
            this.convertable.saveDataTag(this.server.registryAccess(), this.serverLevelData, this.server.getPlayerList().getSingleplayerData());
        }
    }

    public void save(@Nullable ProgressListener progressListener, boolean flush, boolean savingDisabled) {
        this.save(progressListener, flush, savingDisabled, false);
    }

    public void save(@Nullable ProgressListener progressListener, boolean flush, boolean savingDisabled, boolean close) {
        ServerChunkCache chunkproviderserver = this.getChunkSource();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progressListener != null) {
                progressListener.progressStartNoAbort(Component.translatable("menu.savingLevel"));
            }
            this.saveLevelData(flush);
            if (progressListener != null) {
                progressListener.progressStage(Component.translatable("menu.savingChunks"));
            }
            if (!close) {
                chunkproviderserver.save(flush);
            }
        }
        if (close) {
            try {
                chunkproviderserver.close(!savingDisabled);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        ServerLevel worldserver1 = this;
        this.serverLevelData.setWorldBorder(worldserver1.getWorldBorder().createSettings());
        this.serverLevelData.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
        this.convertable.saveDataTag(this.server.registryAccess(), this.serverLevelData, this.server.getPlayerList().getSingleplayerData());
    }

    private void saveLevelData(boolean flush) {
        if (this.dragonFight != null) {
            this.serverLevelData.setEndDragonFightData(this.dragonFight.saveData());
        }
        DimensionDataStorage worldpersistentdata = this.getChunkSource().getDataStorage();
        if (flush) {
            worldpersistentdata.saveAndJoin();
        } else {
            worldpersistentdata.scheduleSave();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(filter, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result) {
        this.getEntities(filter, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result, int limit) {
        this.getEntities().get(filter, entity -> {
            if (predicate.test(entity)) {
                result.add((Object)entity);
                if (result.size() >= limit) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
    }

    public List<? extends EnderDragon> getDragons() {
        return this.getEntities(EntityType.ENDER_DRAGON, LivingEntity::isAlive);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate) {
        return this.getPlayers(predicate, Integer.MAX_VALUE);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> predicate, int limit) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer entityplayer : this.players) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < limit) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public ServerPlayer getRandomPlayer() {
        List<ServerPlayer> list = this.getPlayers(LivingEntity::isAlive);
        return list.isEmpty() ? null : list.get(this.random.nextInt(list.size()));
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            this.addPlayer(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void addNewPlayer(ServerPlayer player) {
        this.addPlayer(player);
    }

    public void addRespawnedPlayer(ServerPlayer player) {
        this.addPlayer(player);
    }

    private void addPlayer(ServerPlayer player) {
        net.minecraft.world.entity.Entity entity = this.getEntities().get(player.getUUID());
        if (entity != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)player.getUUID());
            entity.unRide();
            this.removePlayerImmediately((ServerPlayer)entity, Entity.RemovalReason.DISCARDED);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        ItemEntity itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.LOGGER.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.isRemoved()) {
            return false;
        }
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().isEmpty()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof ItemEntity) {
            this.captureDrops.add((ItemEntity)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.getSelfAndPassengers().map(net.minecraft.world.entity.Entity::getUUID).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void unload(LevelChunk chunk) {
        for (BlockEntity tileentity : chunk.getBlockEntities().values()) {
            if (!(tileentity instanceof Container)) continue;
            for (HumanEntity h : Lists.newArrayList(((Container)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.clearAllBlockEntities();
        chunk.unregisterTickContainerFromLevel(this);
    }

    public void removePlayerImmediately(ServerPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.addFreshEntity(entitylightning);
    }

    @Override
    public void destroyBlockProgress(int entityId, BlockPos pos, int progress) {
        Iterator<ServerPlayer> iterator = this.server.getPlayerList().getPlayers().iterator();
        Player entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.getEntity(entityId);
        if (entity instanceof Player) {
            entityhuman = (Player)entity;
        }
        if (entity != null) {
            float progressFloat = (float)Mth.clamp(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        while (iterator.hasNext()) {
            ServerPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.level() != this || entityplayer.getId() == entityId) continue;
            double d0 = (double)pos.getX() - entityplayer.getX();
            double d1 = (double)pos.getY() - entityplayer.getY();
            double d2 = (double)pos.getZ() - entityplayer.getZ();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.connection.send(new ClientboundBlockDestructionPacket(entityId, pos, progress));
        }
    }

    @Override
    public void playSeededSound(@Nullable Player source, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
        this.server.getPlayerList().broadcast(source, x, y, z, sound.value().getRange(volume), this.dimension(), new ClientboundSoundPacket(sound, category, x, y, z, volume, pitch, seed));
    }

    @Override
    public void playSeededSound(@Nullable Player source, net.minecraft.world.entity.Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
        this.server.getPlayerList().broadcast(source, entity.getX(), entity.getY(), entity.getZ(), sound.value().getRange(volume), this.dimension(), new ClientboundSoundEntityPacket(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void globalLevelEvent(int eventId, BlockPos pos, int data) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().getPlayers().forEach(entityplayer -> {
                Vec3 vec3d;
                if (entityplayer.level() == this) {
                    Vec3 vec3d1 = Vec3.atCenterOf(pos);
                    if (entityplayer.distanceToSqr(vec3d1) < (double)Mth.square(32)) {
                        vec3d = vec3d1;
                    } else {
                        Vec3 vec3d2 = vec3d1.subtract(entityplayer.position()).normalize();
                        vec3d = entityplayer.position().add(vec3d2.scale(32.0));
                    }
                } else {
                    vec3d = entityplayer.position();
                }
                entityplayer.connection.send(new ClientboundLevelEventPacket(eventId, BlockPos.containing(vec3d), data, true));
            });
        } else {
            this.levelEvent(null, eventId, pos, data);
        }
    }

    @Override
    public void levelEvent(@Nullable Player player, int eventId, BlockPos pos, int data) {
        this.server.getPlayerList().broadcast(player, pos.getX(), pos.getY(), pos.getZ(), 64.0, this.dimension(), new ClientboundLevelEventPacket(eventId, pos, data, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> event, Vec3 emitterPos, GameEvent.Context emitter) {
        if (this.getChunkIfLoadedImmediately(Mth.floor(emitterPos.x) >> 4, Mth.floor(emitterPos.z) >> 4) == null) {
            return;
        }
        this.gameEventDispatcher.post(event, emitterPos, emitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.isUpdatingNavigations) {
            String s = "recursive call to sendBlockUpdated";
            Util.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(pos);
        this.pathTypesByPosCache.invalidate(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && Shapes.joinIsNotEmpty(voxelshape = oldState.getCollisionShape(this, pos), voxelshape1 = newState.getCollisionShape(this, pos), BooleanOp.NOT_SAME)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<Mob> iterator = this.navigatingMobs.iterator();
            while (iterator.hasNext()) {
                Mob entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.sendBlockUpdated(pos, oldState, newState, flags);
                    return;
                }
                PathNavigation navigationabstract = entityinsentient.getNavigation();
                if (!navigationabstract.shouldRecomputePath(pos)) continue;
                list.add(navigationabstract);
            }
            try {
                this.isUpdatingNavigations = true;
                for (PathNavigation navigationabstract1 : list) {
                    navigationabstract1.recomputePath();
                }
            }
            finally {
                this.isUpdatingNavigations = false;
            }
        }
    }

    @Override
    public void updateNeighborsAt(BlockPos pos, Block block) {
        if (this.captureBlockStates) {
            return;
        }
        this.updateNeighborsAt(pos, block, ExperimentalRedstoneUtils.initialOrientation(this, null, null));
    }

    @Override
    public void updateNeighborsAt(BlockPos pos, Block sourceBlock, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(pos, sourceBlock, null, orientation);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block sourceBlock, Direction direction, @Nullable Orientation orientation) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(pos, sourceBlock, direction, orientation);
    }

    @Override
    public void neighborChanged(BlockPos pos, Block sourceBlock, @Nullable Orientation orientation) {
        this.neighborUpdater.neighborChanged(pos, sourceBlock, orientation);
    }

    @Override
    public void neighborChanged(BlockState state, BlockPos pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify) {
        this.neighborUpdater.neighborChanged(state, pos, sourceBlock, orientation, notify);
    }

    @Override
    public void broadcastEntityEvent(net.minecraft.world.entity.Entity entity, byte status) {
        this.getChunkSource().broadcastAndSend(entity, new ClientboundEntityEventPacket(entity, status));
    }

    @Override
    public void broadcastDamageEvent(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.getChunkSource().broadcastAndSend(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    @Override
    public ServerChunkCache getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public void explode(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, Level.ExplosionInteraction explosionSourceType, ParticleOptions smallParticle, ParticleOptions largeParticle, Holder<SoundEvent> soundEvent) {
        this.explode0(entity, damageSource, behavior, x, y, z, power, createFire, explosionSourceType, smallParticle, largeParticle, soundEvent);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f, boolean flag, Level.ExplosionInteraction world_a, ParticleOptions particleparam, ParticleOptions particleparam1, Holder<SoundEvent> holder) {
        return this.explode0(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f, flag, world_a, particleparam, particleparam1, holder, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f, boolean flag, Level.ExplosionInteraction world_a, ParticleOptions particleparam, ParticleOptions particleparam1, Holder<SoundEvent> holder, Consumer<ServerExplosion> configurator) {
        Explosion.BlockInteraction explosion_effect1 = switch (world_a) {
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY) : Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.TNT -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
            case Level.ExplosionInteraction.STANDARD -> Explosion.BlockInteraction.DESTROY;
            default -> throw new MatchException(null, null);
        };
        Vec3 vec3d = new Vec3(d0, d1, d2);
        ServerExplosion serverexplosion = new ServerExplosion(this, entity, damagesource, explosiondamagecalculator, vec3d, f, flag, explosion_effect1);
        if (configurator != null) {
            configurator.accept(serverexplosion);
        }
        serverexplosion.explode();
        if (serverexplosion.wasCanceled) {
            return serverexplosion;
        }
        ParticleOptions particleparam2 = serverexplosion.isSmall() ? particleparam : particleparam1;
        for (ServerPlayer entityplayer : this.players) {
            if (!(entityplayer.distanceToSqr(vec3d) < 4096.0)) continue;
            Optional<Vec3> optional = Optional.ofNullable(serverexplosion.getHitPlayers().get(entityplayer));
            entityplayer.connection.send(new ClientboundExplodePacket(vec3d, optional, particleparam2, holder));
        }
        return serverexplosion;
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> decayRule) {
        return this.getGameRules().getBoolean(decayRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    @Override
    public void blockEvent(BlockPos pos, Block block, int type, int data) {
        this.blockEvents.add((Object)new BlockEventData(pos, block, type, data));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockEventData blockactiondata = (BlockEventData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt(blockactiondata.pos())) {
                if (!this.doBlockEvent(blockactiondata)) continue;
                this.server.getPlayerList().broadcast(null, blockactiondata.pos().getX(), blockactiondata.pos().getY(), blockactiondata.pos().getZ(), 64.0, this.dimension(), new ClientboundBlockEventPacket(blockactiondata.pos(), blockactiondata.block(), blockactiondata.paramA(), blockactiondata.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add(blockactiondata);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockEventData event) {
        BlockState iblockdata = this.getBlockState(event.pos());
        return iblockdata.is(event.block()) ? iblockdata.triggerEvent(this, event.pos(), event.paramA(), event.paramB()) : false;
    }

    public LevelTicks<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public LevelTicks<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalForcer getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleOptions> int sendParticles(T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x, y, z, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleOptions> int sendParticles(ServerPlayer sender, T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.players, sender, t0, d0, d1, d2, i, d3, d4, d5, d6, force);
    }

    public <T extends ParticleOptions> int sendParticles(List<ServerPlayer> receivers, @Nullable ServerPlayer sender, T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6, boolean force) {
        ClientboundLevelParticlesPacket packetplayoutworldparticles = new ClientboundLevelParticlesPacket(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        int j = 0;
        for (Player player : receivers) {
            ServerPlayer entityplayer = (ServerPlayer)player;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.sendParticles(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j;
        }
        return j;
    }

    public <T extends ParticleOptions> boolean sendParticles(ServerPlayer viewer, T particle, boolean force, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particle, force, x, y, z, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.sendParticles(viewer, force, x, y, z, packet);
    }

    private boolean sendParticles(ServerPlayer player, boolean force, double x, double y, double z, Packet<?> packet) {
        if (player.level() != this) {
            return false;
        }
        BlockPos blockposition = player.blockPosition();
        if (blockposition.closerToCenterThan(new Vec3(x, y, z), force ? 512.0 : 32.0)) {
            player.connection.send(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity getEntity(int id) {
        return this.getEntities().get(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity getEntityOrPart(int id) {
        net.minecraft.world.entity.Entity entity = this.getEntities().get(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.dragonParts.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity getEntity(UUID uuid) {
        return this.getEntities().get(uuid);
    }

    @Nullable
    public BlockPos findNearestMapStructure(TagKey<Structure> structureTag, BlockPos pos, int radius, boolean skipReferencedStructures) {
        if (!this.serverLevelData.worldGenOptions().generateStructures()) {
            return null;
        }
        Optional optional = this.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> pair = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet)optional.get(), pos, radius, skipReferencedStructures);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(Predicate<Holder<Biome>> predicate, BlockPos pos, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(pos, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public RecipeManager recipeAccess() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public DimensionDataStorage getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public MapItemSavedData getMapData(MapId id) {
        DimensionDataStorage storage = this.getServer().overworld().getDataStorage();
        Optional<SavedData> cacheEntry = storage.cache.get(id.key());
        if (cacheEntry == null) {
            MapItemSavedData worldmap = storage.get(MapItemSavedData.factory(), id.key());
            if (worldmap != null) {
                worldmap.id = id;
                new MapInitializeEvent((MapView)worldmap.mapView).callEvent();
                return worldmap;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof MapItemSavedData) {
            MapItemSavedData mapItemSavedData = var5_6;
            mapItemSavedData.id = id;
            return mapItemSavedData;
        }
        return null;
    }

    @Override
    public void setMapData(MapId id, MapItemSavedData state) {
        state.id = id;
        MapInitializeEvent event = new MapInitializeEvent((MapView)state.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getServer().overworld().getDataStorage().set(id.key(), state);
    }

    @Override
    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(MapIndex.factory(), "idcounts").getFreeAuxValueForMap();
    }

    public void setDefaultSpawnPos(BlockPos pos, float angle) {
        int i;
        BlockPos blockposition1 = this.levelData.getSpawnPos();
        float f1 = this.levelData.getSpawnAngle();
        if (!blockposition1.equals(pos) || f1 != angle) {
            Location prevSpawnLoc = this.getWorld().getSpawnLocation();
            this.levelData.setSpawn(pos, angle);
            new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
            this.getServer().getPlayerList().broadcastAll(new ClientboundSetDefaultSpawnPositionPacket(pos, angle));
        }
        if (this.lastSpawnChunkRadius > 1) {
            for (ChunkPos chunkPos : MCUtil.getSpiralOutChunks(blockposition1, this.lastSpawnChunkRadius - 2)) {
                this.getChunkSource().removeTicketAtLevel(TicketType.START, chunkPos, 31, Unit.INSTANCE);
            }
        }
        if ((i = this.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS) + 1) > 1) {
            for (ChunkPos chunkPos : MCUtil.getSpiralOutChunks(pos, i - 2)) {
                this.getChunkSource().addTicketAtLevel(TicketType.START, chunkPos, 31, Unit.INSTANCE);
            }
        }
        this.lastSpawnChunkRadius = i;
    }

    public LongSet getForcedChunks() {
        ForcedChunksSavedData forcedchunk = this.getDataStorage().get(ForcedChunksSavedData.factory(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.getChunks()) : LongSets.EMPTY_SET;
    }

    public boolean setChunkForced(int x, int z, boolean forced) {
        boolean flag1;
        ForcedChunksSavedData forcedchunk = this.getDataStorage().computeIfAbsent(ForcedChunksSavedData.factory(), "chunks");
        ChunkPos chunkcoordintpair = new ChunkPos(x, z);
        long k = chunkcoordintpair.toLong();
        if (forced) {
            flag1 = forcedchunk.getChunks().add(k);
            if (flag1) {
                this.getChunk(x, z);
            }
        } else {
            flag1 = forcedchunk.getChunks().remove(k);
        }
        forcedchunk.setDirty(flag1);
        if (flag1) {
            this.getChunkSource().updateChunkForced(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<ServerPlayer> players() {
        return this.players;
    }

    @Override
    public void onBlockStateChange(BlockPos pos, BlockState oldBlock, BlockState newBlock) {
        Optional<Holder<PoiType>> optional1;
        Optional<Holder<PoiType>> optional = PoiTypes.forState(oldBlock);
        if (!Objects.equals(optional, optional1 = PoiTypes.forState(newBlock))) {
            BlockPos blockposition1 = pos.immutable();
            optional.ifPresent(holder -> this.getServer().execute(() -> {
                this.getPoiManager().remove(blockposition1);
                DebugPackets.sendPoiRemovedPacket(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.getServer().execute(() -> {
                if (optional.isEmpty() && this.getPoiManager().exists(blockposition1, poiType -> true)) {
                    this.getPoiManager().remove(blockposition1);
                }
                this.getPoiManager().add(blockposition1, (Holder<PoiType>)holder);
                DebugPackets.sendPoiAddedPacket(this, blockposition1);
            }));
        }
    }

    public PoiManager getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPos pos) {
        return this.isCloseToVillage(pos, 1);
    }

    public boolean isVillage(SectionPos sectionPos) {
        return this.isVillage(sectionPos.center());
    }

    public boolean isCloseToVillage(BlockPos pos, int maxDistance) {
        return maxDistance > 6 ? false : this.sectionsToVillage(SectionPos.of(pos)) <= maxDistance;
    }

    public int sectionsToVillage(SectionPos pos) {
        return this.getPoiManager().sectionsToVillage(pos);
    }

    public Raids getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPos pos) {
        return this.raids.getNearbyRaid(pos, 9216);
    }

    public boolean isRaided(BlockPos pos) {
        return this.getRaidAt(pos) != null;
    }

    public void onReputationEvent(ReputationEventType interaction, net.minecraft.world.entity.Entity entity, ReputationEventHandler observer) {
        observer.onReputationEventFrom(interaction, entity);
    }

    public void saveDebugReport(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedwriter3;
        ChunkMap playerchunkmap = this.getChunkSource().chunkMap;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.getDistanceManager().getNaturalSpawnChunkCount()));
            NaturalSpawner.SpawnState spawnercreature_d = this.getChunkSource().getLastSpawnState();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.getMobCategoryCounts().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((MobCategory)entry.getKey()).getName(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", ((LevelTicks)this.getBlockTicks()).count()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((LevelTicks)this.getFluidTicks()).count()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.getDistanceManager().getDebugStatus() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.getFriendlyReport(ReportType.TEST));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedwriter2 != null) {
            bufferedwriter2.close();
        }
        if ((bufferedwriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            bufferedwriter3.close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            ServerLevel.dumpEntities(bufferedwriter4, this.getEntities().getAll());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.dumpBlockEntityTickers(bufferedwriter5);
        }
    }

    private static void dumpEntities(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            Component ichatbasecomponent = entity.getCustomName();
            Component ichatbasecomponent1 = entity.getDisplayName();
            csvwriter.writeRow(entity.getX(), entity.getY(), entity.getZ(), entity.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()), entity.isAlive(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(writer);
        for (TickingBlockEntity tickingblockentity : this.blockEntityTickers) {
            BlockPos blockposition = tickingblockentity.getPos();
            csvwriter.writeRow(blockposition.getX(), blockposition.getY(), blockposition.getZ(), tickingblockentity.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(BoundingBox box) {
        this.blockEvents.removeIf(blockactiondata -> box.isInside(blockactiondata.pos()));
    }

    @Override
    public void blockUpdated(BlockPos pos, Block block) {
        if (!this.isDebug()) {
            if (this.populating) {
                return;
            }
            this.updateNeighborsAt(pos, block);
        }
    }

    @Override
    public float getShade(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.serverLevelData.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.serverLevelData.isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.serverLevelData.worldGenOptions().seed();
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public ServerLevel getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.moonrise$getEntityLookup().getDebugInfo(), ServerLevel.getTypeCount(this.moonrise$getEntityLookup().getAll(), entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString()), this.blockEntityTickers.size(), ServerLevel.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((LevelTicks)this.getBlockTicks()).count(), ((LevelTicks)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> getEntities() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkPos chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkPos chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void startTickingChunk(LevelChunk chunk) {
        chunk.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(ChunkAccess chunk) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        String s = this.chunkSource.gatherStats();
        return "Chunks[S] W: " + s + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean areEntitiesLoaded(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    private boolean isPositionTickingWithEntitiesLoaded(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean isPositionEntityTicking(BlockPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean isNaturalSpawningAllowed(BlockPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean isNaturalSpawningAllowed(ChunkPos pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewing potionBrewing() {
        return this.server.potionBrewing();
    }

    @Override
    public FuelValues fuelValues() {
        return this.server.fuelValues();
    }

    public RandomSource getRandomSequence(ResourceLocation id) {
        return this.randomSequences.get(id);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    public GameRules getGameRules() {
        return this.serverLevelData.getGameRules();
    }

    public List<ServerPlayer> getPlayersForGlobalSoundGamerule() {
        return this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) ? this.getServer().getPlayerList().players : this.players();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    public void checkCapturedTreeStateForObserverNotify(BlockPos pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().getY() == pos.getY() && this.getBlockState(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlag(), 512);
        }
    }

    @Override
    public CrashReportCategory fillReportDetails(CrashReport report) {
        CrashReportCategory crashreportsystemdetails = super.fillReportDetails(report);
        crashreportsystemdetails.setDetail("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashreportsystemdetails;
    }

    @Override
    public int getSeaLevel() {
        return this.chunkSource.getGenerator().getSeaLevel();
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public Player getGlobalPlayerByUUID(UUID uuid) {
        return this.server.getPlayerList().getPlayer(uuid);
    }

    private final class EntityCallbacks
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        EntityCallbacks() {
        }

        @Override
        public void onCreated(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void onDestroyed(net.minecraft.world.entity.Entity entity) {
            ServerLevel.this.getScoreboard().entityRemoved(entity);
        }

        @Override
        public void onTickingStart(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !ServerLevel.this.paperConfig().entities.markers.tick) {
                return;
            }
            ServerLevel.this.entityTickList.add(entity);
        }

        @Override
        public void onTickingEnd(net.minecraft.world.entity.Entity entity) {
            ServerLevel.this.entityTickList.remove(entity);
            if (ServerLevel.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && ServerLevel.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof ThrownEnderpearl) {
                ThrownEnderpearl pearl = (ThrownEnderpearl)entity;
                pearl.cachedOwner = null;
                pearl.ownerUUID = null;
            }
        }

        @Override
        public void onTrackingStart(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                ServerLevel.this.players.add(entityplayer);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                ServerLevel.this.navigatingMobs.add(entityinsentient);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                for (EnderDragonPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.put(entitycomplexpart.getId(), (Object)entitycomplexpart);
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::add);
            entity.inWorld = true;
            entity.valid = true;
            ServerLevel.this.getChunkSource().addEntity(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)ServerLevel.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)ServerLevel.this.getWorld()).callEvent();
        }

        @Override
        public void onTrackingEnd(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof Player) {
                Streams.stream(ServerLevel.this.getServer().getAllLevels()).map(ServerLevel::getDataStorage).forEach(worldData -> {
                    for (Optional<SavedData> o : worldData.cache.values()) {
                        if (!(o instanceof MapItemSavedData)) continue;
                        MapItemSavedData map = (MapItemSavedData)((Object)o);
                        map.carriedByPlayers.remove((Player)entity);
                        Iterator<MapItemSavedData.HoldingPlayer> iter = map.carriedBy.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().player != entity) continue;
                            map.decorations.remove(entity.getName().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof ServerPlayer) || entity.getRemovalReason() != Entity.RemovalReason.KILLED)) {
                Merchant merchant;
                CraftEntity craftEntity;
                if (!entity.level().purpurConfig.playerVoidTrading && (craftEntity = entity.getBukkitEntity()) instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            ServerLevel.this.getChunkSource().removeEntity(entity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                ServerLevel.this.players.remove(entityplayer);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                ServerLevel.this.navigatingMobs.remove(entityinsentient);
            }
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                for (EnderDragonPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    ServerLevel.this.dragonParts.remove(entitycomplexpart.getId());
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::remove);
            entity.valid = false;
            if (!(entity instanceof ServerPlayer)) {
                for (ServerPlayer player : ServerLevel.this.server.getPlayerList().players) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)ServerLevel.this.getWorld()).callEvent();
        }

        @Override
        public void onSectionChange(net.minecraft.world.entity.Entity entity) {
            entity.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }
    }
}

