/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ServerItemCooldowns;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EndGatewayBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.CraftWorldBorder;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.event.CraftPortalEvent;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.PlayerAFKEvent;
import org.slf4j.Logger;

public class ServerPlayer
extends Player
implements ChunkSystemServerPlayer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public static final double BLOCK_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 1.0;
    public static final double ENTITY_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 3.0;
    public static final int ENDER_PEARL_TICKET_RADIUS = 2;
    public static final String ENDER_PEARLS_TAG = "ender_pearls";
    public static final String ENDER_PEARL_DIMENSION_TAG = "ender_pearl_dimension";
    private static final AttributeModifier CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_block_range"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public ServerGamePacketListenerImpl connection;
    public final MinecraftServer server;
    public final ServerPlayerGameMode gameMode;
    private final PlayerAdvancements advancements;
    private final ServerStatsCounter stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    public int lastSentExp = -99999999;
    public int spawnInvulnerableTime = 60;
    private ChatVisiblity chatVisibility;
    public ParticleStatus particleStatus;
    private boolean canChatColor = true;
    private long lastActionTime;
    @Nullable
    private net.minecraft.world.entity.Entity camera;
    public boolean isChangingDimension;
    public boolean seenCredits;
    private final ServerRecipeBook recipeBook;
    @Nullable
    private Vec3 levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    public String language = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3 startingToFallPosition;
    @Nullable
    private Vec3 enteredNetherPosition;
    @Nullable
    private Vec3 enteredLavaOnVehiclePosition;
    private SectionPos lastSectionPos;
    private ChunkTrackingView chunkTrackingView;
    private ResourceKey<Level> respawnDimension;
    @Nullable
    private BlockPos respawnPosition;
    private boolean respawnForced;
    private float respawnAngle;
    private final TextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private boolean spawnExtraParticlesOnFall;
    public WardenSpawnTracker wardenSpawnTracker;
    @Nullable
    private BlockPos raidOmenPosition;
    private Vec3 lastKnownClientMovement;
    private Input lastClientInput;
    private final Set<ThrownEnderpearl> enderPearls;
    public final ContainerSynchronizer containerSynchronizer;
    private final ContainerListener containerListener;
    @Nullable
    private RemoteChatSession chatSession;
    @Nullable
    public final Object object;
    private final CommandSource commandSource;
    private int containerCounter;
    public boolean wonGame;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public ClientboundSetHealthPacket queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = MobCategory.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    public net.minecraft.network.chat.Component listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    public boolean purpurClient = false;
    private boolean tpsBar = false;
    private boolean compassBar = false;
    private boolean ramBar = false;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private boolean isAfk = false;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public ServerPlayer(MinecraftServer server, ServerLevel world, GameProfile profile, ClientInformation clientOptions) {
        super(world, world.getSharedSpawnPos(), world.getSharedSpawnAngle(), profile);
        this.chatVisibility = ChatVisiblity.FULL;
        this.particleStatus = ParticleStatus.ALL;
        this.lastActionTime = Util.getMillis();
        this.lastSectionPos = SectionPos.of(0, 0, 0);
        this.chunkTrackingView = ChunkTrackingView.EMPTY;
        this.respawnDimension = Level.OVERWORLD;
        this.wardenSpawnTracker = new WardenSpawnTracker(0, 0, 0);
        this.lastKnownClientMovement = Vec3.ZERO;
        this.lastClientInput = Input.EMPTY;
        this.enderPearls = new HashSet<ThrownEnderpearl>();
        this.containerSynchronizer = new ContainerSynchronizer(){

            @Override
            public void sendInitialData(AbstractContainerMenu handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                ServerPlayer.this.connection.send(new ClientboundContainerSetContentPacket(handler.containerId, handler.incrementStateId(), stacks, cursorStack));
                for (int i = 0; i < properties.length; ++i) {
                    this.broadcastDataValue(handler, i, properties[i]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(ServerPlayer.this.inventoryMenu.containerId, ServerPlayer.this.inventoryMenu.incrementStateId(), 45, ServerPlayer.this.inventoryMenu.getSlot(45).getItem().copy()));
            }

            @Override
            public void sendSlotChange(AbstractContainerMenu handler, int slot, ItemStack stack) {
                ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(handler.containerId, handler.incrementStateId(), slot, stack));
            }

            @Override
            public void sendCarriedChange(AbstractContainerMenu handler, ItemStack stack) {
                ServerPlayer.this.connection.send(new ClientboundSetCursorItemPacket(stack.copy()));
            }

            @Override
            public void sendDataChange(AbstractContainerMenu handler, int property, int value) {
                this.broadcastDataValue(handler, property, value);
            }

            private void broadcastDataValue(AbstractContainerMenu handler, int property, int value) {
                ServerPlayer.this.connection.send(new ClientboundContainerSetDataPacket(handler.containerId, property, value));
            }
        };
        this.containerListener = new ContainerListener(){

            @Override
            public void slotChanged(AbstractContainerMenu handler, int slotId, ItemStack stack) {
                Slot slot = handler.getSlot(slotId);
                if (!(slot instanceof ResultSlot) && slot.container == ServerPlayer.this.getInventory()) {
                    CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
                }
            }

            @Override
            public void slotChanged(AbstractContainerMenu handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.getSlot(slotId);
                if (!(slot instanceof ResultSlot) && slot.container == ServerPlayer.this.getInventory()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((org.bukkit.entity.Player)ServerPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
                    }
                }
            }

            @Override
            public void dataChanged(AbstractContainerMenu handler, int property, int value) {
            }
        };
        this.commandSource = new CommandSource(){

            @Override
            public boolean acceptsSuccess() {
                return ServerPlayer.this.serverLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
            }

            @Override
            public boolean acceptsFailure() {
                return true;
            }

            @Override
            public boolean shouldInformAdmins() {
                return true;
            }

            @Override
            public void sendSystemMessage(net.minecraft.network.chat.Component message) {
                ServerPlayer.this.sendSystemMessage(message);
            }

            @Override
            public CommandSender getBukkitSender(CommandSourceStack wrapper) {
                return ServerPlayer.this.getBukkitEntity();
            }
        };
        this.textFilter = server.createTextFilterForPlayer(this);
        this.gameMode = server.createGameModeForPlayer(this);
        this.recipeBook = new ServerRecipeBook((resourcekey, consumer) -> server.getRecipeManager().listDisplaysForRecipe(resourcekey, consumer));
        this.server = server;
        this.stats = server.getPlayerList().getPlayerStats(this);
        this.advancements = server.getPlayerList().getPlayerAdvancements(this);
        this.updateOptionsNoEvents(clientOptions);
        this.object = null;
        this.displayName = this.getScoreboardName();
        this.adventure$displayName = Component.text((String)this.getScoreboardName());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.getMaxHealth();
    }

    @Deprecated
    public void resendItemInHands() {
        this.containerMenu.findSlot(this.getInventory(), this.getInventory().selected).ifPresent(s -> this.containerSynchronizer.sendSlotChange(this.containerMenu, s, this.getMainHandItem()));
        this.containerSynchronizer.sendSlotChange(this.inventoryMenu, 45, this.getOffhandItem());
    }

    public final BlockPos getSpawnPoint(ServerLevel worldserver) {
        BlockPos blockposition = worldserver.getSharedSpawnPos();
        if (worldserver.dimensionType().hasSkyLight() && worldserver.serverLevelData.getGameType() != GameType.ADVENTURE) {
            long k;
            long l;
            int i = Math.max(0, this.server.getSpawnRadius(worldserver));
            int j = Mth.floor(worldserver.getWorldBorder().getDistanceToBorder(blockposition.getX(), blockposition.getZ()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            int j1 = this.getCoprime(i1);
            int k1 = RandomSource.create().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i2 = (k1 + j1 * l1) % i1;
                int j2 = i2 % (i * 2 + 1);
                int k2 = i2 / (i * 2 + 1);
                BlockPos blockposition1 = PlayerRespawnLogic.getOverworldRespawnPos(worldserver, blockposition.getX() + j2 - i, blockposition.getZ() + k2 - i);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPos adjustSpawnLocation(ServerLevel world, BlockPos basePos) {
        AABB axisalignedbb = this.getDimensions(Pose.STANDING).makeBoundingBox(Vec3.ZERO);
        BlockPos blockposition1 = basePos;
        if (world.dimensionType().hasSkyLight() && world.serverLevelData.getGameType() != GameType.ADVENTURE) {
            long k;
            long l;
            int i = Math.max(0, this.server.getSpawnRadius(world));
            int j = Mth.floor(world.getWorldBorder().getDistanceToBorder(basePos.getX(), basePos.getZ()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            int j1 = this.getCoprime(i1);
            int k1 = RandomSource.create().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i2 = (k1 + j1 * l1) % i1;
                int j2 = i2 % (i * 2 + 1);
                int k2 = i2 / (i * 2 + 1);
                int l2 = basePos.getX() + j2 - i;
                int i3 = basePos.getZ() + k2 - i;
                try {
                    blockposition1 = PlayerRespawnLogic.getOverworldRespawnPos(world, l2, i3);
                    if (blockposition1 == null || !this.noCollisionNoLiquid(world, axisalignedbb.move(blockposition1.getBottomCenter()))) continue;
                    return blockposition1;
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.forThrowable(exception, "Searching for spawn");
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Spawn Lookup");
                    Objects.requireNonNull(basePos);
                    crashreportsystemdetails.setDetail("Origin", basePos::toString);
                    int finalI = i;
                    crashreportsystemdetails.setDetail("Radius", () -> Integer.toString(finalI));
                    crashreportsystemdetails.setDetail("Candidate", () -> "[" + l2 + "," + i3 + "]");
                    int finalL1 = l1;
                    crashreportsystemdetails.setDetail("Progress", () -> finalL1 + " out of " + i1);
                    throw new ReportedException(crashreport);
                }
            }
            blockposition1 = basePos;
        }
        while (!this.noCollisionNoLiquid(world, axisalignedbb.move(blockposition1.getBottomCenter())) && blockposition1.getY() < world.getMaxY()) {
            blockposition1 = blockposition1.above();
        }
        while (this.noCollisionNoLiquid(world, axisalignedbb.move(blockposition1.below().getBottomCenter())) && blockposition1.getY() > world.getMinY() + 1) {
            blockposition1 = blockposition1.below();
        }
        return blockposition1;
    }

    private boolean noCollisionNoLiquid(ServerLevel world, AABB box) {
        return world.noCollision(this, box, true);
    }

    private int getCoprime(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        Logger logger;
        DataResult dataresult;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("warden_spawn_tracker", 10)) {
            dataresult = WardenSpawnTracker.CODEC.parse(new Dynamic<Tag>(NbtOps.INSTANCE, nbt.get("warden_spawn_tracker")));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.wardenSpawnTracker = wardenspawntracker;
            });
        }
        if (nbt.contains("enteredNetherPosition", 10)) {
            CompoundTag nbttagcompound1 = nbt.getCompound("enteredNetherPosition");
            this.enteredNetherPosition = new Vec3(nbttagcompound1.getDouble("x"), nbttagcompound1.getDouble("y"), nbttagcompound1.getDouble("z"));
        }
        this.seenCredits = nbt.getBoolean("seenCredits");
        if (nbt.contains("recipeBook", 10)) {
            this.recipeBook.fromNbt(nbt.getCompound("recipeBook"), resourcekey -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)resourcekey).isPresent());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.getString("SpawnWorld")))) != null) {
            this.respawnDimension = oldWorld.getHandle().dimension();
        }
        if (nbt.contains("SpawnX", 99) && nbt.contains("SpawnY", 99) && nbt.contains("SpawnZ", 99)) {
            this.respawnPosition = new BlockPos(nbt.getInt("SpawnX"), nbt.getInt("SpawnY"), nbt.getInt("SpawnZ"));
            this.respawnForced = nbt.getBoolean("SpawnForced");
            this.respawnAngle = nbt.getFloat("SpawnAngle");
            if (nbt.contains("SpawnDimension")) {
                DataResult dataresult1 = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("SpawnDimension"));
                Logger logger1 = LOGGER;
                Objects.requireNonNull(logger1);
                this.respawnDimension = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(Level.OVERWORLD);
            }
        }
        this.spawnExtraParticlesOnFall = nbt.getBoolean("spawn_extra_particles_on_fall");
        Tag nbtbase = nbt.get("raid_omen_position");
        if (nbtbase != null) {
            dataresult = BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbtbase);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(blockposition -> {
                this.raidOmenPosition = blockposition;
            });
        }
        if (nbt.contains("Purpur.TPSBar")) {
            this.tpsBar = nbt.getBoolean("Purpur.TPSBar");
        }
        if (nbt.contains("Purpur.CompassBar")) {
            this.compassBar = nbt.getBoolean("Purpur.CompassBar");
        }
        if (nbt.contains("Purpur.RamBar")) {
            this.ramBar = nbt.getBoolean("Purpur.RamBar");
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        DataResult dataresult = WardenSpawnTracker.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.wardenSpawnTracker);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("warden_spawn_tracker", (Tag)nbtbase));
        this.storeGameTypes(nbt);
        nbt.putBoolean("seenCredits", this.seenCredits);
        if (this.enteredNetherPosition != null) {
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putDouble("x", this.enteredNetherPosition.x);
            nbttagcompound1.putDouble("y", this.enteredNetherPosition.y);
            nbttagcompound1.putDouble("z", this.enteredNetherPosition.z);
            nbt.put("enteredNetherPosition", nbttagcompound1);
        }
        this.saveParentVehicle(nbt);
        nbt.put("recipeBook", this.recipeBook.toNbt());
        nbt.putString("Dimension", this.level().dimension().location().toString());
        if (this.respawnPosition != null) {
            nbt.putInt("SpawnX", this.respawnPosition.getX());
            nbt.putInt("SpawnY", this.respawnPosition.getY());
            nbt.putInt("SpawnZ", this.respawnPosition.getZ());
            nbt.putBoolean("SpawnForced", this.respawnForced);
            nbt.putFloat("SpawnAngle", this.respawnAngle);
            dataresult = ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.respawnDimension.location());
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("SpawnDimension", (Tag)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
        nbt.putBoolean("spawn_extra_particles_on_fall", this.spawnExtraParticlesOnFall);
        if (this.raidOmenPosition != null) {
            dataresult = BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.raidOmenPosition);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("raid_omen_position", (Tag)nbtbase));
        }
        this.saveEnderPearls(nbt);
        nbt.putBoolean("Purpur.RamBar", this.ramBar);
        nbt.putBoolean("Purpur.TPSBar", this.tpsBar);
        nbt.putBoolean("Purpur.CompassBar", this.compassBar);
    }

    private void saveParentVehicle(CompoundTag nbt) {
        net.minecraft.world.entity.Entity entity = this.getRootVehicle();
        net.minecraft.world.entity.Entity entity1 = this.getVehicle();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.getVehicle()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.hasExactlyOnePlayerPassenger() && !entity.isRemoved()) {
            CompoundTag nbttagcompound1 = new CompoundTag();
            CompoundTag nbttagcompound2 = new CompoundTag();
            entity.save(nbttagcompound2);
            nbttagcompound1.putUUID("Attach", entity1.getUUID());
            nbttagcompound1.put("Entity", nbttagcompound2);
            nbt.put("RootVehicle", nbttagcompound1);
        }
    }

    public void loadAndSpawnParentVehicle(Optional<CompoundTag> nbt) {
        Level world;
        if (nbt.isPresent() && nbt.get().contains("RootVehicle", 10) && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            CompoundTag nbttagcompound = nbt.get().getCompound("RootVehicle");
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(nbttagcompound.getCompound("Entity"), worldserver, EntitySpawnReason.LOAD, entity1 -> !worldserver.addWithUUID((net.minecraft.world.entity.Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity == null) {
                return;
            }
            UUID uuid = nbttagcompound.hasUUID("Attach") ? nbttagcompound.getUUID("Attach") : null;
            if (entity.getUUID().equals(uuid)) {
                this.startRiding(entity, true);
            } else {
                for (net.minecraft.world.entity.Entity entity12 : entity.getIndirectPassengers()) {
                    if (!entity12.getUUID().equals(uuid)) continue;
                    this.startRiding(entity12, true);
                    break;
                }
            }
            if (!this.isPassenger()) {
                LOGGER.warn("Couldn't reattach entity to player");
                entity.discard(null);
                for (net.minecraft.world.entity.Entity entity12 : entity.getIndirectPassengers()) {
                    entity12.discard(null);
                }
            }
        }
    }

    private void saveEnderPearls(CompoundTag nbt) {
        if (!this.enderPearls.isEmpty()) {
            ListTag nbttaglist = new ListTag();
            for (ThrownEnderpearl entityenderpearl : this.enderPearls) {
                if (entityenderpearl.level().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (entityenderpearl.isRemoved()) {
                    LOGGER.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                CompoundTag nbttagcompound1 = new CompoundTag();
                entityenderpearl.save(nbttagcompound1);
                DataResult dataresult = ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entityenderpearl.level().dimension().location());
                Logger logger = LOGGER;
                Objects.requireNonNull(logger);
                dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound1.put(ENDER_PEARL_DIMENSION_TAG, (Tag)nbtbase));
                nbttaglist.add(nbttagcompound1);
            }
            nbt.put(ENDER_PEARLS_TAG, nbttaglist);
        }
    }

    public void loadAndSpawnEnderpearls(Optional<CompoundTag> nbt) {
        Tag nbtbase;
        if (nbt.isPresent() && nbt.get().contains(ENDER_PEARLS_TAG, 9) && (nbtbase = nbt.get().get(ENDER_PEARLS_TAG)) instanceof ListTag) {
            ListTag nbttaglist = (ListTag)nbtbase;
            nbttaglist.forEach(nbtbase1 -> {
                CompoundTag nbttagcompound;
                if (nbtbase1 instanceof CompoundTag && (nbttagcompound = (CompoundTag)nbtbase1).contains(ENDER_PEARL_DIMENSION_TAG)) {
                    DataResult dataresult = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbttagcompound.get(ENDER_PEARL_DIMENSION_TAG));
                    Logger logger = LOGGER;
                    Objects.requireNonNull(logger);
                    Optional optional1 = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                    if (optional1.isEmpty()) {
                        LOGGER.warn("No dimension defined for ender pearl, skipping");
                        return;
                    }
                    ServerLevel worldserver = this.level().getServer().getLevel((ResourceKey)optional1.get());
                    if (worldserver != null) {
                        net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(nbttagcompound, worldserver, EntitySpawnReason.LOAD, entity1 -> !worldserver.addWithUUID((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                        if (entity != null) {
                            ServerPlayer.placeEnderPearlTicket(worldserver, entity.chunkPosition());
                        } else {
                            LOGGER.warn("Failed to spawn player ender pearl in level ({}), skipping", optional1.get());
                        }
                    } else {
                        LOGGER.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional1.get());
                    }
                }
            });
        }
    }

    public void spawnIn(Level world) {
        this.setLevel(world);
        if (world == null) {
            this.unsetRemoved();
            Vec3 position = null;
            if (this.respawnDimension != null && (world = this.server.getLevel(this.respawnDimension)) != null && this.getRespawnPosition() != null) {
                position = ServerPlayer.findRespawnAndUseSpawnBlock((ServerLevel)world, this.getRespawnPosition(), this.getRespawnAngle(), false, false).map(RespawnPosAngle::position).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3.atCenterOf(world.getSharedSpawnPos());
            }
            this.setLevel(world);
            this.setPosRaw(position.x(), position.y(), position.z());
        }
        this.gameMode.setLevel((ServerLevel)world);
    }

    public void setExperiencePoints(int points) {
        float f = this.getXpNeededForNextLevel();
        float f1 = (f - 1.0f) / f;
        this.experienceProgress = Mth.clamp((float)points / f, 0.0f, f1);
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int level) {
        this.experienceLevel = level;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int levels) {
        super.giveExperienceLevels(levels);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack enchantedItem, int experienceLevels) {
        super.onEnchantmentPerformed(enchantedItem, experienceLevels);
        this.lastSentExp = -1;
    }

    public void initMenu(AbstractContainerMenu screenHandler) {
        screenHandler.addSlotListener(this.containerListener);
        screenHandler.setSynchronizer(this.containerSynchronizer);
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(ClientboundPlayerCombatEnterPacket.INSTANCE);
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    public void onInsideBlock(BlockState state) {
        CriteriaTriggers.ENTER_BLOCK.trigger(this, state);
    }

    @Override
    protected ItemCooldowns createItemCooldowns() {
        return new ServerItemCooldowns(this);
    }

    @Override
    public void tick() {
        MobEffectInstance nightVision;
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        --this.spawnInvulnerableTime;
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.containerMenu.broadcastChanges();
            this.containerUpdateDelay = this.level().paperConfig().tickRates.containerUpdate;
        }
        if (!(this.level().isClientSide || this.containerMenu == this.inventoryMenu || !this.isImmobile() && this.containerMenu.stillValid(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.containerMenu = this.inventoryMenu;
        }
        if ((entity = this.getCamera()) != this) {
            if (entity.isAlive()) {
                this.absMoveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                this.serverLevel().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriteriaTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriteriaTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.updatePlayerAttributes();
        this.advancements.flushDirty(this);
        if (this.level().purpurConfig.useNightVisionWhenRiding && this.getVehicle() != null && this.getVehicle().getRider() == this && this.level().getGameTime() % 100L == 0L && ((nightVision = this.getEffect(MobEffects.NIGHT_VISION)) == null || nightVision.getDuration() <= 300)) {
            this.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0));
        }
    }

    private void updatePlayerAttributes() {
        AttributeInstance attributemodifiable1;
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attributemodifiable != null) {
            if (this.isCreative()) {
                attributemodifiable.addOrUpdateTransientModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            } else {
                attributemodifiable.removeModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((attributemodifiable1 = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)) != null) {
            if (this.isCreative()) {
                attributemodifiable1.addOrUpdateTransientModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            } else {
                attributemodifiable1.removeModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            }
        }
    }

    public void doTick() {
        try {
            if (this.valid && !this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
            }
            for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
                ItemStack itemstack = this.getInventory().getItem(i);
                if (itemstack.isEmpty()) continue;
                this.synchronizeSpecialItemUpdates(itemstack);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new ClientboundSetHealthPacket(this.getBukkitEntity().getScaledHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(ObjectiveCriteria.HEALTH, Mth.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(ObjectiveCriteria.FOOD, Mth.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(ObjectiveCriteria.AIR, Mth.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(ObjectiveCriteria.ARMOR, Mth.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(ObjectiveCriteria.EXPERIENCE, Mth.ceil(this.lastRecordedExperience));
            }
            if (this.maxHealthCache != (double)this.getMaxHealth()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(ObjectiveCriteria.LEVEL, Mth.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new ClientboundSetExperiencePacket(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriteriaTriggers.LOCATION.trigger(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.experienceLevel;
            }
            if (this.oldLevel != this.experienceLevel) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.experienceLevel);
                this.oldLevel = this.experienceLevel;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().tick();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking player");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Player being ticked");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void synchronizeSpecialItemUpdates(ItemStack stack) {
        Packet<?> packet;
        MapId mapid = stack.get(DataComponents.MAP_ID);
        MapItemSavedData worldmap = MapItem.getSavedData(mapid, this.level());
        if (worldmap != null && (packet = worldmap.getUpdatePacket(mapid, this)) != null) {
            this.connection.send(packet);
        }
    }

    @Override
    protected void tickRegeneration() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.serverLevel().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.tickCount % 20 == 0) {
                float f;
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f = this.foodData.getSaturationLevel()) < 20.0f) {
                    this.foodData.setSaturation(f + 1.0f);
                }
            }
            if (this.tickCount % 10 == 0 && this.foodData.needsFood()) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriteriaTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0f && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
            if (this.currentImpulseImpactPos != null && this.currentImpulseImpactPos.y <= this.startingToFallPosition.y) {
                CriteriaTriggers.FALL_AFTER_EXPLOSION.trigger(this, this.currentImpulseImpactPos, this.currentExplosionCause);
            }
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriteriaTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(ObjectiveCriteria criterion, int score) {
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(criterion, this, scoreaccess -> scoreaccess.set(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack item = inv.get(i);
            if (EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || itemsToKeep.isEmpty() || item.isEmpty()) {
                inv.set(i, ItemStack.EMPTY);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i, ItemStack.EMPTY);
        }
    }

    @Override
    public void die(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        boolean flag = this.serverLevel().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
        if (this.isRemoved()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.getInventory().getContainerSize());
        boolean bl = keepInventory = this.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || this.isSpectator();
        if (!keepInventory) {
            for (ItemStack item : this.getInventory().getContents()) {
                if (item.isEmpty() || EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.shouldDropLoot() && this.serverLevel().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(this.serverLevel(), damageSource, this.lastHurtByPlayerTime > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        net.minecraft.network.chat.Component defaultMessage = this.getCombatTracker().getDeathMessage();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damageSource, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.getHealth() <= 0.0f) {
                this.setHealth((float)event.getReviveHealth());
            }
            return;
        }
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            net.minecraft.network.chat.Component ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), ichatbasecomponent), PacketSendListener.exceptionallySend(() -> {
                boolean flag1 = true;
                String s = ichatbasecomponent.getString(256);
                MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.translatable("death.attack.message_too_long", net.minecraft.network.chat.Component.literal(s).withStyle(ChatFormatting.YELLOW));
                MutableComponent ichatmutablecomponent1 = net.minecraft.network.chat.Component.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.getId(), ichatmutablecomponent1);
            }));
            PlayerTeam playerTeam = this.getTeam();
            if (PurpurConfig.deathMessageOnlyBroadcastToAffectedPlayer) {
                this.sendSystemMessage(ichatbasecomponent);
            } else if (playerTeam != null && playerTeam.getDeathMessageVisibility() != Team.Visibility.ALWAYS) {
                if (playerTeam.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    this.server.getPlayerList().broadcastSystemToTeam(this, ichatbasecomponent);
                } else if (playerTeam.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, ichatbasecomponent);
                }
            } else {
                this.server.getPlayerList().broadcastSystemMessage(ichatbasecomponent, false);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.serverLevel().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        if (event.shouldDropExperience()) {
            this.dropExperience(this.serverLevel(), damageSource.getEntity());
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.getInventory().compartments) {
                ServerPlayer.processKeep(event, nonNullList);
            }
            ServerPlayer.processKeep(event, null);
        }
        this.setCamera(this);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        LivingEntity entityliving = this.getKillCredit();
        if (entityliving != null) {
            this.awardStat(Stats.ENTITY_KILLED_BY.get(entityliving.getType()));
            entityliving.awardKillScore(this, this.deathScore, damageSource);
            this.createWitherRose(entityliving);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    private void tellNeutralMobsThatIDied() {
        AABB axisalignedbb = new AABB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(Mob.class, axisalignedbb, EntitySelector.NO_SPECTATORS).stream().filter(entityinsentient -> entityinsentient instanceof NeutralMob).forEach(entityinsentient -> ((NeutralMob)((Object)entityinsentient)).playerDied(this.serverLevel(), this));
    }

    @Override
    public void awardKillScore(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.awardKillScore(entityKilled, score, damageSource);
            this.increaseScore(score);
            this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
            if (entityKilled instanceof Player) {
                this.awardStat(Stats.PLAYER_KILLS);
                this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
            } else {
                this.awardStat(Stats.MOB_KILLS);
            }
            this.handleTeamKill(this, entityKilled, ObjectiveCriteria.TEAM_KILL);
            this.handleTeamKill(entityKilled, this, ObjectiveCriteria.KILLED_BY_TEAM);
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(this, entityKilled, damageSource);
        }
    }

    private void handleTeamKill(ScoreHolder targetScoreHolder, ScoreHolder aboutScoreHolder, ObjectiveCriteria[] criterions) {
        int i;
        PlayerTeam scoreboardteam = this.getScoreboard().getPlayersTeam(aboutScoreHolder.getScoreboardName());
        if (scoreboardteam != null && (i = scoreboardteam.getColor().getId()) >= 0 && i < criterions.length) {
            this.level().getCraftServer().getScoreboardManager().forAllObjectives(criterions[i], targetScoreHolder, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        Player entityhuman1;
        AbstractArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        Player entityhuman;
        boolean flag;
        if (this.isInvulnerableTo(world, source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FALL)) {
            if (this.getRootVehicle() instanceof AbstractMinecart && this.level().purpurConfig.minecartControllable && !this.level().purpurConfig.minecartControllableFallDamage) {
                return false;
            }
            if (this.getRootVehicle() instanceof Boat && !this.level().purpurConfig.boatsDoFallDamage) {
                return false;
            }
        }
        boolean bl = flag = this.server.isDedicatedServer() && this.isPvpAllowed() && source.is(DamageTypeTags.IS_FALL);
        if (!flag && this.spawnInvulnerableTime > 0 && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.getEntity();
        if (entity instanceof Player && !this.canHarmPlayer(entityhuman = (Player)entity)) {
            return false;
        }
        if (entity instanceof AbstractArrow && (entity1 = (entityarrow = (AbstractArrow)entity).getOwner()) instanceof Player && !this.canHarmPlayer(entityhuman1 = (Player)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.hurtServer(world, source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.connection.send(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean canHarmPlayer(Player player) {
        return !this.isPvpAllowed() ? false : super.canHarmPlayer(player);
    }

    private boolean isPvpAllowed() {
        return this.level().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.PostTeleportTransition teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPos blockposition = this.getRespawnPosition();
        float f = this.getRespawnAngle();
        boolean flag1 = this.isRespawnForced();
        ServerLevel worldserver = this.server.getLevel(this.getRespawnDimension());
        if (worldserver != null && blockposition != null) {
            Optional<RespawnPosAngle> optional = ServerPlayer.findRespawnAndUseSpawnBlock(worldserver, blockposition, f, flag1, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.position(), Vec3.ZERO, entityplayer_respawnposangle.yaw(), 0.0f, teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.missingRespawnBlock(this.server.overworld(), this, teleporttransition_a);
            }
        } else {
            teleportTransition = new TeleportTransition(this.server.overworld(), this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.position(), (World)teleportTransition.newLevel().getWorld(), teleportTransition.yRot(), teleportTransition.xRot());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (reason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((org.bukkit.entity.Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason, builder);
        this.level().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.connection.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.deltaMovement(), location.getYaw(), location.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), teleportTransition.relatives(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> findRespawnAndUseSpawnBlock(ServerLevel world, BlockPos pos, float spawnAngle, boolean spawnForced, boolean alive) {
        BlockState iblockdata = world.getBlockState(pos);
        Block block = iblockdata.getBlock();
        if (block instanceof RespawnAnchorBlock && (spawnForced || iblockdata.getValue(RespawnAnchorBlock.CHARGE) > 0) && RespawnAnchorBlock.canSetSpawn(world)) {
            Optional<Vec3> optional = RespawnAnchorBlock.findStandUpPosition(EntityType.PLAYER, world, pos);
            if (!spawnForced && alive && optional.isPresent()) {
                world.setBlock(pos, (BlockState)iblockdata.setValue(RespawnAnchorBlock.CHARGE, iblockdata.getValue(RespawnAnchorBlock.CHARGE) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, pos, false, true));
        }
        if (block instanceof BedBlock && BedBlock.canSetSpawn(world)) {
            return BedBlock.findStandUpPosition(EntityType.PLAYER, world, pos, iblockdata.getValue(HorizontalDirectionalBlock.FACING), spawnAngle).map(vec3d -> RespawnPosAngle.of(vec3d, pos, true, false));
        }
        if (!spawnForced) {
            return Optional.empty();
        }
        boolean flag2 = block.isPossibleToRespawnInThis(iblockdata);
        BlockState iblockdata1 = world.getBlockState(pos.above());
        boolean flag3 = iblockdata1.getBlock().isPossibleToRespawnInThis(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5), spawnAngle, false, false)) : Optional.empty();
    }

    public void showEndCredits() {
        this.unRide();
        this.serverLevel().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        if (!this.wonGame) {
            this.wonGame = true;
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
            this.seenCredits = true;
        }
    }

    @Override
    @Nullable
    public ServerPlayer teleport(TeleportTransition teleportTarget) {
        BlockEntity blockEntity;
        if (this.isSleeping()) {
            return null;
        }
        if (this.isRemoved()) {
            return null;
        }
        if (teleportTarget.missingRespawnBlock()) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        ServerLevel worldserver = teleportTarget.newLevel();
        ServerLevel worldserver1 = this.serverLevel();
        ResourceKey<LevelStem> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this), PositionMoveRotation.of(teleportTarget), teleportTarget.relatives());
        Location exit = CraftLocation.toBukkit(absolutePosition.position(), (World)worldserver.getWorld(), absolutePosition.yRot(), absolutePosition.xRot());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, teleportTarget.cause());
        if (this.portalProcess != null && this.portalProcess.isSamePortal((EndGatewayBlock)Blocks.END_GATEWAY) && (blockEntity = this.serverLevel().getBlockEntity(this.portalProcess.getEntryPosition())) instanceof TheEndGatewayBlockEntity) {
            TheEndGatewayBlockEntity theEndGatewayBlockEntity = (TheEndGatewayBlockEntity)blockEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, (EndGateway)new CraftEndGateway((World)this.serverLevel().getWorld(), theEndGatewayBlockEntity));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTarget = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3.ZERO, newExit.getYaw(), newExit.getPitch(), teleportTarget.missingRespawnBlock(), teleportTarget.asPassenger(), Set.of(), teleportTarget.postTeleportTransition(), teleportTarget.cause());
        }
        if (!teleportTarget.asPassenger()) {
            this.stopRiding();
        }
        if (worldserver != null && worldserver.dimension() == worldserver1.dimension()) {
            this.connection.internalTeleport(PositionMoveRotation.of(teleportTarget), teleportTarget.relatives());
            this.connection.resetPosition();
            teleportTarget.postTeleportTransition().onTransition(this);
            return this;
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("moving");
        if (worldserver != null && resourcekey == LevelStem.OVERWORLD && worldserver.getTypeKey() == LevelStem.NETHER) {
            this.enteredNetherPosition = this.position();
        }
        gameprofilerfiller.pop();
        gameprofilerfiller.push("placing");
        this.isChangingDimension = true;
        LevelData worlddata = worldserver.getLevelData();
        this.connection.send(new ClientboundRespawnPacket(this.createCommonSpawnInfo(worldserver), 3));
        this.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        PlayerList playerlist = this.server.getPlayerList();
        playerlist.sendPlayerPermissionLevel(this);
        worldserver1.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        this.portalPos = MCUtil.toBlockPosition(exit);
        this.setServerLevel(worldserver);
        this.connection.internalTeleport(PositionMoveRotation.of(teleportTarget), teleportTarget.relatives());
        this.connection.resetPosition();
        worldserver.addDuringTeleport(this);
        gameprofilerfiller.pop();
        this.triggerDimensionChangeTriggers(worldserver1);
        this.stopUsingItem();
        this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
        playerlist.sendLevelInfo(this, worldserver);
        playerlist.sendAllPlayerInfo(this);
        playerlist.sendActivePlayerEffects(this);
        teleportTarget.postTeleportTransition().onTransition(this);
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.level().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.isBlocking()) {
            this.stopUsingItem();
        }
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void forceSetRotation(float yaw, float pitch) {
        this.connection.send(new ClientboundPlayerRotationPacket(yaw, pitch));
    }

    public void triggerDimensionChangeTriggers(ServerLevel origin) {
        ResourceKey<Level> resourcekey = origin.dimension();
        ResourceKey<Level> resourcekey1 = this.level().dimension();
        ResourceKey<Level> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<Level> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.level());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriteriaTriggers.CHANGED_DIMENSION.trigger(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriteriaTriggers.CHANGED_DIMENSION.trigger(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == Level.NETHER && maindimensionkey1 == Level.OVERWORLD && this.enteredNetherPosition != null) {
            CriteriaTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if (maindimensionkey1 != Level.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(ServerPlayer spectator) {
        return spectator.isSpectator() ? this.getCamera() == this : (this.isSpectator() ? false : super.broadcastToPlayer(spectator));
    }

    @Override
    public void take(net.minecraft.world.entity.Entity item, int count) {
        super.take(item, count);
        this.containerMenu.broadcastChanges();
    }

    private Either<Player.BedSleepingProblem, Unit> getBedResult(BlockPos blockposition, Direction enumdirection) {
        if (!this.isSleeping() && this.isAlive()) {
            if (!this.level().dimensionType().natural() || !this.level().dimensionType().bedWorks()) {
                return Either.left(Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!this.bedInRange(blockposition, enumdirection)) {
                return Either.left(Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (this.bedBlocked(blockposition, enumdirection)) {
                return Either.left(Player.BedSleepingProblem.OBSTRUCTED);
            }
            this.setRespawnPosition(this.level().dimension(), blockposition, this.getYRot(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.level().isDay()) {
                return Either.left(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!this.isCreative()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vec3d = Vec3.atBottomCenterOf(blockposition);
                List<Monster> list = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3d.x() - 8.0, vec3d.y() - 5.0, vec3d.z() - 8.0, vec3d.x() + 8.0, vec3d.y() + 5.0, vec3d.z() + 8.0), entitymonster -> entitymonster.isPreventingPlayerRest(this.serverLevel(), this));
                if (!this.level().purpurConfig.playerSleepNearMonsters && !list.isEmpty()) {
                    return Either.left(Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            return Either.right(Unit.INSTANCE);
        }
        return Either.left(Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    @Override
    public Either<Player.BedSleepingProblem, Unit> startSleepInBed(BlockPos blockposition, boolean force) {
        net.minecraft.network.chat.Component clientMessage;
        Direction enumdirection = this.level().getBlockState(blockposition).getValue(HorizontalDirectionalBlock.FACING);
        Either<Player.BedSleepingProblem, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == Player.BedSleepingProblem.OTHER_PROBLEM) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.INSTANCE);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<Player.BedSleepingProblem, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.awardStat(Stats.SLEEP_IN_BED);
            CriteriaTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.serverLevel().canSleepThroughNights() && (clientMessage = PurpurConfig.sleepNotPossible.isBlank() ? null : (!PurpurConfig.sleepNotPossible.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.sleepNotPossible)) : net.minecraft.network.chat.Component.translatable("sleep.not_possible"))) != null) {
            this.displayClientMessage(clientMessage, true);
        }
        ((ServerLevel)this.level()).updateSleepingPlayerList();
        return either;
    }

    @Override
    public void startSleeping(BlockPos pos) {
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        super.startSleeping(pos);
    }

    private boolean bedInRange(BlockPos pos, Direction direction) {
        return this.isReachableBedBlock(pos) || this.isReachableBedBlock(pos.relative(direction.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPos pos) {
        Vec3 vec3d = Vec3.atBottomCenterOf(pos);
        return Math.abs(this.getX() - vec3d.x()) <= 3.0 && Math.abs(this.getY() - vec3d.y()) <= 2.0 && Math.abs(this.getZ() - vec3d.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPos pos, Direction direction) {
        BlockPos blockposition1 = pos.above();
        return !this.freeAt(blockposition1) || !this.freeAt(blockposition1.relative(direction.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.isSleeping()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPos bedPosition = this.getSleepingPos().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.level().getWorld().getBlockAt(bedPosition.getX(), bedPosition.getY(), bedPosition.getZ()) : this.level().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((org.bukkit.entity.Player)player, bed, true);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.isSleeping()) {
            this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(this, 2));
        }
        super.stopSleepInBed(skipSleepTimer, updateSleepingPlayers);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void dismountTo(double destX, double destY, double destZ) {
        this.removeVehicle();
        this.setPos(destX, destY, destZ);
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel world, DamageSource source) {
        return super.isInvulnerableTo(world, source) || this.isChangingDimension() && !source.is(DamageTypes.ENDER_PEARL) || !this.level().paperConfig().collisions.allowPlayerCrammingDamage && source.is(DamageTypes.CRAMMING);
    }

    @Override
    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    @Override
    protected void onChangedBlock(ServerLevel world, BlockPos pos) {
        if (!this.isSpectator()) {
            super.onChangedBlock(world, pos);
        }
    }

    public void doCheckFallDamage(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.touchingUnloadedChunk()) {
            this.checkSupportingBlock(onGround, new Vec3(xDifference, yDifference, zDifference));
            BlockPos blockposition = this.getOnPosLegacy();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            if (this.spawnExtraParticlesOnFall && onGround && this.fallDistance > 0.0f) {
                Vec3 vec3d = blockposition.getCenter().add(0.0, 0.5, 0.0);
                int i = (int)Mth.clamp(50.0f * this.fallDistance, 0.0f, 200.0f);
                this.serverLevel().sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), vec3d.x, vec3d.y, vec3d.z, i, 0.3f, 0.3f, 0.3f, 0.15f);
                this.spawnExtraParticlesOnFall = false;
            }
            super.checkFallDamage(yDifference, onGround, iblockdata, blockposition);
        }
    }

    @Override
    public void onExplosionHit(@Nullable net.minecraft.world.entity.Entity entity) {
        super.onExplosionHit(entity);
        this.currentImpulseImpactPos = this.position();
        this.currentExplosionCause = entity;
        this.setIgnoreFallDamageFromCurrentImpulse(entity != null && entity.getType() == EntityType.WIND_CHARGE);
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(SignBlockEntity sign, boolean front) {
        if (this.level().purpurConfig.signAllowColors) {
            this.connection.send(sign.getTranslatedUpdatePacket(this.textFilteringEnabled, front));
        }
        this.connection.send(new ClientboundBlockUpdatePacket(this.level(), sign.getBlockPos()));
        this.connection.send(new ClientboundOpenSignEditorPacket(sign.getBlockPos(), front));
    }

    public int nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
        return this.containerCounter;
    }

    @Override
    public OptionalInt openMenu(@Nullable MenuProvider factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        AbstractContainerMenu container = factory.createMenu(this.containerCounter, this.getInventory(), this);
        net.minecraft.network.chat.Component title = null;
        if (container != null) {
            container.setTitle(factory.getDisplayName());
            boolean cancelled = false;
            Pair<Component, AbstractContainerMenu> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (AbstractContainerMenu)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof Container) {
                    ((Container)((Object)factory)).stopOpen(this);
                } else if (factory instanceof ChestBlock.DoubleInventory) {
                    ((ChestBlock.DoubleInventory)factory).inventorylargechest.stopOpen(this);
                } else if (!this.enderChestInventory.isActiveChest(null)) {
                    this.enderChestInventory.stopOpen(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(net.minecraft.network.chat.Component.translatable("container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.containerMenu = container;
        if (!this.isImmobile()) {
            this.connection.send(new ClientboundOpenScreenPacket(container.containerId, container.getType(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.initMenu(container);
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int syncId, MerchantOffers offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.connection.send(new ClientboundMerchantOffersPacket(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void openHorseInventory(AbstractHorse horse, Container inventory) {
        this.nextContainerCounter();
        AbstractContainerMenu container = new HorseInventoryMenu(this.containerCounter, this.getInventory(), inventory, horse, horse.getInventoryColumns());
        container.setTitle(horse.getDisplayName());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.stopOpen(this);
            return;
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int i = horse.getInventoryColumns();
        this.connection.send(new ClientboundHorseScreenOpenPacket(this.containerCounter, i, horse.getId()));
        this.containerMenu = container;
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack book, InteractionHand hand) {
        if (book.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            if (WrittenBookItem.resolveBookComponents(book, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new ClientboundOpenBookPacket(hand));
        }
    }

    @Override
    public void openCommandBlock(CommandBlockEntity commandBlock) {
        this.connection.send(ClientboundBlockEntityDataPacket.create(commandBlock, BlockEntity::saveCustomOnly));
    }

    @Override
    public void closeContainer() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void rideTick() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - d0, this.getY() - d1, this.getZ() - d2);
    }

    public void checkMovementStatistics(double deltaX, double deltaY, double deltaZ) {
        if (!this.isPassenger() && !ServerPlayer.didNotMove(deltaX, deltaY, deltaZ)) {
            if (this.isSwimming()) {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i > 0) {
                    this.awardStat(Stats.SWIM_ONE_CM, i);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (this.isEyeInFluid(FluidTags.WATER)) {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i > 0) {
                    this.awardStat(Stats.WALK_UNDER_WATER_ONE_CM, i);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.isInWater()) {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i > 0) {
                    this.awardStat(Stats.WALK_ON_WATER_ONE_CM, i);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.onClimbable()) {
                if (deltaY > 0.0) {
                    this.awardStat(Stats.CLIMB_ONE_CM, (int)Math.round(deltaY * 100.0));
                }
            } else if (this.onGround()) {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i > 0) {
                    if (this.isSprinting()) {
                        this.awardStat(Stats.SPRINT_ONE_CM, i);
                        this.causeFoodExhaustion(this.level().spigotConfig.sprintMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.isCrouching()) {
                        this.awardStat(Stats.CROUCH_ONE_CM, i);
                        this.causeFoodExhaustion(this.level().spigotConfig.otherMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.awardStat(Stats.WALK_ONE_CM, i);
                        this.causeFoodExhaustion(this.level().spigotConfig.otherMultiplier * (float)i * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.isFallFlying()) {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                this.awardStat(Stats.AVIATE_ONE_CM, i);
            } else {
                int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i > 25) {
                    this.awardStat(Stats.FLY_ONE_CM, i);
                }
            }
        }
    }

    private void checkRidingStatistics(double deltaX, double deltaY, double deltaZ) {
        if (this.isPassenger() && !ServerPlayer.didNotMove(deltaX, deltaY, deltaZ)) {
            int i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
            net.minecraft.world.entity.Entity entity = this.getVehicle();
            if (entity instanceof AbstractMinecart) {
                this.awardStat(Stats.MINECART_ONE_CM, i);
            } else if (entity instanceof AbstractBoat) {
                this.awardStat(Stats.BOAT_ONE_CM, i);
            } else if (entity instanceof Pig) {
                this.awardStat(Stats.PIG_ONE_CM, i);
            } else if (entity instanceof AbstractHorse) {
                this.awardStat(Stats.HORSE_ONE_CM, i);
            } else if (entity instanceof Strider) {
                this.awardStat(Stats.STRIDER_ONE_CM, i);
            }
        }
    }

    private static boolean didNotMove(double deltaX, double deltaY, double deltaZ) {
        return deltaX == 0.0 && deltaY == 0.0 && deltaZ == 0.0;
    }

    @Override
    public void awardStat(Stat<?> stat, int amount) {
        this.stats.increment(this, stat, amount);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreaccess -> scoreaccess.add(amount));
    }

    @Override
    public void resetStat(Stat<?> stat) {
        this.stats.setValue(this, stat, 0);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> recipes) {
        return this.recipeBook.addRecipes(recipes, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> recipe, List<ItemStack> ingredients) {
        CriteriaTriggers.RECIPE_CRAFTED.trigger(this, recipe.id(), ingredients);
    }

    @Override
    public void awardRecipesByKey(List<ResourceKey<Recipe<?>>> recipes) {
        List<RecipeHolder<?>> list1 = recipes.stream().flatMap(resourcekey -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.awardRecipes(list1);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> recipes) {
        return this.recipeBook.removeRecipes(recipes, this);
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(Stats.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void giveExperiencePoints(int experience) {
        super.giveExperiencePoints(experience);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isPassenger() && this.getVehicle() instanceof ServerPlayer) {
            this.stopRiding();
        }
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
        this.lastSentExp = -1;
    }

    public void sendActionBarMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendActionBarMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendActionBarMessage(@Nullable Component message) {
        if (message != null) {
            this.sendActionBarMessage(PaperAdventure.asVanilla(message));
        }
    }

    public void sendActionBarMessage(@Nullable net.minecraft.network.chat.Component message) {
        if (message != null) {
            this.displayClientMessage(message, true);
        }
    }

    @Override
    public void displayClientMessage(net.minecraft.network.chat.Component message, boolean overlay) {
        this.sendSystemMessage(message, overlay);
    }

    @Override
    public void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new ClientboundEntityEventPacket(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor anchorPoint, Vec3 target) {
        super.lookAt(anchorPoint, target);
        this.connection.send(new ClientboundPlayerLookAtPacket(anchorPoint, target.x, target.y, target.z));
    }

    public void lookAt(EntityAnchorArgument.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, EntityAnchorArgument.Anchor targetAnchor) {
        Vec3 vec3d = targetAnchor.apply(targetEntity);
        super.lookAt(anchorPoint, vec3d);
        this.connection.send(new ClientboundPlayerLookAtPacket(anchorPoint, targetEntity, targetAnchor));
    }

    public void restoreFrom(ServerPlayer oldPlayer, boolean alive) {
        this.wardenSpawnTracker = oldPlayer.wardenSpawnTracker;
        this.chatSession = oldPlayer.chatSession;
        this.gameMode.setGameModeForPlayer(oldPlayer.gameMode.getGameModeForPlayer(), oldPlayer.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        if (alive) {
            this.getAttributes().assignBaseValues(oldPlayer.getAttributes());
            this.setHealth(oldPlayer.getHealth());
            this.foodData = oldPlayer.foodData;
            for (MobEffectInstance mobEffectInstance : oldPlayer.getActiveEffects()) {
            }
            this.getInventory().replaceWith(oldPlayer.getInventory());
            this.experienceLevel = oldPlayer.experienceLevel;
            this.totalExperience = oldPlayer.totalExperience;
            this.experienceProgress = oldPlayer.experienceProgress;
            this.setScore(oldPlayer.getScore());
            this.portalProcess = oldPlayer.portalProcess;
        } else {
            this.getAttributes().assignBaseValues(oldPlayer.getAttributes());
            if (this.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || oldPlayer.isSpectator()) {
                this.getInventory().replaceWith(oldPlayer.getInventory());
                this.experienceLevel = oldPlayer.experienceLevel;
                this.totalExperience = oldPlayer.totalExperience;
                this.experienceProgress = oldPlayer.experienceProgress;
                this.setScore(oldPlayer.getScore());
            }
        }
        this.enchantmentSeed = oldPlayer.enchantmentSeed;
        this.enderChestInventory = oldPlayer.enderChestInventory;
        this.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, oldPlayer.getEntityData().get(Player.DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.seenCredits = oldPlayer.seenCredits;
        this.enteredNetherPosition = oldPlayer.enteredNetherPosition;
        this.chunkTrackingView = oldPlayer.chunkTrackingView;
        this.setShoulderEntityLeft(oldPlayer.getShoulderEntityLeft());
        this.setShoulderEntityRight(oldPlayer.getShoulderEntityRight());
        this.setLastDeathLocation(oldPlayer.getLastDeathLocation());
    }

    @Override
    protected void onEffectAdded(MobEffectInstance effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.onEffectAdded(effect, source);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effect, true));
        if (effect.is(MobEffects.LEVITATION)) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, source);
    }

    @Override
    protected void onEffectUpdated(MobEffectInstance effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.onEffectUpdated(effect, reapplyEffect, source);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effect, false));
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, source);
    }

    @Override
    protected void onEffectsRemoved(Collection<MobEffectInstance> effects) {
        super.onEffectsRemoved(effects);
        for (MobEffectInstance mobeffect : effects) {
            this.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), mobeffect.getEffect()));
            if (!mobeffect.is(MobEffects.LEVITATION)) continue;
            this.levitationStartPos = null;
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void teleportTo(double destX, double destY, double destZ) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(destX, destY, destZ), Vec3.ZERO, 0.0f, 0.0f), Relative.union(Relative.DELTA, Relative.ROTATION));
    }

    @Override
    public void teleportRelative(double offsetX, double offsetY, double offsetZ) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(offsetX, offsetY, offsetZ), Vec3.ZERO, 0.0f, 0.0f), Relative.ALL);
    }

    @Override
    public boolean teleportTo(ServerLevel worldserver, double d0, double d1, double d2, Set<Relative> set, float f, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        ChunkPos chunkcoordintpair = new ChunkPos(BlockPos.containing(d0, d1, d2));
        worldserver.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkcoordintpair, 1, this.getId());
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (flag) {
            this.setCamera(this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f, f1, flag, cause)) {
            this.setYHeadRot(set.contains((Object)Relative.Y_ROT) ? this.getYHeadRot() + f : f);
        }
        return flag1;
    }

    @Override
    public void moveTo(double x, double y, double z) {
        super.moveTo(x, y, z);
        this.connection.resetPosition();
    }

    @Override
    public void crit(net.minecraft.world.entity.Entity target) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(target, 4));
    }

    @Override
    public void magicCrit(net.minecraft.world.entity.Entity target) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(target, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection != null) {
            this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
            this.updateInvisibilityStatus();
        }
    }

    public ServerLevel serverLevel() {
        return (ServerLevel)this.level();
    }

    public boolean setGameMode(GameType gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(GameType gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean flag = this.isSpectator();
        PlayerGameModeChangeEvent event = this.gameMode.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.CHANGE_GAME_MODE, gameMode.getId()));
        if (gameMode == GameType.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
            EnchantmentHelper.stopLocationBasedEffects(this);
        } else {
            this.setCamera(this);
            if (flag) {
                EnchantmentHelper.runLocationChangedEffects(this.serverLevel(), this);
            }
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return event;
    }

    @Override
    public boolean isSpectator() {
        return this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        return this.gameMode.getGameModeForPlayer() == GameType.CREATIVE;
    }

    public CommandSource commandSource() {
        return this.commandSource;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this.commandSource(), this.position(), this.getRotationVector(), this.serverLevel(), this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.server, this);
    }

    public void sendMiniMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendMessage(@Nullable Component message) {
        if (message != null) {
            this.sendSystemMessage(PaperAdventure.asVanilla(message));
        }
    }

    public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        this.sendSystemMessage(message, false);
    }

    public void sendSystemMessage(net.minecraft.network.chat.Component message, boolean overlay) {
        if (this.acceptsSystemMessages(overlay)) {
            this.connection.send(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.exceptionallySend(() -> {
                if (this.acceptsSystemMessages(false)) {
                    boolean flag1 = true;
                    String s = message.getString(256);
                    MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.literal(s).withStyle(ChatFormatting.YELLOW);
                    return new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("multiplayer.message_not_delivered", ichatmutablecomponent).withStyle(ChatFormatting.RED), false);
                }
                return null;
            }));
        }
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatType.Bound params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatType.Bound params, @Nullable net.minecraft.network.chat.Component unsigned) {
        if (this.acceptsChatMessages()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String getIpAddress() {
        SocketAddress socketaddress = this.connection.getRemoteAddress();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void updateOptions(ClientInformation clientOptions) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Map)Util.make(new IdentityHashMap(), map -> {
            map.put(ClientOption.LOCALE, clientOptions.language());
            map.put(ClientOption.VIEW_DISTANCE, clientOptions.viewDistance());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientOptions.chatVisibility().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientOptions.chatColors());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientOptions.modelCustomisation()));
            map.put(ClientOption.MAIN_HAND, clientOptions.mainHand() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientOptions.textFilteringEnabled());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientOptions.allowsListing());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientOptions.particleStatus().name()));
        })).callEvent();
        if (this.getMainArm() != clientOptions.mainHand()) {
            event = new PlayerChangedMainHandEvent((org.bukkit.entity.Player)this.getBukkitEntity(), this.getMainArm() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        if (this.language == null || !this.language.equals(clientOptions.language())) {
            event = new PlayerLocaleChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), clientOptions.language());
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientOptions);
    }

    public void updateOptionsNoEvents(ClientInformation clientOptions) {
        this.language = clientOptions.language();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.language), Locale.US);
        this.requestedViewDistance = clientOptions.viewDistance();
        this.chatVisibility = clientOptions.chatVisibility();
        this.canChatColor = clientOptions.chatColors();
        this.textFilteringEnabled = clientOptions.textFilteringEnabled();
        this.allowsListing = clientOptions.allowsListing();
        this.particleStatus = clientOptions.particleStatus();
        this.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (byte)clientOptions.modelCustomisation());
        this.getEntityData().set(Player.DATA_PLAYER_MAIN_HAND, (byte)clientOptions.mainHand().getId());
    }

    public ClientInformation clientInformation() {
        byte b0 = this.getEntityData().get(Player.DATA_PLAYER_MODE_CUSTOMISATION);
        HumanoidArm enummainhand = HumanoidArm.BY_ID.apply(this.getEntityData().get(Player.DATA_PLAYER_MAIN_HAND).byteValue());
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, b0, enummainhand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public ChatVisiblity getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean overlay) {
        return this.chatVisibility == ChatVisiblity.HIDDEN ? overlay : true;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == ChatVisiblity.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerStatus metadata) {
        this.connection.send(new ClientboundServerDataPacket(metadata.description(), metadata.favicon().map(ServerStatus.Favicon::iconBytes)));
    }

    @Override
    protected int getPermissionLevel() {
        return this.server.getProfilePermissions(this.getGameProfile());
    }

    @Override
    public void resetLastActionTime() {
        this.lastActionTime = Util.getMillis();
        this.setAfk(false);
    }

    @Override
    public void setAfk(boolean afk) {
        if (this.isAfk == afk) {
            return;
        }
        String msg = afk ? PurpurConfig.afkBroadcastAway : PurpurConfig.afkBroadcastBack;
        PlayerAFKEvent event = new PlayerAFKEvent((org.bukkit.entity.Player)this.getBukkitEntity(), afk, this.level().purpurConfig.idleTimeoutKick, msg, !Bukkit.isPrimaryThread());
        if (!event.callEvent() || event.shouldKick()) {
            return;
        }
        this.isAfk = afk;
        if (!afk) {
            this.resetLastActionTime();
        }
        if ((msg = event.getBroadcastMsg()) != null && !msg.isEmpty()) {
            String playerName = this.getGameProfile().getName();
            if (PurpurConfig.afkBroadcastUseDisplayName) {
                TextComponent playerDisplayNameComponent = LegacyComponentSerializer.legacySection().deserialize(this.getBukkitEntity().getDisplayName());
                playerName = PlainTextComponentSerializer.plainText().serialize((Component)playerDisplayNameComponent);
            }
            this.server.getPlayerList().broadcastMiniMessage(String.format(msg, playerName), false);
        }
        if (this.level().purpurConfig.idleTimeoutUpdateTabList) {
            String scoreboardName = this.getScoreboardName();
            String playerListName = (String)MiniMessage.miniMessage().serialize(this.getBukkitEntity().playerListName());
            String[] split = playerListName.split(scoreboardName);
            String prefix = (split.length > 0 ? split[0] : "").replace(PurpurConfig.afkTabListPrefix, "");
            String suffix = (split.length > 1 ? split[1] : "").replace(PurpurConfig.afkTabListSuffix, "");
            if (afk) {
                this.getBukkitEntity().setPlayerListName(PurpurConfig.afkTabListPrefix + prefix + scoreboardName + suffix + PurpurConfig.afkTabListSuffix, true);
            } else {
                this.getBukkitEntity().setPlayerListName(prefix + scoreboardName + suffix, true);
            }
        }
        ((ServerLevel)this.level()).updateSleepingPlayerList();
    }

    @Override
    public boolean isAfk() {
        return this.isAfk;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isAfk() && super.canBeCollidedWith();
    }

    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public ServerRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public net.minecraft.world.entity.Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.getCamera();
        net.minecraft.world.entity.Entity entity2 = this.camera = entity == null ? this : entity;
        if (entity1 != this.camera) {
            Level world;
            if (this.camera == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.camera = entity1;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.camera = entity1;
                    return;
                }
            }
            if ((world = this.camera.level()) instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                this.teleportTo(worldserver, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.serverLevel().getChunkSource().move(this);
            }
            this.connection.send(new ClientboundSetCameraPacket(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(net.minecraft.world.entity.Entity target) {
        if (this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            this.setCamera(target);
        } else {
            super.attack(target);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Nullable
    public net.minecraft.network.chat.Component getTabListDisplayName() {
        return this.listName;
    }

    public int getTabListOrder() {
        return this.listOrder;
    }

    @Override
    public void swing(InteractionHand hand) {
        super.swing(hand);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public PlayerAdvancements getAdvancements() {
        return this.advancements;
    }

    @Nullable
    public BlockPos getRespawnPosition() {
        return this.respawnPosition;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public ResourceKey<Level> getRespawnDimension() {
        return this.respawnDimension;
    }

    public boolean isRespawnForced() {
        return this.respawnForced;
    }

    public void copyRespawnPosition(ServerPlayer player) {
        this.setRespawnPosition(player.getRespawnDimension(), player.getRespawnPosition(), player.getRespawnAngle(), player.isRespawnForced(), false);
    }

    @Deprecated
    public void setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.respawnPosition) && dimension.equals(this.respawnDimension);
            spawnLoc = MCUtil.toLocation(this.getServer().getLevel(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((org.bukkit.entity.Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().dimension() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.sendSystemMessage(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.respawnPosition = pos;
            this.respawnDimension = dimension;
            this.respawnAngle = angle;
            this.respawnForced = forced;
        } else {
            this.respawnPosition = null;
            this.respawnDimension = Level.OVERWORLD;
            this.respawnAngle = 0.0f;
            this.respawnForced = false;
        }
        return true;
    }

    public SectionPos getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPos section) {
        this.lastSectionPos = section;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView chunkFilter) {
        this.chunkTrackingView = chunkFilter;
    }

    @Override
    public void playNotifySound(SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), category, this.getX(), this.getY(), this.getZ(), volume, pitch, this.random.nextLong()));
    }

    @Override
    public ItemEntity drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        MapItemSavedData worldmap;
        ItemEntity entityitem = this.createItemStackToDrop(itemstack, flag, flag1);
        if (entityitem == null) {
            return null;
        }
        if (callEvent) {
            CraftPlayer player = this.getBukkitEntity();
            Item drop = (Item)entityitem.getBukkitEntity();
            PlayerDropItemEvent event = new PlayerDropItemEvent((org.bukkit.entity.Player)player, drop);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                if (flag1 && (cur == null || cur.getAmount() == 0)) {
                    player.getInventory().setItemInHand(drop.getItemStack());
                } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                    cur.setAmount(cur.getAmount() + 1);
                    player.getInventory().setItemInHand(cur);
                } else {
                    player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                }
                return null;
            }
        }
        this.level().addFreshEntity(entityitem);
        ItemStack itemstack1 = entityitem.getItem();
        if (flag1) {
            if (!itemstack1.isEmpty()) {
                this.awardStat(Stats.ITEM_DROPPED.get(itemstack1.getItem()), itemstack1.getCount());
            }
            this.awardStat(Stats.DROP);
        }
        if (itemstack.getItem() == Items.FILLED_MAP && (worldmap = MapItem.getSavedData(itemstack, this.level())) != null) {
            worldmap.tickCarriedBy(this, itemstack);
        }
        return entityitem;
    }

    @Nullable
    private ItemEntity createItemStackToDrop(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        if (stack.isEmpty()) {
            return null;
        }
        double d0 = this.getEyeY() - (double)0.3f;
        ItemStack tmp = stack.copy();
        stack.setCount(0);
        stack = tmp;
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), d0, this.getZ(), stack);
        entityitem.setPickUpDelay(40);
        if (retainOwnership) {
            entityitem.setThrower(this);
        }
        if (throwRandomly) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            entityitem.setDeltaMovement(-Mth.sin(f1) * f, 0.2f, Mth.cos(f1) * f);
        } else {
            float f = 0.3f;
            float f1 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float f2 = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float f3 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float f4 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.random.nextFloat();
            entityitem.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        return entityitem;
    }

    public TextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(ServerLevel world) {
        this.setLevel(world);
        this.gameMode.setLevel(world);
    }

    @Nullable
    private static GameType readPlayerMode(@Nullable CompoundTag nbt, String key) {
        return nbt != null && nbt.contains(key, 99) ? GameType.byId(nbt.getInt(key)) : null;
    }

    private GameType calculateGameModeForNewPlayer(@Nullable GameType backupGameMode) {
        GameType enumgamemode1 = this.server.getForcedGameType();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.server.getDefaultGameType());
    }

    public void loadGameTypes(@Nullable CompoundTag nbt) {
        if (this.server.getForcedGameType() != null && this.server.getForcedGameType() != ServerPlayer.readPlayerMode(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), GameMode.getByValue((int)this.server.getDefaultGameType().getId()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.gameMode.setGameModeForPlayer(this.server.getForcedGameType(), GameType.DEFAULT_MODE);
            } else {
                this.gameMode.setGameModeForPlayer(ServerPlayer.readPlayerMode(nbt, "playerGameType"), ServerPlayer.readPlayerMode(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(ServerPlayer.readPlayerMode(nbt, "playerGameType")), ServerPlayer.readPlayerMode(nbt, "previousPlayerGameType"));
    }

    private void storeGameTypes(CompoundTag nbt) {
        nbt.putInt("playerGameType", this.gameMode.getGameModeForPlayer().getId());
        GameType enumgamemode = this.gameMode.getPreviousGameModeForPlayer();
        if (enumgamemode != null) {
            nbt.putInt("previousPlayerGameType", enumgamemode.getId());
        }
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(ServerPlayer player) {
        return player == this ? false : this.textFilteringEnabled || player.textFilteringEnabled;
    }

    @Override
    public boolean mayInteract(ServerLevel world, BlockPos pos) {
        return super.mayInteract(world, pos) && world.mayInteract(this, pos);
    }

    @Override
    protected void updateUsingItem(ItemStack stack) {
        CriteriaTriggers.USING_ITEM.trigger(this, stack);
        super.updateUsingItem(stack);
    }

    public boolean drop(boolean entireStack) {
        Inventory playerinventory = this.getInventory();
        ItemStack itemstack = playerinventory.removeFromSelected(entireStack);
        this.containerMenu.findSlot(playerinventory, playerinventory.selected).ifPresent(i -> this.containerMenu.setRemoteSlot(i, playerinventory.getSelected()));
        return this.drop(itemstack, false, true) != null;
    }

    @Override
    public void handleExtraItemsCreatedOnUse(ItemStack stack) {
        if (!this.getInventory().add(stack)) {
            this.drop(stack, false);
        }
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    public void setSpawnExtraParticlesOnFall(boolean spawnExtraParticlesOnFall) {
        this.spawnExtraParticlesOnFall = spawnExtraParticlesOnFall;
    }

    @Override
    public void onItemPickup(ItemEntity item) {
        super.onItemPickup(item);
        net.minecraft.world.entity.Entity entity = item.getOwner();
        if (entity != null) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, item.getItem(), entity);
        }
    }

    public void setChatSession(RemoteChatSession session) {
        this.chatSession = session;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        return this.chatSession != null && this.chatSession.hasExpired() ? null : this.chatSession;
    }

    @Override
    public void indicateDamage(double deltaX, double deltaZ) {
        this.hurtDir = (float)(Mth.atan2(deltaZ, deltaX) * 57.2957763671875 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(net.minecraft.world.entity.Entity entity, boolean force) {
        if (super.startRiding(entity, force)) {
            entity.positionRider(this);
            this.connection.teleport(new PositionMoveRotation(this.position(), Vec3.ZERO, 0.0f, 0.0f), Relative.ROTATION);
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                this.server.getPlayerList().sendActiveEffects(entityliving, this.connection);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stopRiding() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity entity = this.getVehicle();
        super.stopRiding(suppressCancellation);
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            for (MobEffectInstance mobeffect : entityliving.getActiveEffects()) {
                this.connection.send(new ClientboundRemoveMobEffectPacket(entity.getId(), mobeffect.getEffect()));
            }
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(ServerLevel world) {
        return new CommonPlayerSpawnInfo(world.dimensionTypeRegistration(), world.dimension(), BiomeManager.obfuscateSeed(world.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), world.isDebug(), world.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown(), world.getSeaLevel());
    }

    public void setRaidOmenPosition(BlockPos startRaidPos) {
        this.raidOmenPosition = startRaidPos;
    }

    public void clearRaidOmenPosition() {
        this.raidOmenPosition = null;
    }

    @Nullable
    public BlockPos getRaidOmenPosition() {
        return this.raidOmenPosition;
    }

    @Override
    public Vec3 getKnownMovement() {
        net.minecraft.world.entity.Entity entity = this.getVehicle();
        return entity != null && entity.getControllingPassenger() != this ? entity.getKnownMovement() : this.lastKnownClientMovement;
    }

    public void setKnownMovement(Vec3 movement) {
        this.lastKnownClientMovement = movement;
    }

    @Override
    protected float getEnchantedDamage(net.minecraft.world.entity.Entity target, float baseDamage, DamageSource damageSource) {
        return EnchantmentHelper.modifyDamage(this.serverLevel(), this.getWeaponItem(), target, damageSource, baseDamage);
    }

    @Override
    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EquipmentSlot slot) {
        super.onEquippedItemBroken(item, slot);
        this.awardStat(Stats.ITEM_BROKEN.get(item));
    }

    public Input getLastClientInput() {
        return this.lastClientInput;
    }

    public void setLastClientInput(Input playerInput) {
        this.lastClientInput = playerInput;
    }

    public Vec3 getLastClientMoveIntent() {
        float f;
        float f2 = this.lastClientInput.left() == this.lastClientInput.right() ? 0.0f : (f = this.lastClientInput.left() ? 1.0f : -1.0f);
        float f1 = this.lastClientInput.forward() == this.lastClientInput.backward() ? 0.0f : (this.lastClientInput.forward() ? 1.0f : -1.0f);
        return ServerPlayer.getInputVector(new Vec3(f, 0.0, f1), 1.0f, this.getYRot());
    }

    public void registerEnderPearl(ThrownEnderpearl enderPearl) {
        this.enderPearls.add(enderPearl);
    }

    public void deregisterEnderPearl(ThrownEnderpearl enderPearl) {
        this.enderPearls.remove(enderPearl);
    }

    public Set<ThrownEnderpearl> getEnderPearls() {
        return this.enderPearls;
    }

    public long registerAndUpdateEnderPearlTicket(ThrownEnderpearl enderPearl) {
        Level world = enderPearl.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ChunkPos chunkcoordintpair = enderPearl.chunkPosition();
            this.registerEnderPearl(enderPearl);
            worldserver.resetEmptyTime();
            return ServerPlayer.placeEnderPearlTicket(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long placeEnderPearlTicket(ServerLevel world, ChunkPos chunkPos) {
        if (!world.paperConfig().misc.legacyEnderPearlBehavior) {
            world.getChunkSource().addRegionTicket(TicketType.ENDER_PEARL, chunkPos, 2, chunkPos);
        }
        return TicketType.ENDER_PEARL.timeout();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.level().getDayTime() + this.timeOffset;
        }
        return this.level().getDayTime() - this.level().getDayTime() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f));
        } else {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, newThunder));
            } else {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = Mth.clamp(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.level().getLevelData().isRaining() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getScoreboardName() + " at " + this.getX() + "," + this.getY() + "," + this.getZ() + ")";
    }

    public void forceSetPositionRotation(double x, double y, double z, float yaw, float pitch) {
        this.moveTo(x, y, z, yaw, pitch);
        this.connection.resetPosition();
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() || this.connection != null && this.connection.isDisconnected();
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.experienceProgress;
            this.newTotalExp = this.totalExperience;
            this.newLevel = this.experienceLevel;
        }
        this.setHealth(this.getMaxHealth());
        this.stopUsingItem();
        this.setAirSupply(this.getMaxAirSupply());
        this.setRemainingFireTicks(0);
        this.fallDistance = 0.0f;
        this.foodData = new FoodData();
        this.experienceLevel = this.newLevel;
        this.totalExperience = this.newTotalExp;
        this.experienceProgress = 0.0f;
        this.deathTime = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.effectsDirty = true;
        this.containerMenu = this.inventoryMenu;
        this.lastHurtByPlayer = null;
        this.lastHurtByMob = null;
        this.combatTracker = new CombatTracker(this);
        this.lastSentExp = -1;
        if (this.keepLevel) {
            this.experienceProgress = exp;
        } else {
            this.giveExperiencePoints(this.newExp);
        }
        this.keepLevel = false;
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.skipDropExperience = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public void teleport(Location to) {
        this.ejectPassengers();
        this.stopRiding(true);
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer(InventoryCloseEvent.Reason.TELEPORT);
        }
        ServerLevel toLevel = ((CraftWorld)to.getWorld()).getHandle();
        if (this.level() == toLevel) {
            this.connection.teleport(to);
        } else {
            this.server.getPlayerList().respawn(this, true, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.DEATH, to);
        }
    }

    public boolean tpsBar() {
        return this.tpsBar;
    }

    public void tpsBar(boolean tpsBar) {
        this.tpsBar = tpsBar;
    }

    public boolean compassBar() {
        return this.compassBar;
    }

    public void compassBar(boolean compassBar) {
        this.compassBar = compassBar;
    }

    public boolean ramBar() {
        return this.ramBar;
    }

    public void ramBar(boolean ramBar) {
        this.ramBar = ramBar;
    }

    public record RespawnPosAngle(Vec3 position, float yaw, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3 vec3d, BlockPos blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.calculateLookAtYaw(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float calculateLookAtYaw(Vec3 respawnPos, BlockPos currentPos) {
            Vec3 vec3d1 = Vec3.atBottomCenterOf(currentPos).subtract(respawnPos).normalize();
            return (float)Mth.wrapDegrees(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
        }
    }
}

