/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class ThrottlingChunkTaskDispatcher
extends ChunkTaskDispatcher {
    private final LongSet chunkPositionsInExecution = new LongOpenHashSet();
    private final int maxChunksInExecution;
    private final String executorSchedulerName;

    public ThrottlingChunkTaskDispatcher(TaskScheduler<Runnable> executor, Executor dispatchExecutor, int maxConcurrentChunks) {
        super(executor, dispatchExecutor);
        this.maxChunksInExecution = maxConcurrentChunks;
        this.executorSchedulerName = executor.name();
    }

    @Override
    @Override
    protected void onRelease(long chunkPos) {
        this.chunkPositionsInExecution.remove(chunkPos);
    }

    @Override
    @Nullable
    @Override
    protected ChunkTaskPriorityQueue.TasksForChunk popTasks() {
        return this.chunkPositionsInExecution.size() < this.maxChunksInExecution ? super.popTasks() : null;
    }

    @Override
    @Override
    protected void scheduleForExecution(ChunkTaskPriorityQueue.TasksForChunk entry) {
        this.chunkPositionsInExecution.add(entry.chunkPos());
        super.scheduleForExecution(entry);
    }

    @VisibleForTesting
    public String getDebugStatus() {
        return this.executorSchedulerName + "=[" + this.chunkPositionsInExecution.stream().map(chunkPos -> chunkPos + ":" + String.valueOf(new ChunkPos((long)chunkPos))).collect(Collectors.joining(",")) + "], s=" + this.sleeping;
    }
}

