/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level.progress;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ProcessorChunkProgressListener
implements ChunkProgressListener {
    private final ChunkProgressListener delegate;
    private final ConsecutiveExecutor consecutiveExecutor;
    private boolean started;

    private ProcessorChunkProgressListener(ChunkProgressListener progressListener, Executor executor) {
        this.delegate = progressListener;
        this.consecutiveExecutor = new ConsecutiveExecutor(executor, "progressListener");
    }

    public static ProcessorChunkProgressListener createStarted(ChunkProgressListener progressListener, Executor executor) {
        ProcessorChunkProgressListener processorChunkProgressListener = new ProcessorChunkProgressListener(progressListener, executor);
        processorChunkProgressListener.start();
        return processorChunkProgressListener;
    }

    @Override
    @Override
    public void updateSpawnPos(ChunkPos spawnPos) {
        this.consecutiveExecutor.schedule(() -> this.delegate.updateSpawnPos(spawnPos));
    }

    @Override
    @Override
    public void onStatusChange(ChunkPos pos, @Nullable ChunkStatus status) {
        if (this.started) {
            this.consecutiveExecutor.schedule(() -> this.delegate.onStatusChange(pos, status));
        }
    }

    @Override
    @Override
    public void start() {
        this.started = true;
        this.consecutiveExecutor.schedule(this.delegate::start);
    }

    @Override
    @Override
    public void stop() {
        this.started = false;
        this.consecutiveExecutor.schedule(this.delegate::stop);
    }
}

