/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;

public class LegacyTextFilter
extends ServerTextFilter {
    private static final String ENDPOINT = "v1/chat";
    final URL joinEndpoint;
    final JoinOrLeaveEncoder joinEncoder;
    final URL leaveEndpoint;
    final JoinOrLeaveEncoder leaveEncoder;
    private final String authKey;

    private LegacyTextFilter(URL chatEndpoint, ServerTextFilter.MessageEncoder messageEncoder, URL joinEndpoint, JoinOrLeaveEncoder joinEncoder, URL leaveEndpoint, JoinOrLeaveEncoder leaveEncoder, String apiKey, ServerTextFilter.IgnoreStrategy ignorer, ExecutorService threadPool) {
        super(chatEndpoint, messageEncoder, ignorer, threadPool);
        this.joinEndpoint = joinEndpoint;
        this.joinEncoder = joinEncoder;
        this.leaveEndpoint = leaveEndpoint;
        this.leaveEncoder = leaveEncoder;
        this.authKey = apiKey;
    }

    @Nullable
    public static ServerTextFilter createTextFilterFromConfig(String config) {
        try {
            ServerTextFilter.MessageEncoder messageEncoder2;
            JsonObject jsonObject = GsonHelper.parse(config);
            URI uRI = new URI(GsonHelper.getAsString(jsonObject, "apiServer"));
            String string = GsonHelper.getAsString(jsonObject, "apiKey");
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int i = GsonHelper.getAsInt(jsonObject, "ruleId", 1);
            String string2 = GsonHelper.getAsString(jsonObject, "serverId", "");
            String string3 = GsonHelper.getAsString(jsonObject, "roomId", "Java:Chat");
            int j = GsonHelper.getAsInt(jsonObject, "hashesToDrop", -1);
            int k = GsonHelper.getAsInt(jsonObject, "maxConcurrentRequests", 7);
            JsonObject jsonObject2 = GsonHelper.getAsJsonObject(jsonObject, "endpoints", null);
            String string4 = LegacyTextFilter.getEndpointFromConfig(jsonObject2, "chat", ENDPOINT);
            boolean bl = string4.equals(ENDPOINT);
            URL uRL = uRI.resolve("/" + string4).toURL();
            URL uRL2 = LegacyTextFilter.getEndpoint(uRI, jsonObject2, "join", "v1/join");
            URL uRL3 = LegacyTextFilter.getEndpoint(uRI, jsonObject2, "leave", "v1/leave");
            JoinOrLeaveEncoder joinOrLeaveEncoder = profile -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("server", string2);
                jsonObject.addProperty("room", string3);
                jsonObject.addProperty("user_id", profile.getId().toString());
                jsonObject.addProperty("user_display_name", profile.getName());
                return jsonObject;
            };
            if (bl) {
                ServerTextFilter.MessageEncoder messageEncoder = (profile, message) -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("rule", (Number)i);
                    jsonObject.addProperty("server", string2);
                    jsonObject.addProperty("room", string3);
                    jsonObject.addProperty("player", profile.getId().toString());
                    jsonObject.addProperty("player_display_name", profile.getName());
                    jsonObject.addProperty("text", message);
                    jsonObject.addProperty("language", "*");
                    return jsonObject;
                };
            } else {
                String string5 = String.valueOf(i);
                messageEncoder2 = (profile, message) -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("rule_id", string5);
                    jsonObject.addProperty("category", string2);
                    jsonObject.addProperty("subcategory", string3);
                    jsonObject.addProperty("user_id", profile.getId().toString());
                    jsonObject.addProperty("user_display_name", profile.getName());
                    jsonObject.addProperty("text", message);
                    jsonObject.addProperty("language", "*");
                    return jsonObject;
                };
            }
            ServerTextFilter.IgnoreStrategy ignoreStrategy = ServerTextFilter.IgnoreStrategy.select(j);
            ExecutorService executorService = LegacyTextFilter.createWorkerPool(k);
            String string6 = Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.US_ASCII));
            return new LegacyTextFilter(uRL, messageEncoder2, uRL2, joinOrLeaveEncoder, uRL3, joinOrLeaveEncoder, string6, ignoreStrategy, executorService);
        }
        catch (Exception exception) {
            ServerTextFilter.LOGGER.warn("Failed to parse chat filter config {}", (Object)config, (Object)exception);
            return null;
        }
    }

    @Override
    @Override
    public TextFilter createContext(GameProfile profile) {
        return new ServerTextFilter.PlayerContext(profile){

            @Override
            @Override
            public void join() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.joinEndpoint, LegacyTextFilter.this.joinEncoder, this.streamExecutor);
            }

            @Override
            @Override
            public void leave() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.leaveEndpoint, LegacyTextFilter.this.leaveEncoder, this.streamExecutor);
            }
        };
    }

    void processJoinOrLeave(GameProfile gameProfile, URL endpoint, JoinOrLeaveEncoder profileEncoder, Executor executor) {
        executor.execute(() -> {
            JsonObject jsonObject = profileEncoder.encode(gameProfile);
            try {
                this.processRequest(jsonObject, endpoint);
            }
            catch (Exception exception) {
                ServerTextFilter.LOGGER.warn("Failed to send join/leave packet to {} for player {}", new Object[]{endpoint, gameProfile, exception});
            }
        });
    }

    private void processRequest(JsonObject payload, URL endpoint) throws IOException {
        HttpURLConnection httpURLConnection = this.makeRequest(payload, endpoint);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            this.drainStream(inputStream);
        }
    }

    @Override
    @Override
    protected void setAuthorizationProperty(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", "Basic " + this.authKey);
    }

    @Override
    @Override
    protected FilteredText filterText(String raw, ServerTextFilter.IgnoreStrategy hashIgnorer, JsonObject response) {
        boolean bl = GsonHelper.getAsBoolean(response, "response", false);
        if (bl) {
            return FilteredText.passThrough(raw);
        }
        String string = GsonHelper.getAsString(response, "hashed", null);
        if (string == null) {
            return FilteredText.fullyFiltered(raw);
        }
        JsonArray jsonArray = GsonHelper.getAsJsonArray(response, "hashes");
        FilterMask filterMask = this.parseMask(raw, jsonArray, hashIgnorer);
        return new FilteredText(raw, filterMask);
    }

    @FunctionalInterface
    static interface JoinOrLeaveEncoder {
        public JsonObject encode(GameProfile var1);
    }
}

