/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public ProfiledReloadInstance(ResourceManager manager, List<PreparableReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        super(prepareExecutor, applyExecutor, manager, reloaders, (preparationBarrier, resourceManager, preparableReloadListener, executor2, executor3) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong2 = new AtomicLong();
            CompletableFuture<Void> completableFuture = preparableReloadListener.reload(preparationBarrier, resourceManager, ProfiledReloadInstance.profiledExecutor(executor2, atomicLong, preparableReloadListener.getName()), ProfiledReloadInstance.profiledExecutor(executor3, atomicLong2, preparableReloadListener.getName()));
            return completableFuture.thenApplyAsync(void_ -> {
                LOGGER.debug("Finished reloading {}", (Object)preparableReloadListener.getName());
                return new State(preparableReloadListener.getName(), atomicLong, atomicLong2);
            }, applyExecutor);
        }, initialStage);
        this.total.start();
        this.allDone = this.allDone.thenApplyAsync(this::finish, applyExecutor);
    }

    private static Executor profiledExecutor(Executor executor, AtomicLong atomicLong, String string) {
        return runnable -> executor.execute(() -> {
            ProfilerFiller profilerFiller = Profiler.get();
            profilerFiller.push(string);
            long l = Util.getNanos();
            runnable.run();
            atomicLong.addAndGet(Util.getNanos() - l);
            profilerFiller.pop();
        });
    }

    private List<State> finish(List<State> summaries) {
        this.total.stop();
        long l = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (State state : summaries) {
            long m = TimeUnit.NANOSECONDS.toMillis(state.preparationNanos.get());
            long n = TimeUnit.NANOSECONDS.toMillis(state.reloadNanos.get());
            long o = m + n;
            String string = state.name;
            LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{string, o, m, n});
            l += n;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)l);
        return summaries;
    }

    public record State(String name, AtomicLong preparationNanos, AtomicLong reloadNanos) {
    }
}

