/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DynamicOps<JsonElement> ops;
    private final Codec<T> codec;
    private final String directory;

    protected SimpleJsonResourceReloadListener(HolderLookup.Provider registries, Codec<T> codec, String dataType) {
        this(registries.createSerializationContext(JsonOps.INSTANCE), codec, dataType);
    }

    protected SimpleJsonResourceReloadListener(Codec<T> codec, String dataType) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, codec, dataType);
    }

    private SimpleJsonResourceReloadListener(DynamicOps<JsonElement> ops, Codec<T> codec, String dataType) {
        this.ops = ops;
        this.codec = codec;
        this.directory = dataType;
    }

    @Override
    @Override
    protected Map<ResourceLocation, T> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap map = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory(resourceManager, this.directory, this.ops, this.codec, map);
        return map;
    }

    public static <T> void scanDirectory(ResourceManager manager, String dataType, DynamicOps<JsonElement> ops, Codec<T> codec, Map<ResourceLocation, T> result) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.json(dataType);
        for (Map.Entry<ResourceLocation, Resource> entry : fileToIdConverter.listMatchingResources(manager).entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            try {
                BufferedReader reader = entry.getValue().openAsReader();
                try {
                    codec.parse(ops, (Object)JsonParser.parseReader((Reader)reader)).ifSuccess(value -> {
                        if (result.putIfAbsent(resourceLocation2, value) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation2));
                        }
                    }).ifError(error -> LOGGER.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{resourceLocation2, resourceLocation, error}));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file '{}' from '{}'", new Object[]{resourceLocation2, resourceLocation, exception});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager manager, ProfilerFiller profiler) {
        return this.prepare(manager, profiler);
    }
}

