/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> categoryOptions) {
        this.states = categoryOptions;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private TypeSettings getSettings(RecipeBookType category) {
        return this.states.getOrDefault((Object)category, TypeSettings.DEFAULT);
    }

    private void updateSettings(RecipeBookType category, UnaryOperator<TypeSettings> modifier) {
        this.states.compute(category, (key, value) -> {
            if (value == null) {
                value = TypeSettings.DEFAULT;
            }
            if ((value = (TypeSettings)modifier.apply((TypeSettings)value)).equals(TypeSettings.DEFAULT)) {
                value = null;
            }
            return value;
        });
    }

    public boolean isOpen(RecipeBookType category) {
        return this.getSettings((RecipeBookType)category).open;
    }

    public void setOpen(RecipeBookType category, boolean open) {
        this.updateSettings(category, option -> option.setOpen(open));
    }

    public boolean isFiltering(RecipeBookType category) {
        return this.getSettings((RecipeBookType)category).filtering;
    }

    public void setFiltering(RecipeBookType category, boolean filtering) {
        this.updateSettings(category, option -> option.setFiltering(filtering));
    }

    private static RecipeBookSettings read(FriendlyByteBuf buf) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean bl = buf.readBoolean();
            boolean bl2 = buf.readBoolean();
            if (!bl && !bl2) continue;
            map.put(recipeBookType, new TypeSettings(bl, bl2));
        }
        return new RecipeBookSettings(map);
    }

    private void write(FriendlyByteBuf buf) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            TypeSettings typeSettings = this.states.getOrDefault((Object)recipeBookType, TypeSettings.DEFAULT);
            buf.writeBoolean(typeSettings.open);
            buf.writeBoolean(typeSettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag nbt) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        TAG_FIELDS.forEach((category, pair) -> {
            boolean bl = nbt.getBoolean((String)pair.getFirst());
            boolean bl2 = nbt.getBoolean((String)pair.getSecond());
            if (bl || bl2) {
                map.put((RecipeBookType)((Object)category), new TypeSettings(bl, bl2));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag nbt) {
        TAG_FIELDS.forEach((category, pair) -> {
            TypeSettings typeSettings = this.states.getOrDefault(category, TypeSettings.DEFAULT);
            nbt.putBoolean((String)pair.getFirst(), typeSettings.open);
            nbt.putBoolean((String)pair.getSecond(), typeSettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, TypeSettings>(this.states));
    }

    public void replaceFrom(RecipeBookSettings other) {
        this.states.clear();
        this.states.putAll(other.states);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)object).states);
    }

    @Override
    public int hashCode() {
        return this.states.hashCode();
    }

    record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);

        @Override
        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean guiOpen) {
            return new TypeSettings(guiOpen, this.filtering);
        }

        public TypeSettings setFiltering(boolean filteringCraftable) {
            return new TypeSettings(this.open, filteringCraftable);
        }
    }
}

