/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;

public class BinaryAnimator {
    private final int animationLength;
    private final EasingFunction easingFunction;
    private int ticks;
    private int ticksOld;

    public BinaryAnimator(int frames, EasingFunction smoothingFunction) {
        this.animationLength = frames;
        this.easingFunction = smoothingFunction;
    }

    public BinaryAnimator(int frames) {
        this(frames, tickDelta -> tickDelta);
    }

    public void tick(boolean active) {
        this.ticksOld = this.ticks;
        if (active) {
            if (this.ticks < this.animationLength) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            --this.ticks;
        }
    }

    public float getFactor(float tickDelta) {
        float f = Mth.lerp(tickDelta, this.ticksOld, this.ticks) / (float)this.animationLength;
        return this.easingFunction.apply(f);
    }

    public static interface EasingFunction {
        public float apply(float var1);
    }
}

