/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.function.Function;

public interface ToFloatFunction<C> {
    public static final ToFloatFunction<Float> IDENTITY = ToFloatFunction.createUnlimited(value -> value);

    public float apply(C var1);

    public float minValue();

    public float maxValue();

    public static ToFloatFunction<Float> createUnlimited(final Float2FloatFunction delegate) {
        return new ToFloatFunction<Float>(){

            @Override
            @Override
            public float apply(Float x) {
                return ((Float)delegate.apply((Object)x)).floatValue();
            }

            @Override
            @Override
            public float minValue() {
                return Float.NEGATIVE_INFINITY;
            }

            @Override
            @Override
            public float maxValue() {
                return Float.POSITIVE_INFINITY;
            }
        };
    }

    default public <C2> ToFloatFunction<C2> comap(final Function<C2, C> before) {
        final ToFloatFunction toFloatFunction = this;
        return new ToFloatFunction<C2>(this){

            @Override
            @Override
            public float apply(C2 x) {
                return toFloatFunction.apply(before.apply(x));
            }

            @Override
            @Override
            public float minValue() {
                return toFloatFunction.minValue();
            }

            @Override
            @Override
            public float maxValue() {
                return toFloatFunction.maxValue();
            }
        };
    }
}

